/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;

public class GlsEntryFieldValue
extends ControlSequence {
    private Bib2Gls bib2gls;
    private String fieldLabel;
    public static final int CASE_NO_CHANGE = 0;
    public static final int CASE_SENTENCE = 1;
    public static final int CASE_TO_UPPER = 2;
    private int caseChange = 0;

    public GlsEntryFieldValue(String string, String string2, Bib2Gls bib2Gls) {
        this(string, string2, 0, bib2Gls);
    }

    public GlsEntryFieldValue(String string, String string2, int n, Bib2Gls bib2Gls) {
        super(string);
        this.fieldLabel = string2;
        this.caseChange = n;
        this.bib2gls = bib2Gls;
    }

    @Override
    public Object clone() {
        return new GlsEntryFieldValue(this.getName(), this.fieldLabel, this.caseChange, this.bib2gls);
    }

    private void process(TeXParser teXParser, TeXObjectList teXObjectList, String string) throws IOException {
        Bib2GlsEntry bib2GlsEntry = this.bib2gls.getCurrentResource().getEntry(string);
        if (bib2GlsEntry == null) {
            return;
        }
        BibValueList bibValueList = bib2GlsEntry.getField(this.fieldLabel);
        if (bibValueList == null) {
            bibValueList = bib2GlsEntry.getFallbackContents(this.fieldLabel);
        }
        if (bibValueList == null) {
            return;
        }
        TeXObjectList teXObjectList2 = ((BibValueList)bibValueList.clone()).expand(teXParser);
        switch (this.caseChange) {
            case 1: {
                GlsResource.toSentenceCase(teXObjectList2);
                break;
            }
            case 2: {
                GlsResource.toUpperCase(teXObjectList2);
            }
        }
        teXObjectList.push(teXObjectList2);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObject teXObject = teXParser.popNextArg();
        this.process(teXParser, teXParser, teXObject.toString(teXParser));
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = teXObjectList.popArg(teXParser);
        this.process(teXParser, teXObjectList, teXObject.toString(teXParser));
    }
}

