"use strict";
/// <reference path="../../typings/main.d.ts" />
Object.defineProperty(exports, "__esModule", { value: true });
function isEmpty(value) {
    return value == null;
}
function toString(value) {
    return isEmpty(value) ? '' : String(value);
}
function toBoolean(value) {
    return [0, false, '', '0', 'false'].indexOf(value) === -1;
}
function toNumber(value) {
    return isFinite(value) ? Number(value) : null;
}
function toInteger(value) {
    return value % 1 === 0 ? Number(value) : null;
}
function toDate(value) {
    return !isNaN(Date.parse(value)) ? new Date(value) : null;
}
function toSanitization(parameter, rules, types) {
    var parameters = Array.isArray(parameter) ? parameter : [parameter];
    var sanitizations = parameters.map(function (parameter) {
        var fns = [];
        var typeSanitization = types[parameter.type];
        if (typeof typeSanitization === 'function') {
            fns.push(typeSanitization);
        }
        Object.keys(parameter)
            .filter(function (key) {
            return key !== 'type' && key !== 'repeat' && key !== 'default';
        })
            .forEach(function (key) {
            var fn = rules[key];
            if (typeof fn === 'function') {
                fns.push(fn(parameter[key], key));
            }
        });
        function sanitize(value, key, src) {
            for (var i = 0; i < fns.length; i++) {
                var fn = fns[i];
                var value = fn(value, key, src);
                if (value != null) {
                    return value;
                }
            }
            return null;
        }
        return function (value, key, src) {
            if (isEmpty(value)) {
                if (parameter.default != null) {
                    return sanitize(parameter.default, key, src);
                }
                return parameter.repeat && !parameter.required ? [] : value;
            }
            if (parameter.repeat) {
                var values = Array.isArray(value) ? value : [value];
                values = values.map(function (value) {
                    return sanitize(value, key, src);
                });
                return values.some(isEmpty) ? null : value;
            }
            if (Array.isArray(value)) {
                if (value.length > 1) {
                    return null;
                }
                value = value[0];
            }
            return sanitize(value, key, src);
        };
    });
    return function (value, key, src) {
        for (var i = 0; i < sanitizations.length; i++) {
            var sanitization = sanitizations[i];
            var result = sanitization(value, key, src);
            if (result != null) {
                return result;
            }
        }
        return value;
    };
}
function sanitize() {
    var RULES = {};
    var TYPES = {
        string: toString,
        number: toNumber,
        integer: toInteger,
        boolean: toBoolean,
        date: toDate
    };
    function rule(parameter) {
        return toSanitization(parameter, RULES, TYPES);
    }
    var sanitize = function (parameterMap) {
        if (!parameterMap) {
            return function () {
                return {};
            };
        }
        var sanitizations = {};
        Object.keys(parameterMap).forEach(function (key) {
            sanitizations[key] = sanitize.rule(parameterMap[key]);
        });
        return function (src) {
            src = src || {};
            var dest = {};
            // Iterate the sanitized parameters to get a clean model.
            Object.keys(sanitizations).forEach(function (key) {
                var value = src[key];
                var fn = sanitizations[key];
                if (Object.prototype.hasOwnProperty.call(src, key)) {
                    dest[key] = fn(value, key, src);
                }
            });
            return dest;
        };
    };
    var s;
    s = sanitize;
    s.rule = rule;
    s.TYPES = TYPES;
    s.RULES = RULES;
    return s;
}
exports.sanitize = sanitize;
// export = sanitize 
//# sourceMappingURL=raml-sanitize.js.map