/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.painless.DefBootstrap;
import org.elasticsearch.painless.FunctionRef;
import org.elasticsearch.painless.LambdaBootstrap;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;

public final class Def {
    private static final MethodHandle MAP_GET;
    private static final MethodHandle MAP_PUT;
    private static final MethodHandle LIST_GET;
    private static final MethodHandle LIST_SET;
    private static final MethodHandle ITERATOR;
    private static final MethodHandle MAP_INDEX_NORMALIZE;
    private static final MethodHandle LIST_INDEX_NORMALIZE;
    static final MethodHandle JAVA9_ARRAY_LENGTH_MH_FACTORY;

    static <T extends Throwable> void rethrow(Throwable t) throws T {
        throw t;
    }

    static MethodHandle arrayLengthGetter(Class<?> arrayType) {
        if (JAVA9_ARRAY_LENGTH_MH_FACTORY != null) {
            try {
                return JAVA9_ARRAY_LENGTH_MH_FACTORY.invokeExact(arrayType);
            }
            catch (Throwable t) {
                Def.rethrow(t);
                throw new AssertionError((Object)t);
            }
        }
        return ArrayLengthHelper.arrayLengthGetter(arrayType);
    }

    static MethodHandle lookupMethod(PainlessLookup painlessLookup, Map<String, Locals.LocalMethod> localMethods, MethodHandles.Lookup methodHandlesLookup, MethodType callSiteType, Class<?> receiverClass, String name, Object[] args) throws Throwable {
        String recipeString = (String)args[0];
        int numArguments = callSiteType.parameterCount();
        if (recipeString.isEmpty()) {
            PainlessMethod painlessMethod = painlessLookup.lookupRuntimePainlessMethod(receiverClass, name, numArguments - 1);
            if (painlessMethod == null) {
                throw new IllegalArgumentException("dynamic method [" + PainlessLookupUtility.typeToCanonicalTypeName(receiverClass) + ", " + name + "/" + (numArguments - 1) + "] not found");
            }
            return painlessMethod.methodHandle;
        }
        BitSet lambdaArgs = new BitSet(recipeString.length());
        for (int i = 0; i < recipeString.length(); ++i) {
            lambdaArgs.set(recipeString.charAt(i));
        }
        int arity = callSiteType.parameterCount() - 1;
        int upTo = 1;
        for (int i = 1; i < numArguments; ++i) {
            if (!lambdaArgs.get(i - 1)) continue;
            String signature = (String)args[upTo++];
            int numCaptures = Integer.parseInt(signature.substring(signature.indexOf(44) + 1));
            arity -= numCaptures;
        }
        PainlessMethod method = painlessLookup.lookupRuntimePainlessMethod(receiverClass, name, arity);
        if (method == null) {
            throw new IllegalArgumentException("dynamic method [" + PainlessLookupUtility.typeToCanonicalTypeName(receiverClass) + ", " + name + "/" + arity + "] not found");
        }
        MethodHandle handle = method.methodHandle;
        int replaced = 0;
        upTo = 1;
        for (int i = 1; i < numArguments; ++i) {
            MethodHandle filter;
            if (!lambdaArgs.get(i - 1)) continue;
            String signature = (String)args[upTo++];
            int separator = signature.lastIndexOf(46);
            int separator2 = signature.indexOf(44);
            String type = signature.substring(1, separator);
            String call = signature.substring(separator + 1, separator2);
            int numCaptures = Integer.parseInt(signature.substring(separator2 + 1));
            Class<?> interfaceType = method.typeParameters.get(i - 1 - replaced);
            if (signature.charAt(0) == 'S') {
                filter = Def.lookupReferenceInternal(painlessLookup, localMethods, methodHandlesLookup, interfaceType, type, call, numCaptures);
            } else if (signature.charAt(0) == 'D') {
                Class[] captures = new Class[numCaptures];
                for (int capture = 0; capture < captures.length; ++capture) {
                    captures[capture] = callSiteType.parameterType(i + 1 + capture);
                }
                MethodType nestedType = MethodType.methodType(interfaceType, captures);
                CallSite nested = DefBootstrap.bootstrap(painlessLookup, localMethods, methodHandlesLookup, call, nestedType, 0, 6, PainlessLookupUtility.typeToCanonicalTypeName(interfaceType));
                filter = nested.dynamicInvoker();
            } else {
                throw new AssertionError();
            }
            filter = MethodHandles.dropArguments(filter, 0, new Class[]{String.class});
            handle = MethodHandles.collectArguments(handle, i, filter);
            i += numCaptures;
            replaced += numCaptures;
        }
        return handle;
    }

    static MethodHandle lookupReference(PainlessLookup painlessLookup, Map<String, Locals.LocalMethod> localMethods, MethodHandles.Lookup methodHandlesLookup, String interfaceClass, Class<?> receiverClass, String name) throws Throwable {
        Class<?> interfaceType = painlessLookup.canonicalTypeNameToType(interfaceClass);
        if (interfaceType == null) {
            throw new IllegalArgumentException("type [" + interfaceClass + "] not found");
        }
        PainlessMethod interfaceMethod = painlessLookup.lookupFunctionalInterfacePainlessMethod(interfaceType);
        if (interfaceMethod == null) {
            throw new IllegalArgumentException("Class [" + interfaceClass + "] is not a functional interface");
        }
        int arity = interfaceMethod.typeParameters.size();
        PainlessMethod implMethod = painlessLookup.lookupRuntimePainlessMethod(receiverClass, name, arity);
        if (implMethod == null) {
            throw new IllegalArgumentException("dynamic method [" + PainlessLookupUtility.typeToCanonicalTypeName(receiverClass) + ", " + name + "/" + arity + "] not found");
        }
        return Def.lookupReferenceInternal(painlessLookup, localMethods, methodHandlesLookup, interfaceType, PainlessLookupUtility.typeToCanonicalTypeName(implMethod.targetClass), implMethod.javaMethod.getName(), 1);
    }

    private static MethodHandle lookupReferenceInternal(PainlessLookup painlessLookup, Map<String, Locals.LocalMethod> localMethods, MethodHandles.Lookup methodHandlesLookup, Class<?> clazz, String type, String call, int captures) throws Throwable {
        FunctionRef ref = FunctionRef.create(painlessLookup, localMethods, null, clazz, type, call, captures);
        CallSite callSite = LambdaBootstrap.lambdaBootstrap(methodHandlesLookup, ref.interfaceMethodName, ref.factoryMethodType, ref.interfaceMethodType, ref.delegateClassName, ref.delegateInvokeType, ref.delegateMethodName, ref.delegateMethodType, ref.isDelegateInterface ? 1 : 0);
        return callSite.dynamicInvoker().asType(MethodType.methodType(clazz, ref.factoryMethodType.parameterArray()));
    }

    static MethodHandle lookupGetter(PainlessLookup painlessLookup, Class<?> receiverClass, String name) {
        MethodHandle getter = painlessLookup.lookupRuntimeGetterMethodHandle(receiverClass, name);
        if (getter != null) {
            return getter;
        }
        if (receiverClass.isArray() && "length".equals(name)) {
            return Def.arrayLengthGetter(receiverClass);
        }
        if (Map.class.isAssignableFrom(receiverClass)) {
            return MethodHandles.insertArguments(MAP_GET, 1, name);
        }
        if (List.class.isAssignableFrom(receiverClass)) {
            try {
                int index = Integer.parseInt(name);
                return MethodHandles.insertArguments(LIST_GET, 1, index);
            }
            catch (NumberFormatException exception) {
                throw new IllegalArgumentException("Illegal list shortcut value [" + name + "].");
            }
        }
        throw new IllegalArgumentException("dynamic getter [" + PainlessLookupUtility.typeToCanonicalTypeName(receiverClass) + ", " + name + "] not found");
    }

    static MethodHandle lookupSetter(PainlessLookup painlessLookup, Class<?> receiverClass, String name) {
        MethodHandle setter = painlessLookup.lookupRuntimeSetterMethodHandle(receiverClass, name);
        if (setter != null) {
            return setter;
        }
        if (Map.class.isAssignableFrom(receiverClass)) {
            return MethodHandles.insertArguments(MAP_PUT, 1, name);
        }
        if (List.class.isAssignableFrom(receiverClass)) {
            try {
                int index = Integer.parseInt(name);
                return MethodHandles.insertArguments(LIST_SET, 1, index);
            }
            catch (NumberFormatException exception) {
                throw new IllegalArgumentException("Illegal list shortcut value [" + name + "].");
            }
        }
        throw new IllegalArgumentException("dynamic getter [" + PainlessLookupUtility.typeToCanonicalTypeName(receiverClass) + ", " + name + "] not found");
    }

    static MethodHandle lookupIndexNormalize(Class<?> receiverClass) {
        if (receiverClass.isArray()) {
            return ArrayIndexNormalizeHelper.arrayIndexNormalizer(receiverClass);
        }
        if (Map.class.isAssignableFrom(receiverClass)) {
            return MAP_INDEX_NORMALIZE;
        }
        if (List.class.isAssignableFrom(receiverClass)) {
            return LIST_INDEX_NORMALIZE;
        }
        throw new IllegalArgumentException("Attempting to address a non-array-like type [" + receiverClass.getCanonicalName() + "] as an array.");
    }

    static MethodHandle lookupArrayStore(Class<?> receiverClass) {
        if (receiverClass.isArray()) {
            return MethodHandles.arrayElementSetter(receiverClass);
        }
        if (Map.class.isAssignableFrom(receiverClass)) {
            return MAP_PUT;
        }
        if (List.class.isAssignableFrom(receiverClass)) {
            return LIST_SET;
        }
        throw new IllegalArgumentException("Attempting to address a non-array type [" + receiverClass.getCanonicalName() + "] as an array.");
    }

    static MethodHandle lookupArrayLoad(Class<?> receiverClass) {
        if (receiverClass.isArray()) {
            return MethodHandles.arrayElementGetter(receiverClass);
        }
        if (Map.class.isAssignableFrom(receiverClass)) {
            return MAP_GET;
        }
        if (List.class.isAssignableFrom(receiverClass)) {
            return LIST_GET;
        }
        throw new IllegalArgumentException("Attempting to address a non-array type [" + receiverClass.getCanonicalName() + "] as an array.");
    }

    static MethodHandle lookupIterator(Class<?> receiverClass) {
        if (Iterable.class.isAssignableFrom(receiverClass)) {
            return ITERATOR;
        }
        if (receiverClass.isArray()) {
            return ArrayIteratorHelper.newIterator(receiverClass);
        }
        throw new IllegalArgumentException("Cannot iterate over [" + receiverClass.getCanonicalName() + "]");
    }

    public static boolean DefToboolean(Object value) {
        return (Boolean)value;
    }

    public static byte DefTobyteImplicit(Object value) {
        return (Byte)value;
    }

    public static short DefToshortImplicit(Object value) {
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        return (Short)value;
    }

    public static char DefTocharImplicit(Object value) {
        if (value instanceof Byte) {
            return (char)((Byte)value).byteValue();
        }
        return ((Character)value).charValue();
    }

    public static int DefTointImplicit(Object value) {
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        return (Integer)value;
    }

    public static long DefTolongImplicit(Object value) {
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        return (Long)value;
    }

    public static float DefTofloatImplicit(Object value) {
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return ((Long)value).longValue();
        }
        return ((Float)value).floatValue();
    }

    public static double DefTodoubleImplicit(Object value) {
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return ((Long)value).longValue();
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        return (Double)value;
    }

    public static byte DefTobyteExplicit(Object value) {
        if (value instanceof Character) {
            return (byte)((Character)value).charValue();
        }
        return ((Number)value).byteValue();
    }

    public static short DefToshortExplicit(Object value) {
        if (value instanceof Character) {
            return (short)((Character)value).charValue();
        }
        return ((Number)value).shortValue();
    }

    public static char DefTocharExplicit(Object value) {
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        return (char)((Number)value).intValue();
    }

    public static int DefTointExplicit(Object value) {
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        return ((Number)value).intValue();
    }

    public static long DefTolongExplicit(Object value) {
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        return ((Number)value).longValue();
    }

    public static float DefTofloatExplicit(Object value) {
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        return ((Number)value).floatValue();
    }

    public static double DefTodoubleExplicit(Object value) {
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        return ((Number)value).doubleValue();
    }

    public static Object mapIndexNormalize(Map<?, ?> value, Object index) {
        return index;
    }

    public static int listIndexNormalize(List<?> value, int index) {
        return index >= 0 ? index : value.size() + index;
    }

    static {
        MethodHandle arrayLengthMHFactory;
        MethodHandles.Lookup methodHandlesLookup = MethodHandles.publicLookup();
        try {
            MAP_GET = methodHandlesLookup.findVirtual(Map.class, "get", MethodType.methodType(Object.class, Object.class));
            MAP_PUT = methodHandlesLookup.findVirtual(Map.class, "put", MethodType.methodType(Object.class, Object.class, Object.class));
            LIST_GET = methodHandlesLookup.findVirtual(List.class, "get", MethodType.methodType(Object.class, Integer.TYPE));
            LIST_SET = methodHandlesLookup.findVirtual(List.class, "set", MethodType.methodType(Object.class, Integer.TYPE, Object.class));
            ITERATOR = methodHandlesLookup.findVirtual(Iterable.class, "iterator", MethodType.methodType(Iterator.class));
            MAP_INDEX_NORMALIZE = methodHandlesLookup.findStatic(Def.class, "mapIndexNormalize", MethodType.methodType(Object.class, Map.class, Object.class));
            LIST_INDEX_NORMALIZE = methodHandlesLookup.findStatic(Def.class, "listIndexNormalize", MethodType.methodType(Integer.TYPE, List.class, Integer.TYPE));
        }
        catch (ReflectiveOperationException roe) {
            throw new AssertionError((Object)roe);
        }
        try {
            arrayLengthMHFactory = methodHandlesLookup.findStatic(MethodHandles.class, "arrayLength", MethodType.methodType(MethodHandle.class, Class.class));
        }
        catch (ReflectiveOperationException roe) {
            arrayLengthMHFactory = null;
        }
        JAVA9_ARRAY_LENGTH_MH_FACTORY = arrayLengthMHFactory;
    }

    private static final class ArrayIndexNormalizeHelper {
        private static final MethodHandles.Lookup PRIVATE_METHOD_HANDLES_LOOKUP = MethodHandles.lookup();
        private static final Map<Class<?>, MethodHandle> ARRAY_TYPE_MH_MAPPING = Collections.unmodifiableMap(Stream.of(boolean[].class, byte[].class, short[].class, int[].class, long[].class, char[].class, float[].class, double[].class, Object[].class).collect(Collectors.toMap(Function.identity(), type -> {
            try {
                return PRIVATE_METHOD_HANDLES_LOOKUP.findStatic(PRIVATE_METHOD_HANDLES_LOOKUP.lookupClass(), "normalizeIndex", MethodType.methodType(Integer.TYPE, type, Integer.TYPE));
            }
            catch (ReflectiveOperationException e) {
                throw new AssertionError((Object)e);
            }
        })));
        private static final MethodHandle OBJECT_ARRAY_MH = ARRAY_TYPE_MH_MAPPING.get(Object[].class);

        static int normalizeIndex(boolean[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(byte[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(short[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(int[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(long[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(char[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(float[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(double[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(Object[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static MethodHandle arrayIndexNormalizer(Class<?> arrayType) {
            if (!arrayType.isArray()) {
                throw new IllegalArgumentException("type must be an array");
            }
            return ARRAY_TYPE_MH_MAPPING.containsKey(arrayType) ? ARRAY_TYPE_MH_MAPPING.get(arrayType) : OBJECT_ARRAY_MH.asType(OBJECT_ARRAY_MH.type().changeParameterType(0, arrayType));
        }

        private ArrayIndexNormalizeHelper() {
        }
    }

    private static final class ArrayIteratorHelper {
        private static final MethodHandles.Lookup PRIVATE_METHOD_HANDLES_LOOKUP = MethodHandles.lookup();
        private static final Map<Class<?>, MethodHandle> ARRAY_TYPE_MH_MAPPING = Collections.unmodifiableMap(Stream.of(boolean[].class, byte[].class, short[].class, int[].class, long[].class, char[].class, float[].class, double[].class, Object[].class).collect(Collectors.toMap(Function.identity(), type -> {
            try {
                return PRIVATE_METHOD_HANDLES_LOOKUP.findStatic(PRIVATE_METHOD_HANDLES_LOOKUP.lookupClass(), "iterator", MethodType.methodType(Iterator.class, type));
            }
            catch (ReflectiveOperationException e) {
                throw new AssertionError((Object)e);
            }
        })));
        private static final MethodHandle OBJECT_ARRAY_MH = ARRAY_TYPE_MH_MAPPING.get(Object[].class);

        static Iterator<Boolean> iterator(final boolean[] array) {
            return new Iterator<Boolean>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Boolean next() {
                    return array[this.index++];
                }
            };
        }

        static Iterator<Byte> iterator(final byte[] array) {
            return new Iterator<Byte>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Byte next() {
                    return array[this.index++];
                }
            };
        }

        static Iterator<Short> iterator(final short[] array) {
            return new Iterator<Short>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Short next() {
                    return array[this.index++];
                }
            };
        }

        static Iterator<Integer> iterator(final int[] array) {
            return new Iterator<Integer>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Integer next() {
                    return array[this.index++];
                }
            };
        }

        static Iterator<Long> iterator(final long[] array) {
            return new Iterator<Long>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Long next() {
                    return array[this.index++];
                }
            };
        }

        static Iterator<Character> iterator(final char[] array) {
            return new Iterator<Character>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Character next() {
                    return Character.valueOf(array[this.index++]);
                }
            };
        }

        static Iterator<Float> iterator(final float[] array) {
            return new Iterator<Float>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Float next() {
                    return Float.valueOf(array[this.index++]);
                }
            };
        }

        static Iterator<Double> iterator(final double[] array) {
            return new Iterator<Double>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Double next() {
                    return array[this.index++];
                }
            };
        }

        static Iterator<Object> iterator(final Object[] array) {
            return new Iterator<Object>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Object next() {
                    return array[this.index++];
                }
            };
        }

        static MethodHandle newIterator(Class<?> arrayType) {
            if (!arrayType.isArray()) {
                throw new IllegalArgumentException("type must be an array");
            }
            return ARRAY_TYPE_MH_MAPPING.containsKey(arrayType) ? ARRAY_TYPE_MH_MAPPING.get(arrayType) : OBJECT_ARRAY_MH.asType(OBJECT_ARRAY_MH.type().changeParameterType(0, arrayType));
        }

        private ArrayIteratorHelper() {
        }
    }

    private static final class ArrayLengthHelper {
        private static final MethodHandles.Lookup PRIVATE_METHOD_HANDLES_LOOKUP = MethodHandles.lookup();
        private static final Map<Class<?>, MethodHandle> ARRAY_TYPE_MH_MAPPING = Collections.unmodifiableMap(Stream.of(boolean[].class, byte[].class, short[].class, int[].class, long[].class, char[].class, float[].class, double[].class, Object[].class).collect(Collectors.toMap(Function.identity(), type -> {
            try {
                return PRIVATE_METHOD_HANDLES_LOOKUP.findStatic(PRIVATE_METHOD_HANDLES_LOOKUP.lookupClass(), "getArrayLength", MethodType.methodType(Integer.TYPE, type));
            }
            catch (ReflectiveOperationException e) {
                throw new AssertionError((Object)e);
            }
        })));
        private static final MethodHandle OBJECT_ARRAY_MH = ARRAY_TYPE_MH_MAPPING.get(Object[].class);

        static int getArrayLength(boolean[] array) {
            return array.length;
        }

        static int getArrayLength(byte[] array) {
            return array.length;
        }

        static int getArrayLength(short[] array) {
            return array.length;
        }

        static int getArrayLength(int[] array) {
            return array.length;
        }

        static int getArrayLength(long[] array) {
            return array.length;
        }

        static int getArrayLength(char[] array) {
            return array.length;
        }

        static int getArrayLength(float[] array) {
            return array.length;
        }

        static int getArrayLength(double[] array) {
            return array.length;
        }

        static int getArrayLength(Object[] array) {
            return array.length;
        }

        static MethodHandle arrayLengthGetter(Class<?> arrayType) {
            if (!arrayType.isArray()) {
                throw new IllegalArgumentException("type must be an array");
            }
            return ARRAY_TYPE_MH_MAPPING.containsKey(arrayType) ? ARRAY_TYPE_MH_MAPPING.get(arrayType) : OBJECT_ARRAY_MH.asType(OBJECT_ARRAY_MH.type().changeParameterType(0, arrayType));
        }

        private ArrayLengthHelper() {
        }
    }
}

