/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultTaskHistoryStore;
import org.gradle.api.internal.changedetection.state.DefaultTaskOutputFilesRepository;
import org.gradle.api.internal.changedetection.state.InMemoryCacheDecoratorFactory;
import org.gradle.api.internal.changedetection.state.TaskExecutionFingerprintSerializer;
import org.gradle.api.internal.changedetection.state.TaskHistoryCache;
import org.gradle.api.internal.changedetection.state.TaskHistoryStore;
import org.gradle.api.internal.changedetection.state.TaskOutputFilesRepository;
import org.gradle.api.internal.tasks.timeout.DefaultTimeoutHandler;
import org.gradle.api.internal.tasks.timeout.TimeoutHandler;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.execution.plan.DefaultPlanExecutor;
import org.gradle.execution.plan.PlanExecutor;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ParallelismConfigurationManager;
import org.gradle.internal.fingerprint.FingerprintCompareStrategy;
import org.gradle.internal.fingerprint.HistoricalFileCollectionFingerprint;
import org.gradle.internal.fingerprint.classpath.impl.ClasspathCompareStrategy;
import org.gradle.internal.fingerprint.impl.AbsolutePathFingerprintCompareStrategy;
import org.gradle.internal.fingerprint.impl.DefaultHistoricalFileCollectionFingerprint;
import org.gradle.internal.fingerprint.impl.EmptyHistoricalFileCollectionFingerprint;
import org.gradle.internal.fingerprint.impl.IgnoredPathCompareStrategy;
import org.gradle.internal.fingerprint.impl.NormalizedPathFingerprintCompareStrategy;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.Serializers;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.GradleVersion;

public class TaskExecutionServices {
    private static final List<FingerprintCompareStrategy> FINGERPRINT_COMPARE_STRATEGIES = ImmutableList.of((Object)AbsolutePathFingerprintCompareStrategy.INSTANCE, (Object)NormalizedPathFingerprintCompareStrategy.INSTANCE, (Object)IgnoredPathCompareStrategy.INSTANCE, (Object)ClasspathCompareStrategy.INSTANCE);

    TimeoutHandler createTaskTimeoutHandler(ExecutorFactory executorFactory) {
        return new DefaultTimeoutHandler(executorFactory.createScheduled("task timeouts", 1));
    }

    TaskHistoryStore createCacheAccess(Gradle gradle, CacheRepository cacheRepository, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
        return new DefaultTaskHistoryStore(gradle, cacheRepository, inMemoryCacheDecoratorFactory);
    }

    TaskHistoryCache createTaskHistoryCache(TaskHistoryStore taskHistoryStore, StringInterner stringInterner) {
        DefaultSerializerRegistry serializerRegistry = new DefaultSerializerRegistry();
        serializerRegistry.register(DefaultHistoricalFileCollectionFingerprint.class, (Serializer)new DefaultHistoricalFileCollectionFingerprint.SerializerImpl(stringInterner, FINGERPRINT_COMPARE_STRATEGIES));
        serializerRegistry.register(EmptyHistoricalFileCollectionFingerprint.class, Serializers.constant((Object)EmptyHistoricalFileCollectionFingerprint.INSTANCE));
        TaskExecutionFingerprintSerializer serializer = new TaskExecutionFingerprintSerializer((Serializer<HistoricalFileCollectionFingerprint>)serializerRegistry.build(HistoricalFileCollectionFingerprint.class));
        return new TaskHistoryCache(taskHistoryStore, serializer);
    }

    TaskOutputFilesRepository createTaskOutputFilesRepository(CacheRepository cacheRepository, Gradle gradle, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
        PersistentCache cacheAccess = cacheRepository.cache((Object)gradle, "buildOutputCleanup").withCrossVersionCache(CacheBuilder.LockTarget.DefaultTarget).withDisplayName("Build Output Cleanup Cache").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.None)).withProperties(Collections.singletonMap("gradle.version", GradleVersion.current().getVersion())).open();
        return new DefaultTaskOutputFilesRepository(cacheAccess, inMemoryCacheDecoratorFactory);
    }

    PlanExecutor createTaskExecutorFactory(ParallelismConfigurationManager parallelismConfigurationManager, ExecutorFactory executorFactory, WorkerLeaseService workerLeaseService, BuildCancellationToken cancellationToken, ResourceLockCoordinationService coordinationService) {
        int parallelThreads = parallelismConfigurationManager.getParallelismConfiguration().getMaxWorkerCount();
        if (parallelThreads < 1) {
            throw new IllegalStateException(String.format("Cannot create executor for requested number of worker threads: %s.", parallelThreads));
        }
        return new DefaultPlanExecutor(parallelismConfigurationManager.getParallelismConfiguration(), executorFactory, workerLeaseService, cancellationToken, coordinationService);
    }
}

