/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.DefaultResolvedModuleVersion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BuildDependenciesVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.tasks.AbstractTaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.model.IvyArtifactName;

public class DefaultResolvedArtifact
implements ResolvedArtifact,
ResolvableArtifact {
    private final ModuleVersionIdentifier owner;
    private final IvyArtifactName artifact;
    private final ComponentArtifactIdentifier artifactId;
    private final TaskDependency buildDependencies;
    private volatile Factory<File> artifactSource;
    private final ResolvableArtifact sourceArtifact;
    private volatile File file;
    private volatile Throwable failure;

    public DefaultResolvedArtifact(ModuleVersionIdentifier owner, IvyArtifactName artifact, ComponentArtifactIdentifier artifactId, TaskDependency buildDependencies, Factory<File> artifactSource) {
        this.owner = owner;
        this.artifact = artifact;
        this.artifactId = artifactId;
        this.buildDependencies = buildDependencies;
        this.sourceArtifact = null;
        this.artifactSource = artifactSource;
    }

    public DefaultResolvedArtifact(ModuleVersionIdentifier owner, IvyArtifactName artifact, ComponentArtifactIdentifier artifactId, ResolvableArtifact sourceArtifact, File artifactFile) {
        this.owner = owner;
        this.artifact = artifact;
        this.artifactId = artifactId;
        this.buildDependencies = null;
        this.sourceArtifact = sourceArtifact;
        this.file = artifactFile;
    }

    @Override
    public void collectBuildDependencies(BuildDependenciesVisitor visitor) {
        LoggingVisitor nested = new LoggingVisitor(visitor);
        if (this.buildDependencies != null) {
            nested.visitDependency(this.buildDependencies);
        } else if (this.sourceArtifact != null) {
            this.sourceArtifact.collectBuildDependencies(nested);
        }
    }

    public ResolvedModuleVersion getModuleVersion() {
        return new DefaultResolvedModuleVersion(this.owner);
    }

    @Override
    public ComponentArtifactIdentifier getId() {
        return this.artifactId;
    }

    public String toString() {
        return this.artifactId.getDisplayName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultResolvedArtifact other = (DefaultResolvedArtifact)obj;
        return other.owner.equals(this.owner) && other.artifactId.equals(this.artifactId);
    }

    public int hashCode() {
        return this.owner.hashCode() ^ this.artifactId.hashCode();
    }

    public String getName() {
        return this.artifact.getName();
    }

    public String getType() {
        return this.artifact.getType();
    }

    public String getExtension() {
        return this.artifact.getExtension();
    }

    public String getClassifier() {
        return this.artifact.getClassifier();
    }

    @Override
    public ResolvedArtifact toPublicView() {
        return this;
    }

    @Override
    public boolean isResolveSynchronously() {
        if (this.artifactId instanceof LocalComponentArtifactMetadata) {
            return true;
        }
        return this.file != null || this.failure != null;
    }

    @Override
    public File getFile() {
        File f = this.file;
        if (f == null) {
            Throwable err = this.failure;
            if (err != null) {
                throw UncheckedException.throwAsUncheckedException((Throwable)err);
            }
            try {
                this.file = f = (File)this.artifactSource.create();
            }
            catch (Exception e) {
                this.failure = err = e;
                throw UncheckedException.throwAsUncheckedException((Throwable)err);
            }
        }
        return f;
    }

    private class LoggingVisitor
    extends AbstractTaskDependencyResolveContext
    implements BuildDependenciesVisitor {
        private final BuildDependenciesVisitor visitor;
        private final Set<Object> seen = new HashSet<Object>();

        public LoggingVisitor(BuildDependenciesVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        public void visitDependency(Object dep) {
            if (!this.seen.add(dep)) {
                return;
            }
            if (dep instanceof TaskDependencyContainer) {
                ((TaskDependencyContainer)dep).visitDependencies((TaskDependencyResolveContext)this);
            } else if (dep instanceof TaskInternal) {
                this.visitor.attachFinalizerTo((Task)dep, (Action<? super Task>)new Action<Task>(){

                    public void execute(Task task) {
                        if (DefaultResolvedArtifact.this.isResolveSynchronously()) {
                            try {
                                DefaultResolvedArtifact.this.getFile();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                });
                this.visitor.visitDependency(dep);
            } else {
                this.visitor.visitDependency(dep);
            }
        }

        @Override
        public void attachFinalizerTo(Task task, Action<? super Task> action) {
            this.visitor.attachFinalizerTo(task, action);
        }

        @Override
        public void visitFailure(Throwable failure) {
            this.visitor.visitFailure(failure);
        }

        public void add(Object dependency) {
            this.visitDependency(dependency);
        }

        public Task getTask() {
            return null;
        }
    }
}

