/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;

class DependencyState {
    private final ComponentSelector requested;
    private final DependencyMetadata dependency;
    private final ComponentSelectionDescriptorInternal ruleDescriptor;
    private final ComponentSelectorConverter componentSelectorConverter;
    private ModuleIdentifier moduleIdentifier;
    public ModuleVersionResolveException failure;

    DependencyState(DependencyMetadata dependency, ComponentSelectorConverter componentSelectorConverter) {
        this(dependency, dependency.getSelector(), null, componentSelectorConverter);
    }

    private DependencyState(DependencyMetadata dependency, ComponentSelector requested, ComponentSelectionDescriptorInternal ruleDescriptor, ComponentSelectorConverter componentSelectorConverter) {
        this.dependency = dependency;
        this.requested = requested;
        this.ruleDescriptor = ruleDescriptor;
        this.componentSelectorConverter = componentSelectorConverter;
    }

    public ComponentSelector getRequested() {
        return this.requested;
    }

    public DependencyMetadata getDependency() {
        return this.dependency;
    }

    public ModuleIdentifier getModuleIdentifier() {
        if (this.moduleIdentifier == null) {
            this.moduleIdentifier = this.componentSelectorConverter.getModule(this.dependency.getSelector());
        }
        return this.moduleIdentifier;
    }

    public DependencyState withTarget(ComponentSelector target, ComponentSelectionDescriptorInternal ruleDescriptor) {
        DependencyMetadata targeted = this.dependency.withTarget(target);
        return new DependencyState(targeted, this.requested, ruleDescriptor, this.componentSelectorConverter);
    }

    public ComponentSelectionDescriptorInternal getRuleDescriptor() {
        return this.ruleDescriptor;
    }
}

