/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.TextureAttributesRetained;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color4f;

public class TextureAttributes
extends NodeComponent {
    public static final int ALLOW_MODE_READ = 0;
    public static final int ALLOW_MODE_WRITE = 1;
    public static final int ALLOW_BLEND_COLOR_READ = 2;
    public static final int ALLOW_BLEND_COLOR_WRITE = 3;
    public static final int ALLOW_TRANSFORM_READ = 4;
    public static final int ALLOW_TRANSFORM_WRITE = 5;
    public static final int ALLOW_COLOR_TABLE_READ = 6;
    public static final int ALLOW_COLOR_TABLE_WRITE = 7;
    public static final int ALLOW_COMBINE_READ = 8;
    public static final int ALLOW_COMBINE_WRITE = 9;
    public static final int FASTEST = 0;
    public static final int NICEST = 1;
    public static final int MODULATE = 2;
    public static final int DECAL = 3;
    public static final int BLEND = 4;
    public static final int REPLACE = 5;
    public static final int COMBINE = 6;
    public static final int COMBINE_REPLACE = 0;
    public static final int COMBINE_MODULATE = 1;
    public static final int COMBINE_ADD = 2;
    public static final int COMBINE_ADD_SIGNED = 3;
    public static final int COMBINE_SUBTRACT = 4;
    public static final int COMBINE_INTERPOLATE = 5;
    public static final int COMBINE_DOT3 = 6;
    public static final int COMBINE_OBJECT_COLOR = 0;
    public static final int COMBINE_TEXTURE_COLOR = 1;
    public static final int COMBINE_CONSTANT_COLOR = 2;
    public static final int COMBINE_PREVIOUS_TEXTURE_UNIT_STATE = 3;
    public static final int COMBINE_SRC_COLOR = 0;
    public static final int COMBINE_ONE_MINUS_SRC_COLOR = 1;
    public static final int COMBINE_SRC_ALPHA = 2;
    public static final int COMBINE_ONE_MINUS_SRC_ALPHA = 3;
    private static final int[] readCapabilities = new int[]{2, 6, 8, 0, 4};

    public TextureAttributes() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public TextureAttributes(int n, Transform3D transform3D, Color4f color4f, int n2) {
        if (n < 2 || n > 6) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes10"));
        }
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes9"));
        }
        this.setDefaultReadCapabilities(readCapabilities);
        ((TextureAttributesRetained)this.retained).initTextureMode(n);
        ((TextureAttributesRetained)this.retained).initTextureBlendColor(color4f);
        ((TextureAttributesRetained)this.retained).initTextureTransform(transform3D);
        ((TextureAttributesRetained)this.retained).initPerspectiveCorrectionMode(n2);
    }

    public void setTextureMode(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes0"));
        }
        if (n < 2 || n > 6) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes10"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setTextureMode(n);
        } else {
            ((TextureAttributesRetained)this.retained).initTextureMode(n);
        }
    }

    public int getTextureMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes1"));
        }
        return ((TextureAttributesRetained)this.retained).getTextureMode();
    }

    public void setTextureBlendColor(Color4f color4f) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes2"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setTextureBlendColor(color4f);
        } else {
            ((TextureAttributesRetained)this.retained).initTextureBlendColor(color4f);
        }
    }

    public void setTextureBlendColor(float f, float f2, float f3, float f4) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes3"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setTextureBlendColor(f, f2, f3, f4);
        } else {
            ((TextureAttributesRetained)this.retained).initTextureBlendColor(f, f2, f3, f4);
        }
    }

    public void getTextureBlendColor(Color4f color4f) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes4"));
        }
        ((TextureAttributesRetained)this.retained).getTextureBlendColor(color4f);
    }

    public void setTextureTransform(Transform3D transform3D) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes5"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setTextureTransform(transform3D);
        } else {
            ((TextureAttributesRetained)this.retained).initTextureTransform(transform3D);
        }
    }

    public void getTextureTransform(Transform3D transform3D) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes6"));
        }
        ((TextureAttributesRetained)this.retained).getTextureTransform(transform3D);
    }

    public void setPerspectiveCorrectionMode(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes7"));
        }
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes9"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setPerspectiveCorrectionMode(n);
        } else {
            ((TextureAttributesRetained)this.retained).initPerspectiveCorrectionMode(n);
        }
    }

    public int getPerspectiveCorrectionMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes8"));
        }
        return ((TextureAttributesRetained)this.retained).getPerspectiveCorrectionMode();
    }

    public void setTextureColorTable(int[][] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes11"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setTextureColorTable(nArray);
        } else {
            ((TextureAttributesRetained)this.retained).initTextureColorTable(nArray);
        }
    }

    public void getTextureColorTable(int[][] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes12"));
        }
        ((TextureAttributesRetained)this.retained).getTextureColorTable(nArray);
    }

    public int getNumTextureColorTableComponents() {
        return ((TextureAttributesRetained)this.retained).getNumTextureColorTableComponents();
    }

    public int getTextureColorTableSize() {
        return ((TextureAttributesRetained)this.retained).getTextureColorTableSize();
    }

    public void setCombineRgbMode(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes16"));
        }
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes20"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setCombineRgbMode(n);
        } else {
            ((TextureAttributesRetained)this.retained).initCombineRgbMode(n);
        }
    }

    public void setCombineAlphaMode(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes18"));
        }
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes20"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setCombineAlphaMode(n);
        } else {
            ((TextureAttributesRetained)this.retained).initCombineAlphaMode(n);
        }
    }

    public int getCombineRgbMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes17"));
        }
        return ((TextureAttributesRetained)this.retained).getCombineRgbMode();
    }

    public int getCombineAlphaMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes19"));
        }
        return ((TextureAttributesRetained)this.retained).getCombineAlphaMode();
    }

    public void setCombineRgbSource(int n, int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes21"));
        }
        if (n < 0 || n > 2) {
            throw new IndexOutOfBoundsException(J3dI18N.getString("TextureAttributes25"));
        }
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes26"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setCombineRgbSource(n, n2);
        } else {
            ((TextureAttributesRetained)this.retained).initCombineRgbSource(n, n2);
        }
    }

    public void setCombineAlphaSource(int n, int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes23"));
        }
        if (n < 0 || n > 2) {
            throw new IndexOutOfBoundsException(J3dI18N.getString("TextureAttributes25"));
        }
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes26"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setCombineAlphaSource(n, n2);
        } else {
            ((TextureAttributesRetained)this.retained).initCombineAlphaSource(n, n2);
        }
    }

    public int getCombineRgbSource(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes22"));
        }
        if (n < 0 || n > 2) {
            throw new IndexOutOfBoundsException(J3dI18N.getString("TextureAttributes25"));
        }
        return ((TextureAttributesRetained)this.retained).getCombineRgbSource(n);
    }

    public int getCombineAlphaSource(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes24"));
        }
        if (n < 0 || n > 2) {
            throw new IndexOutOfBoundsException(J3dI18N.getString("TextureAttributes25"));
        }
        return ((TextureAttributesRetained)this.retained).getCombineAlphaSource(n);
    }

    public void setCombineRgbFunction(int n, int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes27"));
        }
        if (n < 0 || n > 2) {
            throw new IndexOutOfBoundsException(J3dI18N.getString("TextureAttributes25"));
        }
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes31"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setCombineRgbFunction(n, n2);
        } else {
            ((TextureAttributesRetained)this.retained).initCombineRgbFunction(n, n2);
        }
    }

    public void setCombineAlphaFunction(int n, int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes29"));
        }
        if (n < 0 || n > 2) {
            throw new IndexOutOfBoundsException(J3dI18N.getString("TextureAttributes25"));
        }
        if (n2 < 2 || n2 > 3) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes31"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setCombineAlphaFunction(n, n2);
        } else {
            ((TextureAttributesRetained)this.retained).initCombineAlphaFunction(n, n2);
        }
    }

    public int getCombineRgbFunction(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes28"));
        }
        if (n < 0 || n > 2) {
            throw new IndexOutOfBoundsException(J3dI18N.getString("TextureAttributes25"));
        }
        return ((TextureAttributesRetained)this.retained).getCombineRgbFunction(n);
    }

    public int getCombineAlphaFunction(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes30"));
        }
        if (n < 0 || n > 2) {
            throw new IndexOutOfBoundsException(J3dI18N.getString("TextureAttributes25"));
        }
        return ((TextureAttributesRetained)this.retained).getCombineAlphaFunction(n);
    }

    public void setCombineRgbScale(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes32"));
        }
        if (n != 1 && n != 2 && n != 4) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes36"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setCombineRgbScale(n);
        } else {
            ((TextureAttributesRetained)this.retained).initCombineRgbScale(n);
        }
    }

    public void setCombineAlphaScale(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes34"));
        }
        if (n != 1 && n != 2 && n != 4) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes36"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setCombineAlphaScale(n);
        } else {
            ((TextureAttributesRetained)this.retained).initCombineAlphaScale(n);
        }
    }

    public int getCombineRgbScale() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes33"));
        }
        return ((TextureAttributesRetained)this.retained).getCombineRgbScale();
    }

    public int getCombineAlphaScale() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes35"));
        }
        return ((TextureAttributesRetained)this.retained).getCombineAlphaScale();
    }

    void createRetained() {
        this.retained = new TextureAttributesRetained();
        this.retained.setSource(this);
    }

    public NodeComponent cloneNodeComponent() {
        TextureAttributes textureAttributes = new TextureAttributes();
        textureAttributes.duplicateNodeComponent(this);
        return textureAttributes;
    }

    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        super.duplicateAttributes(nodeComponent, bl);
        TextureAttributesRetained textureAttributesRetained = (TextureAttributesRetained)nodeComponent.retained;
        TextureAttributesRetained textureAttributesRetained2 = (TextureAttributesRetained)this.retained;
        Color4f color4f = new Color4f();
        textureAttributesRetained.getTextureBlendColor(color4f);
        Transform3D transform3D = new Transform3D();
        textureAttributesRetained.getTextureTransform(transform3D);
        textureAttributesRetained2.initTextureMode(textureAttributesRetained.getTextureMode());
        textureAttributesRetained2.initPerspectiveCorrectionMode(textureAttributesRetained.getPerspectiveCorrectionMode());
        textureAttributesRetained2.initTextureBlendColor(color4f);
        textureAttributesRetained2.initTextureTransform(transform3D);
        if (textureAttributesRetained.getNumTextureColorTableComponents() != 0 && textureAttributesRetained.getTextureColorTableSize() != 0) {
            int[][] nArray = new int[textureAttributesRetained.getNumTextureColorTableComponents()][textureAttributesRetained.getTextureColorTableSize()];
            textureAttributesRetained.getTextureColorTable(nArray);
            textureAttributesRetained2.initTextureColorTable(nArray);
        }
    }
}

