/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.font.FontStrike;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.PGShape;
import com.sun.javafx.sg.PGText;
import com.sun.javafx.sg.PGTextHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGShape;
import com.sun.javafx.sg.prism.NGTextHelper;
import com.sun.prism.Graphics;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;

public class NGText
extends NGShape
implements PGText {
    NGTextHelper helper = new NGTextHelper();
    NGTextHelper sgTextHelper = new NGTextHelper();
    private boolean drawingEffect = false;

    @Override
    public PGTextHelper getTextHelper() {
        return this.sgTextHelper;
    }

    public void setText(String string) {
        this.helper.setText(string);
    }

    public void setFont(Object object) {
        this.helper.setFont(object);
    }

    public void setLocation(float f, float f2) {
        this.helper.setLocation(f, f2);
    }

    @Override
    public void geometryChanged() {
        super.geometryChanged();
        this.helper.geometryChangedTextValid();
    }

    @Override
    public void locationChanged() {
        super.locationChanged();
        this.helper.geometryChangedTextValid();
    }

    @Override
    public void updateText() {
        this.sgTextHelper.sync(this.helper);
        if (this.sgTextHelper.isGeometryChanged()) {
            super.geometryChanged();
            this.helper.resetGeometryChanged();
            this.sgTextHelper.resetGeometryChanged();
        }
        if (this.sgTextHelper.isLocationChanged()) {
            super.locationChanged();
            this.helper.resetLocationChanged();
            this.sgTextHelper.resetLocationChanged();
        }
    }

    private FontStrike getStrike() {
        return this.helper.getStrike();
    }

    private FontStrike getStrike(BaseTransform baseTransform) {
        return this.helper.getStrike(baseTransform);
    }

    private Shape getShape(boolean bl) {
        return this.helper.getShape(bl);
    }

    @Override
    public Shape getShape() {
        return this.getShape(true);
    }

    private void decorate(Graphics graphics, FontStrike fontStrike, float f, float f2, float f3) {
        NGTextHelper.TextAttributes textAttributes = this.helper.getAttributes();
        if (textAttributes == null) {
            return;
        }
        if (textAttributes.underline || textAttributes.strikethrough) {
            float f4 = f3 > 0.0f ? f3 : NGTextHelper.getTabExpandedAdvance(this.helper.getText(), fontStrike);
            if (textAttributes.underline) {
                this.drawUnderline(graphics, fontStrike, f, f2, f4);
            }
            if (textAttributes.strikethrough) {
                this.drawStrikeThrough(graphics, fontStrike, f, f2, f4);
            }
        }
    }

    private void drawUnderline(Graphics graphics, FontStrike fontStrike, float f, float f2, float f3) {
        if (fontStrike == null) {
            fontStrike = this.getStrike(graphics.getTransformNoClone());
        }
        float f4 = fontStrike.getUnderLineOffset();
        float f5 = fontStrike.getUnderLineThickness();
        this.drawDecoration(graphics, f, f2, f3, f4, f5);
    }

    private void drawStrikeThrough(Graphics graphics, FontStrike fontStrike, float f, float f2, float f3) {
        if (fontStrike == null) {
            fontStrike = this.getStrike(graphics.getTransformNoClone());
        }
        float f4 = fontStrike.getStrikeThroughOffset();
        float f5 = fontStrike.getStrikeThroughThickness();
        this.drawDecoration(graphics, f, f2, f3, f4, f5);
    }

    private void drawDecoration(Graphics graphics, float f, float f2, float f3, float f4, float f5) {
        RoundRectangle2D roundRectangle2D = new RoundRectangle2D();
        roundRectangle2D.x = f;
        roundRectangle2D.y = f2 + f4;
        roundRectangle2D.width = f3;
        roundRectangle2D.height = f5;
        Paint paint = graphics.getPaint();
        if (this.mode != PGShape.Mode.FILL) {
            graphics.setPaint(this.drawPaint);
            graphics.setStroke(this.drawStroke);
            graphics.draw(roundRectangle2D);
        }
        if (this.mode != PGShape.Mode.STROKE) {
            graphics.setPaint(this.fillPaint);
            graphics.fill(roundRectangle2D);
        }
        if (graphics.getPaint() != paint) {
            graphics.setPaint(paint);
        }
    }

    private void drawString(Graphics graphics, String string, FontStrike fontStrike, float f, float f2, int n) {
        NGTextHelper.Selection selection = this.helper.getSelection();
        if (selection != null && !selection.isEmpty() && selection.fillPaint != this.fillPaint && selection.fillPaint instanceof Color) {
            graphics.drawString(string, fontStrike, f, f2, (Color)selection.fillPaint, selection.start - n, selection.end - n);
        } else {
            graphics.drawString(string, fontStrike, f, f2);
        }
    }

    private float tabJustifyExpandedDrawstring(Graphics graphics, String string, FontStrike fontStrike, float f, float f2, float f3, int n) {
        int n2;
        char[] cArray = string.toCharArray();
        float f4 = 0.0f;
        float f5 = fontStrike.getCharAdvance(' ');
        float f6 = 8.0f * f5;
        float f7 = 0.0f;
        NGTextHelper.IntList intList = new NGTextHelper.IntList();
        NGTextHelper.FloatList floatList = new NGTextHelper.FloatList();
        NGTextHelper.TextAttributes textAttributes = this.helper.getAttributes();
        boolean bl = textAttributes.textAlignment == 3 && f3 > 0.0f;
        int n3 = 0;
        int n4 = 0;
        float f8 = 0.0f;
        for (n2 = cArray.length - 1; n2 > 0 && cArray[n2] == ' ' && bl; --n2) {
        }
        while (n3 <= n2) {
            char c = cArray[n3];
            if (c == '\t') {
                if (n3 > n4) {
                    String string2 = new String(cArray, n4, n3 - n4);
                    this.drawString(graphics, string2, fontStrike, f + f7, f2, n + n4);
                    intList.index = 0;
                    floatList.index = 0;
                }
                n4 = ++n3;
                float f9 = f4 + f8;
                f8 = f7 = (float)((int)(f9 / f6) + 1) * f6;
                f4 = 0.0f;
                continue;
            }
            if (bl && c == ' ') {
                intList.add(++n3);
                floatList.add(f8 + f5);
                f8 += f5 + f4;
                f4 = 0.0f;
                continue;
            }
            ++n3;
            f4 += fontStrike.getCharAdvance(c);
        }
        if (n3 > n4) {
            if (bl && intList.index > 0) {
                int[] nArray = intList.getData();
                float[] fArray = floatList.getData();
                float f10 = f3 / (float)nArray.length;
                float f11 = 0.0f;
                int n5 = 0;
                if (n4 == 0) {
                    String string3 = new String(cArray, n4, nArray[n5] - n4);
                    this.drawString(graphics, string3, fontStrike, f, f2, n + n4);
                    n4 = nArray[n5++];
                    f11 += f10;
                }
                while (n5 < nArray.length) {
                    if (n4 < nArray[n5]) {
                        String string4 = new String(cArray, n4, nArray[n5] - n4);
                        this.drawString(graphics, string4, fontStrike, f + fArray[n5] + f11, f2, n + n4);
                        f11 += f10;
                    }
                    n4 = nArray[n5];
                    ++n5;
                }
                f8 += f11;
            }
            String string5 = new String(cArray, n4, n3 - n4);
            this.drawString(graphics, string5, fontStrike, f + f8, f2, n + n4);
        }
        return f8 + f4;
    }

    private float tabExpandedDrawstring(Graphics graphics, String string, FontStrike fontStrike, float f, float f2, int n) {
        char[] cArray = string.toCharArray();
        float f3 = 0.0f;
        float f4 = 8.0f * fontStrike.getCharAdvance(' ');
        float f5 = 0.0f;
        int n2 = 0;
        int n3 = 0;
        while (n2 < cArray.length) {
            char c = cArray[n2];
            if (c != '\t') {
                ++n2;
                f3 += fontStrike.getCharAdvance(c);
                continue;
            }
            if (n2 > n3) {
                String string2 = new String(cArray, n3, n2 - n3);
                this.drawString(graphics, string2, fontStrike, f + f5, f2, n + n3);
            }
            n3 = ++n2;
            float f6 = f5 + f3;
            f5 = (float)((int)(f6 / f4) + 1) * f4;
            f3 = 0.0f;
        }
        if (n2 > n3) {
            String string3 = new String(cArray, n3, n2 - n3);
            this.drawString(graphics, string3, fontStrike, f + f5, f2, n + n3);
        }
        return f5 + f3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderEffect(Graphics graphics) {
        if (!graphics.getTransformNoClone().isTranslateOrIdentity()) {
            this.drawingEffect = true;
        }
        try {
            super.renderEffect(graphics);
        }
        finally {
            this.drawingEffect = false;
        }
    }

    @Override
    protected void renderContent(Graphics graphics) {
        Object object;
        if (this.mode == PGShape.Mode.EMPTY || this.helper.isEmpty()) {
            return;
        }
        this.helper.validateText();
        if (!graphics.getTransformNoClone().is2D()) {
            super.renderContent(graphics);
            return;
        }
        BaseBounds baseBounds = null;
        String string = this.helper.getText();
        NGTextHelper.TextAttributes textAttributes = this.helper.getAttributes();
        if (textAttributes != null && textAttributes.numberOfLines() > 1 && this.getClipNode() != null) {
            object = (NGNode)this.getClipNode();
            baseBounds = new RectBounds();
            baseBounds = this.getClippedBounds(baseBounds, NGTextHelper.IDENT);
        }
        if ((object = this.getStrike(graphics.getTransformNoClone())).getAAMode() == 1 || this.fillPaint != null && this.fillPaint.isProportional() || this.drawPaint != null && this.drawPaint.isProportional()) {
            BaseBounds baseBounds2 = this.helper.computeContentBounds(null, NGTextHelper.IDENT);
            graphics.setNodeBounds((RectBounds)baseBounds2);
        }
        if (this.mode != PGShape.Mode.STROKE && !object.drawAsShapes() && !this.drawingEffect) {
            graphics.setPaint(this.fillPaint);
            float f = this.helper.getY() + this.helper.getYAdjustment();
            if (this.helper.simpleSingleLine()) {
                this.drawString(graphics, string, (FontStrike)object, this.helper.getX(), f, 0);
                if (this.helper.getAttributes() != null) {
                    this.decorate(graphics, (FontStrike)object, this.helper.getX(), f, this.helper.getMaxLineAdvance());
                }
            } else {
                float f2 = 0.0f;
                if (textAttributes.textAlignment == 1) {
                    f2 = 0.5f;
                } else if (textAttributes.textAlignment == 2) {
                    f2 = 1.0f;
                }
                float f3 = object.getMetrics().getLineHeight();
                int[] nArray = textAttributes.newLineIndices;
                float[] fArray = textAttributes.lineAdvances;
                if (nArray == null) {
                    nArray = new int[]{string.length() - 1};
                }
                float f4 = this.helper.getMaxLineAdvance();
                if (fArray == null) {
                    fArray = new float[]{f4};
                }
                int n = 0;
                float f5 = 0.0f;
                float f6 = textAttributes.overrideWrappingWidth ? f4 : textAttributes.wrappingWidth;
                boolean bl = f6 > 0.0f;
                float f7 = 0.0f;
                for (int i = 0; !(i >= nArray.length || baseBounds != null && f - f3 > baseBounds.getMaxY()); ++i) {
                    if (bl) {
                        f7 = f6 - fArray[i];
                        f5 = f2 * f7;
                    }
                    int n2 = nArray[i];
                    boolean bl2 = Character.isWhitespace(string.charAt(n2));
                    if (n >= n2 && bl2) {
                        ++n;
                        f += f3;
                        continue;
                    }
                    if (baseBounds != null && f + f3 < baseBounds.getMinY()) {
                        f += f3;
                        n = n2 + 1;
                        continue;
                    }
                    int n3 = bl2 ? n2 : n2 + 1;
                    String string2 = string.substring(n, n3);
                    float f8 = this.helper.getX();
                    if (textAttributes.hasTabs && string2.indexOf(9) != -1 || textAttributes.textAlignment == 3) {
                        float f9;
                        boolean bl3 = false;
                        if (string.charAt(nArray[i]) == '\n' || i == nArray.length - 1) {
                            bl3 = true;
                        }
                        if (textAttributes.textAlignment == 3 && bl && !bl3) {
                            f9 = this.tabJustifyExpandedDrawstring(graphics, string2, (FontStrike)object, f8 + f5, f, f6 - fArray[i], n);
                            this.decorate(graphics, (FontStrike)object, f8 + f5, f, f9);
                        } else {
                            f9 = this.tabExpandedDrawstring(graphics, string2, (FontStrike)object, f8 + f5, f, n);
                            this.decorate(graphics, (FontStrike)object, f8 + f5, f, f9);
                        }
                    } else {
                        this.drawString(graphics, string2, (FontStrike)object, f8 + f5, f, n);
                        this.decorate(graphics, (FontStrike)object, f8 + f5, f, fArray[i]);
                    }
                    f += f3;
                    n = n2 + 1;
                }
            }
        } else if (this.mode != PGShape.Mode.STROKE && (object.drawAsShapes() || this.drawingEffect)) {
            graphics.setPaint(this.fillPaint);
            graphics.fill(this.getShape(true));
        }
        if (this.mode != PGShape.Mode.FILL) {
            graphics.setPaint(this.drawPaint);
            graphics.setStroke(this.drawStroke);
            graphics.draw(this.getShape(true));
        }
        graphics.setNodeBounds(null);
    }
}

