/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import com.sun.javafx.scene.input.InputEventUtils;
import javafx.event.EventTarget;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;

public final class TouchPoint {
    private EventTarget target = null;
    private Object source;
    private EventTarget grabbed = null;
    private int id;
    private State state;
    private double x;
    private double y;
    private double screenX;
    private double screenY;
    private double sceneX;
    private double sceneY;

    private TouchPoint(int n, State state, double d, double d2, double d3, double d4) {
        this.id = n;
        this.state = state;
        this.x = d;
        this.y = d2;
        this.sceneX = d;
        this.sceneY = d2;
        this.screenX = d3;
        this.screenY = d4;
    }

    void recomputeToSource(Object object, Object object2) {
        Point2D point2D = InputEventUtils.recomputeCoordinates(new Point2D(this.sceneX, this.sceneY), null, object2);
        this.x = point2D.getX();
        this.y = point2D.getY();
        this.source = object2;
    }

    public boolean belongsTo(EventTarget eventTarget) {
        if (this.target instanceof Node) {
            Node node;
            if (eventTarget instanceof Scene) {
                return node.getScene() == eventTarget;
            }
            for (node = (Node)this.target; node != null; node = node.getParent()) {
                if (node != eventTarget) continue;
                return true;
            }
        }
        return eventTarget == this.target;
    }

    @Deprecated
    public void impl_setTarget(EventTarget eventTarget) {
        this.target = eventTarget;
    }

    @Deprecated
    public void impl_reset() {
        this.x = this.sceneX;
        this.y = this.sceneY;
    }

    public EventTarget getGrabbed() {
        return this.grabbed;
    }

    public void grab() {
        if (!(this.source instanceof EventTarget)) {
            throw new IllegalStateException("Cannot grab touch point, source is not an instance of EventTarget: " + this.source);
        }
        this.grabbed = (EventTarget)this.source;
    }

    public void grab(EventTarget eventTarget) {
        this.grabbed = eventTarget;
    }

    public void ungrab() {
        this.grabbed = null;
    }

    public final int getId() {
        return this.id;
    }

    public final State getState() {
        return this.state;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getScreenX() {
        return this.screenX;
    }

    public final double getScreenY() {
        return this.screenY;
    }

    public final double getSceneX() {
        return this.sceneX;
    }

    public final double getSceneY() {
        return this.sceneY;
    }

    public EventTarget getTarget() {
        return this.target;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TouchPoint [");
        stringBuilder.append("state = ").append((Object)this.getState());
        stringBuilder.append(", id = ").append(this.getId());
        stringBuilder.append(", target = ").append(this.getTarget());
        stringBuilder.append(", x = ").append(this.getX()).append(", y = ").append(this.getY());
        return stringBuilder.append("]").toString();
    }

    @Deprecated
    public static TouchPoint impl_touchPoint(int n, State state, double d, double d2, double d3, double d4) {
        return new TouchPoint(n, state, d, d2, d3, d4);
    }

    public static enum State {
        PRESSED,
        MOVED,
        STATIONARY,
        RELEASED;

    }
}

