/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.search;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httppanel.HttpPanelRequest;
import org.zaproxy.zap.extension.httppanel.HttpPanelResponse;
import org.zaproxy.zap.extension.search.ExtensionSearch;
import org.zaproxy.zap.extension.search.SearchListenner;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.extension.search.SearchResult;
import org.zaproxy.zap.extension.search.SearchResultsTable;
import org.zaproxy.zap.extension.search.SearchResultsTableModel;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.TableExportButton;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.ZapToggleButton;

public class SearchPanel
extends AbstractPanel
implements SearchListenner {
    private static final long serialVersionUID = 1L;
    @Deprecated
    public static final String PANEL_NAME = "search";
    public static final String HTTP_MESSAGE_CONTAINER_NAME = "SearchHttpMessageContainer";
    private ExtensionSearch extension;
    private JPanel panelCommand = null;
    private JToolBar panelToolbar = null;
    private JScrollPane jScrollPane = null;
    private ZapToggleButton scopeButton = null;
    private ZapTextField regEx = null;
    private JButton btnSearch = null;
    private JComboBox<SearchOption> searchType = null;
    private JButton btnNext = null;
    private JButton btnPrev = null;
    private JCheckBox chkInverse = null;
    private JLabel numberOfMatchesLabel;
    private JButton optionsButton;
    private TableExportButton<SearchResultsTable> exportButton = null;
    private MessageFormat numberOfMatchesFormat;
    private SearchResultsTable resultsTable;
    private SearchResultsTableModel resultsModel;
    private final ViewDelegate view;

    @Deprecated
    public SearchPanel() {
        this(View.getSingleton());
        this.initialize();
    }

    public SearchPanel(ViewDelegate view) {
        this.view = view;
        this.initialize();
    }

    public ExtensionSearch getExtension() {
        return this.extension;
    }

    public void setExtension(ExtensionSearch extension) {
        this.extension = extension;
    }

    private void initialize() {
        this.resultsModel = new SearchResultsTableModel();
        this.resultsTable = new SearchResultsTable(this.resultsModel);
        this.resultsTable.setName(HTTP_MESSAGE_CONTAINER_NAME);
        this.resultsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    SearchResult searchResult = SearchPanel.this.resultsTable.getSelectedSearchResult();
                    if (searchResult == null) {
                        return;
                    }
                    SearchPanel.this.displayMessage(SearchPanel.this.resultsTable.getSelectedSearchResult());
                    SearchPanel.this.resultsTable.requestFocusInWindow();
                }
            }
        });
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("search.panel.title"));
        this.setIcon(new ImageIcon(SearchPanel.class.getResource("/resource/icon/16/049.png")));
        this.add((Component)this.getPanelCommand(), this.getPanelCommand().getName());
        this.setShowByDefault(true);
    }

    private JPanel getPanelCommand() {
        if (this.panelCommand == null) {
            this.panelCommand = new JPanel();
            this.panelCommand.setLayout(new GridBagLayout());
            this.panelCommand.setName("Search Panel");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.anchor = 18;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.anchor = 18;
            this.panelCommand.add((Component)this.getPanelToolbar(), gridBagConstraints1);
            this.panelCommand.add((Component)this.getJScrollPane(), gridBagConstraints2);
        }
        return this.panelCommand;
    }

    private GridBagConstraints newGBC(int gridx) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        return gridBagConstraints;
    }

    private JToolBar getPanelToolbar() {
        if (this.panelToolbar == null) {
            this.panelToolbar = new JToolBar();
            this.panelToolbar.setLayout(new GridBagLayout());
            this.panelToolbar.setEnabled(true);
            this.panelToolbar.setFloatable(false);
            this.panelToolbar.setRollover(true);
            this.panelToolbar.setPreferredSize(new Dimension(800, 30));
            this.panelToolbar.setName("Search Toolbar");
            GridBagConstraints gridBagConstraintsX = new GridBagConstraints();
            gridBagConstraintsX.gridx = 20;
            gridBagConstraintsX.gridy = 0;
            gridBagConstraintsX.weightx = 1.0;
            gridBagConstraintsX.weighty = 1.0;
            gridBagConstraintsX.insets = new Insets(0, 0, 0, 0);
            gridBagConstraintsX.anchor = 13;
            gridBagConstraintsX.fill = 2;
            GridBagConstraints optionsGridBag = new GridBagConstraints();
            optionsGridBag.gridx = gridBagConstraintsX.gridx + 1;
            optionsGridBag.gridy = 0;
            optionsGridBag.insets = new Insets(0, 0, 0, 0);
            optionsGridBag.anchor = 13;
            JLabel t1 = new JLabel();
            JLabel inverseTooltip = new JLabel(Constant.messages.getString("search.toolbar.label.inverse"));
            inverseTooltip.setToolTipText(Constant.messages.getString("search.toolbar.tooltip.inverse"));
            this.panelToolbar.add((Component)this.getScopeButton(), this.newGBC(0));
            this.panelToolbar.add((Component)this.getRegExField(), this.newGBC(1));
            this.panelToolbar.add(this.getSearchType(), this.newGBC(2));
            this.panelToolbar.add((Component)inverseTooltip, this.newGBC(3));
            this.panelToolbar.add((Component)this.getChkInverse(), this.newGBC(4));
            this.panelToolbar.add((Component)this.getBtnSearch(), this.newGBC(5));
            this.panelToolbar.add((Component)this.getBtnNext(), this.newGBC(6));
            this.panelToolbar.add((Component)this.getBtnPrev(), this.newGBC(7));
            this.panelToolbar.add((Component)new JToolBar.Separator(), this.newGBC(8));
            this.panelToolbar.add((Component)this.getNumberOfMatchesLabel(), this.newGBC(9));
            this.panelToolbar.add((Component)t1, gridBagConstraintsX);
            this.panelToolbar.add(this.getExportButton(), this.newGBC(10));
            this.panelToolbar.add((Component)this.getOptionsButton(), optionsGridBag);
        }
        return this.panelToolbar;
    }

    private JToggleButton getScopeButton() {
        if (this.scopeButton == null) {
            this.scopeButton = new ZapToggleButton();
            this.scopeButton.setIcon(new ImageIcon(SearchPanel.class.getResource("/resource/icon/fugue/target-grey.png")));
            this.scopeButton.setToolTipText(Constant.messages.getString("search.toolbar.tooltip.scope.unselected"));
            this.scopeButton.setSelectedIcon(new ImageIcon(SearchPanel.class.getResource("/resource/icon/fugue/target.png")));
            this.scopeButton.setSelectedToolTipText(Constant.messages.getString("search.toolbar.tooltip.scope.selected"));
            DisplayUtils.scaleIcon(this.scopeButton);
            this.scopeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchPanel.this.extension.setSearchJustInScope(SearchPanel.this.scopeButton.isSelected());
                }
            });
        }
        return this.scopeButton;
    }

    private JCheckBox getChkInverse() {
        if (this.chkInverse == null) {
            this.chkInverse = new JCheckBox();
            this.chkInverse.setToolTipText(Constant.messages.getString("search.toolbar.tooltip.inverse"));
        }
        return this.chkInverse;
    }

    private JButton getBtnSearch() {
        if (this.btnSearch == null) {
            this.btnSearch = new JButton();
            this.btnSearch.setText(Constant.messages.getString("search.toolbar.label.search"));
            this.btnSearch.setIcon(new ImageIcon(SearchPanel.class.getResource("/resource/icon/16/049.png")));
            this.btnSearch.setToolTipText(Constant.messages.getString("search.toolbar.tooltip.search"));
            DisplayUtils.scaleIcon(this.btnSearch);
            this.btnSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SearchPanel.this.doSearch();
                }
            });
        }
        return this.btnSearch;
    }

    private JButton getBtnNext() {
        if (this.btnNext == null) {
            this.btnNext = new JButton();
            this.btnNext.setText(Constant.messages.getString("search.toolbar.label.next"));
            this.btnNext.setIcon(new ImageIcon(SearchPanel.class.getResource("/resource/icon/16/107.png")));
            this.btnNext.setToolTipText(Constant.messages.getString("search.toolbar.tooltip.next"));
            DisplayUtils.scaleIcon(this.btnNext);
            this.btnNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchPanel.this.highlightNextResult();
                }
            });
        }
        return this.btnNext;
    }

    private JButton getBtnPrev() {
        if (this.btnPrev == null) {
            this.btnPrev = new JButton();
            this.btnPrev.setText(Constant.messages.getString("search.toolbar.label.previous"));
            this.btnPrev.setIcon(new ImageIcon(SearchPanel.class.getResource("/resource/icon/16/108.png")));
            this.btnPrev.setToolTipText(Constant.messages.getString("search.toolbar.tooltip.previous"));
            DisplayUtils.scaleIcon(this.btnPrev);
            this.btnPrev.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchPanel.this.highlightPrevResult();
                }
            });
        }
        return this.btnPrev;
    }

    protected ZapTextField getRegExField() {
        if (this.regEx == null) {
            this.regEx = new ZapTextField();
            this.regEx.setHorizontalAlignment(2);
            this.regEx.setAlignmentX(0.0f);
            this.regEx.setPreferredSize(DisplayUtils.getScaledDimension(250, 25));
            this.regEx.setText("");
            this.regEx.setToolTipText(Constant.messages.getString("search.toolbar.tooltip.regex"));
            this.regEx.setMinimumSize(DisplayUtils.getScaledDimension(250, 25));
            this.regEx.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchPanel.this.doSearch();
                }
            });
        }
        return this.regEx;
    }

    private JLabel getNumberOfMatchesLabel() {
        if (this.numberOfMatchesLabel == null) {
            this.numberOfMatchesLabel = new JLabel();
            this.numberOfMatchesFormat = new MessageFormat(Constant.messages.getString("search.toolbar.label.number.of.matches"));
            this.setNumberOfMatches(0);
        }
        return this.numberOfMatchesLabel;
    }

    private void setNumberOfMatches(int numberOfMatches) {
        this.numberOfMatchesLabel.setText(this.numberOfMatchesFormat.format(new Object[]{numberOfMatches}));
    }

    private TableExportButton<SearchResultsTable> getExportButton() {
        if (this.exportButton == null) {
            this.exportButton = new TableExportButton<SearchResultsTable>(this.resultsTable);
        }
        return this.exportButton;
    }

    private JButton getOptionsButton() {
        if (this.optionsButton == null) {
            this.optionsButton = new JButton();
            this.optionsButton.setToolTipText(Constant.messages.getString("search.toolbar.button.options"));
            this.optionsButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(SearchPanel.class.getResource("/resource/icon/16/041.png"))));
            this.optionsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Control.getSingleton().getMenuToolsControl().options(Constant.messages.getString("search.optionspanel.name"));
                }
            });
        }
        return this.optionsButton;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setHorizontalScrollBarPolicy(30);
            this.jScrollPane.setViewportView((Component)((Object)this.resultsTable));
        }
        return this.jScrollPane;
    }

    public void resetSearchResults() {
        this.setNumberOfMatches(0);
        this.resultsModel.clear();
    }

    @Override
    public void addSearchResult(final SearchResult str) {
        if (EventQueue.isDispatchThread()) {
            this.resultsModel.addSearchResult(str);
            this.setNumberOfMatches(this.resultsModel.getRowCount());
            if (this.resultsModel.getRowCount() == 1) {
                this.highlightFirstResult();
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchPanel.this.addSearchResult(str);
                }
            });
        }
    }

    @Deprecated
    public void setDisplayPanel(HttpPanelRequest requestPanel, HttpPanelResponse responsePanel) {
    }

    private void doSearch() {
        int option;
        Pattern pattern;
        try {
            pattern = Pattern.compile(this.regEx.getText());
        }
        catch (IllegalArgumentException e) {
            this.regEx.requestFocusInWindow();
            View.getSingleton().showWarningDialog(Constant.messages.getString("search.toolbar.error.invalid.regex"));
            return;
        }
        if (pattern.matcher("").find() && (option = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), Constant.messages.getString("search.toolbar.warn.regex.match.empty.string.text"), Constant.messages.getString("search.toolbar.warn.regex.match.empty.string.title"), 2, 3, null, new String[]{Constant.messages.getString("search.toolbar.warn.regex.match.empty.string.button.search"), Constant.messages.getString("search.toolbar.warn.regex.match.empty.string.button.cancel")}, null)) != 0) {
            this.regEx.requestFocusInWindow();
            return;
        }
        SearchOption option2 = (SearchOption)this.getSearchType().getSelectedItem();
        ExtensionSearch.Type type = option2.getType();
        String customSearcherName = null;
        if (ExtensionSearch.Type.Custom == type) {
            customSearcherName = option2.getName();
        }
        this.setNumberOfMatches(0);
        this.extension.search(this.regEx.getText(), type, customSearcherName, false, this.chkInverse.isSelected());
        if (this.resultsTable.getModel().getRowCount() > 0) {
            this.resultsTable.getSelectionModel().setSelectionInterval(0, 0);
            this.resultsTable.requestFocus();
        }
    }

    protected void setSearchType(ExtensionSearch.Type type) {
        if (ExtensionSearch.Type.Custom == type) {
            return;
        }
        for (int i = 0; i < this.getSearchType().getItemCount(); ++i) {
            SearchOption option = this.getSearchType().getItemAt(i);
            if (option.getType() != type) continue;
            this.getSearchType().setSelectedIndex(i);
            break;
        }
    }

    private void displayMessage(SearchResult sr) {
        HttpMessage msg = sr.getMessage();
        this.view.displayMessage(msg);
        if (msg == null) {
            return;
        }
        this.highlightFirstResult(sr);
    }

    private void highlightMatch(SearchMatch sm) {
        if (sm == null) {
            return;
        }
        switch (sm.getLocation()) {
            case REQUEST_HEAD: {
                this.view.getRequestPanel().highlightHeader(sm);
                this.view.getRequestPanel().setTabFocus();
                this.view.getRequestPanel().requestFocus();
                break;
            }
            case REQUEST_BODY: {
                this.view.getRequestPanel().highlightBody(sm);
                this.view.getRequestPanel().setTabFocus();
                this.view.getRequestPanel().requestFocus();
                break;
            }
            case RESPONSE_HEAD: {
                this.view.getResponsePanel().highlightHeader(sm);
                this.view.getResponsePanel().setTabFocus();
                this.view.getResponsePanel().requestFocus();
                break;
            }
            case RESPONSE_BODY: {
                this.view.getResponsePanel().highlightBody(sm);
                this.view.getResponsePanel().setTabFocus();
                this.view.getResponsePanel().requestFocus();
            }
        }
    }

    private void highlightFirstResult(SearchResult sr) {
        this.highlightMatch(sr.getFirstMatch(this.view.getRequestPanel(), this.view.getResponsePanel()));
    }

    protected void highlightFirstResult() {
        if (this.resultsTable.getModel().getRowCount() > 0) {
            this.resultsTable.getSelectionModel().setSelectionInterval(0, 0);
            this.resultsTable.scrollRowToVisible(0);
            this.resultsTable.requestFocus();
        }
    }

    protected void highlightNextResult() {
        if (this.resultsTable.getSelectedSearchResult() == null) {
            this.highlightFirstResult();
            return;
        }
        SearchResult sr = this.resultsTable.getSelectedSearchResult();
        SearchMatch sm = sr.getNextMatch();
        if (sm != null) {
            this.highlightMatch(sm);
        } else if (this.resultsTable.getSelectedRow() < this.resultsTable.getModel().getRowCount() - 1) {
            this.resultsTable.getSelectionModel().setSelectionInterval(this.resultsTable.getSelectedRow() + 1, this.resultsTable.getSelectedRow() + 1);
            this.resultsTable.scrollRowToVisible(this.resultsTable.getSelectedRow());
        } else {
            this.highlightFirstResult();
        }
    }

    private void highlightLastResult(SearchResult sr) {
        this.highlightMatch(sr.getLastMatch(this.view.getRequestPanel(), this.view.getResponsePanel()));
    }

    protected void highlightPrevResult() {
        if (this.resultsTable.getSelectedSearchResult() == null) {
            this.highlightFirstResult();
            return;
        }
        SearchResult sr = this.resultsTable.getSelectedSearchResult();
        SearchMatch sm = sr.getPrevMatch();
        if (sm != null) {
            this.highlightMatch(sm);
        } else {
            if (this.resultsTable.getSelectedRow() > 0) {
                this.resultsTable.getSelectionModel().setSelectionInterval(this.resultsTable.getSelectedRow() - 1, this.resultsTable.getSelectedRow() - 1);
            } else {
                this.resultsTable.getSelectionModel().setSelectionInterval(this.resultsTable.getModel().getRowCount() - 1, this.resultsTable.getRowCount() - 1);
            }
            this.resultsTable.scrollRowToVisible(this.resultsTable.getSelectedRow());
            this.highlightLastResult(this.resultsTable.getSelectedSearchResult());
        }
    }

    private JComboBox<SearchOption> getSearchType() {
        if (this.searchType == null) {
            this.searchType = new JComboBox();
            this.searchType.addItem(new SearchOption(Constant.messages.getString("search.toolbar.label.type.all"), ExtensionSearch.Type.All));
            this.searchType.addItem(new SearchOption(Constant.messages.getString("search.toolbar.label.type.url"), ExtensionSearch.Type.URL));
            this.searchType.addItem(new SearchOption(Constant.messages.getString("search.toolbar.label.type.request"), ExtensionSearch.Type.Request));
            this.searchType.addItem(new SearchOption(Constant.messages.getString("search.toolbar.label.type.response"), ExtensionSearch.Type.Response));
            this.searchType.addItem(new SearchOption(Constant.messages.getString("search.toolbar.label.type.header"), ExtensionSearch.Type.Header));
        }
        return this.searchType;
    }

    protected void addCustomSearcher(String name) {
        this.getSearchType().addItem(new SearchOption(name, ExtensionSearch.Type.Custom));
    }

    protected void removeCustomSearcher(String name) {
        for (int i = 0; i < this.getSearchType().getItemCount(); ++i) {
            SearchOption option = this.getSearchType().getItemAt(i);
            if (option.getType() != ExtensionSearch.Type.Custom || !name.equals(option.getName())) continue;
            this.getSearchType().removeItemAt(i);
            break;
        }
    }

    public void searchFocus() {
        this.setTabFocus();
        this.getRegExField().requestFocus();
    }

    @Override
    public void searchComplete() {
    }

    private static class SearchOption {
        private final String name;
        private final ExtensionSearch.Type type;

        public SearchOption(String name, ExtensionSearch.Type type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public ExtensionSearch.Type getType() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }
    }
}

