/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk.image;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.details.jdk.image.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.WindowManager;

class ImageExportAction
extends AbstractAction {
    private static final String DEFAULT_EXPORT_TYPE = "png";
    private static File exportDir;
    private JFileChooser fileChooser;
    private final Image image;

    ImageExportAction(Image image) {
        this.putValue("Name", Bundle.ImageDetailProvider_Action_Export());
        this.putValue("SmallIcon", Icons.getIcon((String)"GeneralIcons.Export"));
        this.putValue("ShortDescription", Bundle.ImageDetailProvider_Action_Export());
        this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.Export"));
        this.image = image;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setDialogType(1);
            this.fileChooser.setFileSelectionMode(2);
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setDialogTitle(Bundle.ImageExportAction_Title());
            this.fileChooser.setApproveButtonText(Bundle.ImageExportAction_Ok());
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".png");
                }

                @Override
                public String getDescription() {
                    return Bundle.ImageExportAction_PNG();
                }
            });
        }
        if (exportDir != null) {
            this.fileChooser.setCurrentDirectory(exportDir);
        }
        if ((n = this.fileChooser.showSaveDialog((Component)WindowManager.getDefault().getRegistry().getActivated())) == 0) {
            exportDir = this.fileChooser.getCurrentDirectory();
            File file = this.fileChooser.getSelectedFile();
            if (file.exists() && !ProfilerDialogs.displayConfirmation((String)Bundle.ImageExportAction_OverwriteFileMsg(file.getName()), (String)Bundle.ImageExportAction_OverwriteFileCaption())) {
                return;
            }
            try {
                this.writeImage(this.fileChooser.getSelectedFile());
            }
            catch (IOException iOException) {
                ProfilerDialogs.displayError((String)Bundle.ImageExportAction_Failed(iOException.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeImage(File file) throws IOException {
        BufferedImage bufferedImage;
        String string;
        int n = file.getName().lastIndexOf(46);
        if (n == -1) {
            file = new File(file.getPath() + '.' + DEFAULT_EXPORT_TYPE);
            string = DEFAULT_EXPORT_TYPE;
        } else {
            string = file.getName().substring(n + 1);
        }
        if (this.image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)this.image;
        } else {
            bufferedImage = new BufferedImage(this.image.getWidth(null), this.image.getHeight(null), 2);
            bufferedImage.createGraphics().drawImage(this.image, 0, 0, null);
        }
        FileObject fileObject = FileUtil.createData((File)file);
        if (fileObject == null) {
            throw new IOException(Bundle.ImageExportAction_InvalidLoc());
        }
        try (OutputStream outputStream = fileObject.getOutputStream();){
            if (!ImageIO.write((RenderedImage)bufferedImage, string, outputStream)) {
                throw new IOException(Bundle.ImageExportAction_WrongFormat(string));
            }
        }
    }
}

