/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.entity;

import java.text.FieldPosition;
import java.text.NumberFormat;
import org.protege.editor.owl.model.entity.AutoIDException;
import org.protege.editor.owl.model.entity.AutoIDGenerator;
import org.protege.editor.owl.model.entity.EntityCreationPreferences;
import org.semanticweb.owlapi.model.OWLEntity;

public abstract class AbstractIDGenerator
implements AutoIDGenerator {
    private static final String START_MACRO = "\\[";
    private static final String END_MACRO = "\\]";

    @Override
    public String getNextID(Class<? extends OWLEntity> type) throws AutoIDException {
        return this.getPrefix(type) + this.pad(this.getRawID(type), this.getDigitLength()) + this.getSuffix(type);
    }

    protected abstract long getRawID(Class<? extends OWLEntity> var1) throws AutoIDException;

    protected String getPrefix(Class<? extends OWLEntity> type) {
        String prefix = EntityCreationPreferences.getPrefix();
        return this.preprocess(prefix, type);
    }

    protected String getSuffix(Class<? extends OWLEntity> type) {
        String suffix = EntityCreationPreferences.getSuffix();
        return this.preprocess(suffix, type);
    }

    protected String preprocess(String s, Class<? extends OWLEntity> type) {
        s = s.replaceAll("\\[user\\]", System.getProperty("user.name", "no_one"));
        s = s.replaceAll("\\[type\\]", type.getSimpleName());
        return s;
    }

    protected int getDigitLength() {
        return EntityCreationPreferences.getAutoIDDigitCount();
    }

    private String pad(long l, int padding) {
        StringBuffer sb = new StringBuffer();
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(0);
        format.setMinimumIntegerDigits(padding);
        format.setMaximumIntegerDigits(padding);
        format.setGroupingUsed(false);
        format.format(l, sb, new FieldPosition(0));
        return sb.toString();
    }
}

