/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public abstract class AnnotationChange
extends OWLOntologyChange {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLAnnotation annotation;

    public AnnotationChange(@Nonnull OWLOntology ont, @Nonnull OWLAnnotation annotation) {
        super(ont);
        this.annotation = OWLAPIPreconditions.checkNotNull(annotation, "annotation cannot be null");
    }

    @Override
    public Set<OWLEntity> getSignature() {
        return this.annotation.getSignature();
    }

    @Nonnull
    public OWLAnnotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public boolean isImportChange() {
        return false;
    }

    @Override
    public boolean isAxiomChange() {
        return false;
    }

    @Override
    public boolean isAddAxiom() {
        return false;
    }

    @Override
    @Nonnull
    public OWLAxiom getAxiom() {
        throw new UnsupportedOperationException("This is an annotation change, not an axiom change: " + this);
    }
}

