/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class VerificationTypeInfo {
    public static final int ITEM_TOP = 0;
    public static final int ITEM_INTEGER = 1;
    public static final int ITEM_FLOAT = 2;
    public static final int ITEM_DOUBLE = 3;
    public static final int ITEM_LONG = 4;
    public static final int ITEM_NULL = 5;
    public static final int ITEM_UNINITIALIZED_THIS = 6;
    public static final int ITEM_OBJECT = 7;
    public static final int ITEM_UNINITIALIZED = 8;
    public int tag;
    private int id;
    private char[] constantPoolName;
    public int offset;

    private VerificationTypeInfo() {
    }

    public VerificationTypeInfo(int n, char[] cArray) {
        this(n, 7, cArray);
    }

    public VerificationTypeInfo(int n, int n2, char[] cArray) {
        this.id = n;
        this.tag = n2;
        this.constantPoolName = cArray;
    }

    public VerificationTypeInfo(int n, TypeBinding typeBinding) {
        this(typeBinding);
        this.tag = n;
    }

    public VerificationTypeInfo(TypeBinding typeBinding) {
        this.id = typeBinding.id;
        switch (typeBinding.id) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                this.tag = 1;
                break;
            }
            case 9: {
                this.tag = 2;
                break;
            }
            case 7: {
                this.tag = 4;
                break;
            }
            case 8: {
                this.tag = 3;
                break;
            }
            case 12: {
                this.tag = 5;
                break;
            }
            default: {
                this.tag = 7;
                this.constantPoolName = typeBinding.constantPoolName();
            }
        }
    }

    public void setBinding(TypeBinding typeBinding) {
        int n;
        this.constantPoolName = typeBinding.constantPoolName();
        this.id = n = typeBinding.id;
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                this.tag = 1;
                break;
            }
            case 9: {
                this.tag = 2;
                break;
            }
            case 7: {
                this.tag = 4;
                break;
            }
            case 8: {
                this.tag = 3;
                break;
            }
            case 12: {
                this.tag = 5;
                break;
            }
            default: {
                this.tag = 7;
            }
        }
    }

    public int id() {
        return this.id;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.tag) {
            case 6: {
                stringBuffer.append("uninitialized_this(").append(this.readableName()).append(")");
                break;
            }
            case 8: {
                stringBuffer.append("uninitialized(").append(this.readableName()).append(")");
                break;
            }
            case 7: {
                stringBuffer.append(this.readableName());
                break;
            }
            case 3: {
                stringBuffer.append('D');
                break;
            }
            case 2: {
                stringBuffer.append('F');
                break;
            }
            case 1: {
                stringBuffer.append('I');
                break;
            }
            case 4: {
                stringBuffer.append('J');
                break;
            }
            case 5: {
                stringBuffer.append("null");
                break;
            }
            case 0: {
                stringBuffer.append("top");
            }
        }
        return String.valueOf(stringBuffer);
    }

    public VerificationTypeInfo duplicate() {
        VerificationTypeInfo verificationTypeInfo = new VerificationTypeInfo();
        verificationTypeInfo.id = this.id;
        verificationTypeInfo.tag = this.tag;
        verificationTypeInfo.constantPoolName = this.constantPoolName;
        verificationTypeInfo.offset = this.offset;
        return verificationTypeInfo;
    }

    public boolean equals(Object object) {
        if (object instanceof VerificationTypeInfo) {
            VerificationTypeInfo verificationTypeInfo = (VerificationTypeInfo)object;
            return verificationTypeInfo.tag == this.tag && CharOperation.equals(verificationTypeInfo.constantPoolName(), this.constantPoolName());
        }
        return false;
    }

    public int hashCode() {
        return this.tag + this.id + this.constantPoolName.length + this.offset;
    }

    public char[] constantPoolName() {
        return this.constantPoolName;
    }

    public char[] readableName() {
        return this.constantPoolName;
    }

    public void replaceWithElementType() {
        if (this.constantPoolName[1] == 'L') {
            this.constantPoolName = CharOperation.subarray(this.constantPoolName, 2, this.constantPoolName.length - 1);
        } else {
            this.constantPoolName = CharOperation.subarray(this.constantPoolName, 1, this.constantPoolName.length);
            if (this.constantPoolName.length == 1) {
                switch (this.constantPoolName[0]) {
                    case 'I': {
                        this.id = 10;
                        break;
                    }
                    case 'B': {
                        this.id = 3;
                        break;
                    }
                    case 'S': {
                        this.id = 4;
                        break;
                    }
                    case 'C': {
                        this.id = 2;
                        break;
                    }
                    case 'J': {
                        this.id = 7;
                        break;
                    }
                    case 'F': {
                        this.id = 9;
                        break;
                    }
                    case 'D': {
                        this.id = 8;
                        break;
                    }
                    case 'Z': {
                        this.id = 5;
                        break;
                    }
                    case 'N': {
                        this.id = 12;
                        break;
                    }
                    case 'V': {
                        this.id = 6;
                    }
                }
            }
        }
    }
}

