// Generated by CoffeeScript 1.10.0
var Slack, apiToken, domain, nock, should, url, webhookToken, webhookUri;

should = require("should");

nock = require("nock");

url = require("url");

Slack = require("../index");

nock.enableNetConnect();

domain = "slack-node";

webhookToken = "ROHgstANbsFAUA5dHHI5JONu";

apiToken = "xoxp-2307918714-2307918716-2307910813-17cabf";

webhookUri = "https://hooks.slack.com/services/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";

describe('slack new webhook test', function() {
  var slack;
  this.timeout(50000);
  slack = new Slack();
  slack.setWebhook(webhookUri);
  it('should create a slack object', function(done) {
    slack.should.be.an.Object;
    return done();
  });
  it('should send a correct response', function(done) {
    return slack.webhook({
      channel: "#general",
      username: "webhookbot",
      text: "This is posted to #general and comes from a bot named webhookbot."
    }, function(err, response) {
      if (err) {
        return done(err);
      }
      response.should.be.ok.and.an.Object;
      return done();
    });
  });
  it('should send a correct response with emoji', function(done) {
    return slack.webhook({
      channel: "#general",
      username: "webhookbot",
      text: "This is posted to #general and comes from a bot named webhookbot.",
      icon_emoji: ":ghost:"
    }, function(err, response) {
      if (err) {
        return done(err);
      }
      response.should.be.ok.and.an.Object;
      return done();
    });
  });
  return it('should have status code and headers', function(done) {
    return slack.webhook({
      channel: "#general",
      username: "webhookbot",
      text: "This is posted to #general and comes from a bot named webhookbot.",
      "icon_emoji": ":ghost:"
    }, function(err, response) {
      if (err) {
        return done(err);
      }
      response.statusCode.should.be.a.Number;
      response.headers.should.be.an.Object;
      return done();
    });
  });
});

describe("slack api part", function() {
  var slack;
  this.timeout(50000);
  slack = new Slack(apiToken);
  it('should return a slack object', function(done) {
    slack.should.be.an.Object;
    return done();
  });
  it("run with user.list", function(done) {
    return slack.api("users.list", function(err, response) {
      response.should.be.ok.and.an.Object;
      return done();
    });
  });
  return it("run with Attachments", function(done) {
    var payload;
    payload = {
      channel: "#general",
      username: "webhookbot",
      text: "This is posted to #general and comes from a bot named webhookbot.",
      icon_emoji: ":ghost:",
      attachments: [
        {
          "pretext": "pretext",
          "color": "#0000FF",
          "fields": [
            {
              "title": "title",
              "value": "foobar",
              "short": false
            }
          ]
        }
      ]
    };
    return slack.api('chat.postMessage', payload, function(err, response) {
      response.should.be.ok.and.an.Object;
      return done();
    });
  });
});

describe("emoji test", function() {
  var slack;
  slack = new Slack(webhookToken, domain);
  it('emoji give empty value', function(done) {
    var obj;
    obj = slack.detectEmoji();
    obj.should.be.an.Object;
    obj["key"].should.equal("icon_emoji");
    obj["val"].should.equal("");
    return done();
  });
  it('emoji using :ghost: style', function(done) {
    var obj;
    obj = slack.detectEmoji(":ghost:");
    obj.should.be.an.Object;
    obj["key"].should.equal("icon_emoji");
    obj["val"].should.equal(":ghost:");
    return done();
  });
  return it('emoji using http image url', function(done) {
    var obj;
    obj = slack.detectEmoji("http://icons.iconarchive.com/icons/rokey/popo-emotions/128/after-boom-icon.png");
    obj.should.be.an.Object;
    obj["key"].should.equal("icon_url");
    obj["val"].should.equal("http://icons.iconarchive.com/icons/rokey/popo-emotions/128/after-boom-icon.png");
    return done();
  });
});

describe("lack something", function() {
  var slack;
  slack = new Slack(webhookToken, domain);
  return it('without callback', function(done) {
    var feedback, method;
    method = "files.list";
    feedback = slack.api(method);
    feedback.should.be.an.Object;
    feedback.should.equal(slack);
    feedback.should.not.be["null"];
    return done();
  });
});

describe('parse test', function() {
  var slack;
  slack = new Slack(webhookToken, domain);
  slack.url = 'https://httpbin.org/xml';
  return it('does not crash if XML is returned', function(done) {
    return slack.api("users.list", function(err, response) {
      err.message.should.containEql("Couldn't parse Slack API response");
      return done();
    });
  });
});

describe("retry test", function() {
  var slack;
  this.timeout(50000);
  slack = null;
  beforeEach(function() {
    slack = new Slack();
    slack.setWebhook(webhookUri);
    return slack.timeout = 10;
  });
  return it("Should retry if a request to slack fails after a timeout", function(done) {
    var mockWebhook, webhookDetails;
    webhookDetails = url.parse(webhookUri);
    mockWebhook = nock(webhookDetails.protocol + "//" + webhookDetails.host).post(webhookDetails.path).times(3).socketDelay(20).reply(204, '');
    return slack.webhook({
      channel: "#general",
      username: "webhookbot",
      text: "This is posted to #general and comes from a bot named webhookbot."
    }, function(err, response) {
      should.exist(err);
      should.not.exist(response);
      should.equal(mockWebhook.isDone(), true);
      return done();
    });
  });
});
