/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.BooleanOptional;
import Ice.ByteOptional;
import Ice.DoubleOptional;
import Ice.FloatOptional;
import Ice.IntOptional;
import Ice.LongOptional;
import Ice.ShortOptional;

public class Optional<T> {
    private T _value;
    private boolean _isSet;

    public Optional() {
        this._isSet = false;
    }

    public Optional(T v) {
        this._value = v;
        this._isSet = true;
    }

    public Optional(Optional<T> opt) {
        this._value = opt._value;
        this._isSet = opt._isSet;
    }

    public T get() {
        if (!this._isSet) {
            throw new IllegalStateException("no value is set");
        }
        return this._value;
    }

    public void set(T v) {
        this._value = v;
        this._isSet = true;
    }

    public void set(Optional<T> opt) {
        this._value = opt._value;
        this._isSet = opt._isSet;
    }

    public boolean isSet() {
        return this._isSet;
    }

    public void clear() {
        this._isSet = false;
        this._value = null;
    }

    public static <T> Optional<T> O(T v) {
        return new Optional<T>(v);
    }

    public static BooleanOptional O(boolean v) {
        return new BooleanOptional(v);
    }

    public static ByteOptional O(byte v) {
        return new ByteOptional(v);
    }

    public static ShortOptional O(short v) {
        return new ShortOptional(v);
    }

    public static IntOptional O(int v) {
        return new IntOptional(v);
    }

    public static LongOptional O(long v) {
        return new LongOptional(v);
    }

    public static FloatOptional O(float v) {
        return new FloatOptional(v);
    }

    public static DoubleOptional O(double v) {
        return new DoubleOptional(v);
    }
}

