/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import IceSSL.SSLEngine;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;

final class X509TrustManagerI
implements X509TrustManager {
    private SSLEngine _engine;
    private X509TrustManager _delegate;
    private X509Certificate[] EMPTY = new X509Certificate[0];

    X509TrustManagerI(SSLEngine engine, X509TrustManager delegate) {
        this._engine = engine;
        this._delegate = delegate;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (authType.indexOf("DH_anon") == -1) {
            try {
                this._delegate.checkClientTrusted(chain, authType);
            }
            catch (CertificateException ex) {
                this._engine.trustManagerFailure(true, ex);
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (authType.indexOf("DH_anon") == -1) {
            try {
                this._delegate.checkServerTrusted(chain, authType);
            }
            catch (CertificateException ex) {
                this._engine.trustManagerFailure(false, ex);
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.EMPTY;
    }
}

