// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `Descriptor.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * An application update descriptor to describe the updates to apply
 * to a deployed application.
 *
 **/
public class ApplicationUpdateDescriptor implements java.lang.Cloneable,
                                                    java.io.Serializable
{
    /**
     * The name of the application to update.
     *
     **/
    public String name;

    /**
     * The updated description (or null if the description wasn't
     * updated.)
     *
     **/
    public BoxedString description;

    /**
     * The updated distribution application descriptor.
     *
     **/
    public BoxedDistributionDescriptor distrib;

    /**
     * The variables to update.
     *
     **/
    public java.util.Map<java.lang.String, java.lang.String> variables;

    /**
     * The variables to remove.
     *
     **/
    public String[] removeVariables;

    /**
     * The property sets to update.
     *
     **/
    public java.util.Map<java.lang.String, PropertySetDescriptor> propertySets;

    /**
     * The property sets to remove.
     *
     **/
    public String[] removePropertySets;

    /**
     * The replica groups to update.
     *
     **/
    public java.util.List<ReplicaGroupDescriptor> replicaGroups;

    /**
     * The replica groups to remove.
     *
     **/
    public String[] removeReplicaGroups;

    /**
     * The server templates to update.
     *
     **/
    public java.util.Map<java.lang.String, TemplateDescriptor> serverTemplates;

    /**
     * The ids of the server template to remove.
     *
     **/
    public String[] removeServerTemplates;

    /**
     * The service templates to update.
     *
     **/
    public java.util.Map<java.lang.String, TemplateDescriptor> serviceTemplates;

    /**
     * The ids of the service template to remove.
     *
     **/
    public String[] removeServiceTemplates;

    /**
     * The application nodes to update.
     *
     **/
    public java.util.List<NodeUpdateDescriptor> nodes;

    /**
     * The nodes to remove.
     *
     **/
    public String[] removeNodes;

    public ApplicationUpdateDescriptor()
    {
        this.name = "";
    }

    public ApplicationUpdateDescriptor(String name, BoxedString description, BoxedDistributionDescriptor distrib, java.util.Map<java.lang.String, java.lang.String> variables, String[] removeVariables, java.util.Map<java.lang.String, PropertySetDescriptor> propertySets, String[] removePropertySets, java.util.List<ReplicaGroupDescriptor> replicaGroups, String[] removeReplicaGroups, java.util.Map<java.lang.String, TemplateDescriptor> serverTemplates, String[] removeServerTemplates, java.util.Map<java.lang.String, TemplateDescriptor> serviceTemplates, String[] removeServiceTemplates, java.util.List<NodeUpdateDescriptor> nodes, String[] removeNodes)
    {
        this.name = name;
        this.description = description;
        this.distrib = distrib;
        this.variables = variables;
        this.removeVariables = removeVariables;
        this.propertySets = propertySets;
        this.removePropertySets = removePropertySets;
        this.replicaGroups = replicaGroups;
        this.removeReplicaGroups = removeReplicaGroups;
        this.serverTemplates = serverTemplates;
        this.removeServerTemplates = removeServerTemplates;
        this.serviceTemplates = serviceTemplates;
        this.removeServiceTemplates = removeServiceTemplates;
        this.nodes = nodes;
        this.removeNodes = removeNodes;
    }

    public boolean
    equals(java.lang.Object rhs)
    {
        if(this == rhs)
        {
            return true;
        }
        ApplicationUpdateDescriptor r = null;
        if(rhs instanceof ApplicationUpdateDescriptor)
        {
            r = (ApplicationUpdateDescriptor)rhs;
        }

        if(r != null)
        {
            if(this.name != r.name)
            {
                if(this.name == null || r.name == null || !this.name.equals(r.name))
                {
                    return false;
                }
            }
            if(this.description != r.description)
            {
                if(this.description == null || r.description == null || !this.description.equals(r.description))
                {
                    return false;
                }
            }
            if(this.distrib != r.distrib)
            {
                if(this.distrib == null || r.distrib == null || !this.distrib.equals(r.distrib))
                {
                    return false;
                }
            }
            if(this.variables != r.variables)
            {
                if(this.variables == null || r.variables == null || !this.variables.equals(r.variables))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(this.removeVariables, r.removeVariables))
            {
                return false;
            }
            if(this.propertySets != r.propertySets)
            {
                if(this.propertySets == null || r.propertySets == null || !this.propertySets.equals(r.propertySets))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(this.removePropertySets, r.removePropertySets))
            {
                return false;
            }
            if(this.replicaGroups != r.replicaGroups)
            {
                if(this.replicaGroups == null || r.replicaGroups == null || !this.replicaGroups.equals(r.replicaGroups))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(this.removeReplicaGroups, r.removeReplicaGroups))
            {
                return false;
            }
            if(this.serverTemplates != r.serverTemplates)
            {
                if(this.serverTemplates == null || r.serverTemplates == null || !this.serverTemplates.equals(r.serverTemplates))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(this.removeServerTemplates, r.removeServerTemplates))
            {
                return false;
            }
            if(this.serviceTemplates != r.serviceTemplates)
            {
                if(this.serviceTemplates == null || r.serviceTemplates == null || !this.serviceTemplates.equals(r.serviceTemplates))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(this.removeServiceTemplates, r.removeServiceTemplates))
            {
                return false;
            }
            if(this.nodes != r.nodes)
            {
                if(this.nodes == null || r.nodes == null || !this.nodes.equals(r.nodes))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(this.removeNodes, r.removeNodes))
            {
                return false;
            }

            return true;
        }

        return false;
    }

    public int
    hashCode()
    {
        int h_ = 5381;
        h_ = IceInternal.HashUtil.hashAdd(h_, "::IceGrid::ApplicationUpdateDescriptor");
        h_ = IceInternal.HashUtil.hashAdd(h_, name);
        h_ = IceInternal.HashUtil.hashAdd(h_, description);
        h_ = IceInternal.HashUtil.hashAdd(h_, distrib);
        h_ = IceInternal.HashUtil.hashAdd(h_, variables);
        h_ = IceInternal.HashUtil.hashAdd(h_, removeVariables);
        h_ = IceInternal.HashUtil.hashAdd(h_, propertySets);
        h_ = IceInternal.HashUtil.hashAdd(h_, removePropertySets);
        h_ = IceInternal.HashUtil.hashAdd(h_, replicaGroups);
        h_ = IceInternal.HashUtil.hashAdd(h_, removeReplicaGroups);
        h_ = IceInternal.HashUtil.hashAdd(h_, serverTemplates);
        h_ = IceInternal.HashUtil.hashAdd(h_, removeServerTemplates);
        h_ = IceInternal.HashUtil.hashAdd(h_, serviceTemplates);
        h_ = IceInternal.HashUtil.hashAdd(h_, removeServiceTemplates);
        h_ = IceInternal.HashUtil.hashAdd(h_, nodes);
        h_ = IceInternal.HashUtil.hashAdd(h_, removeNodes);
        return h_;
    }

    public ApplicationUpdateDescriptor
    clone()
    {
        ApplicationUpdateDescriptor c = null;
        try
        {
            c = (ApplicationUpdateDescriptor)super.clone();
        }
        catch(CloneNotSupportedException ex)
        {
            assert false; // impossible
        }
        return c;
    }

    public void
    ice_writeMembers(Ice.OutputStream ostr)
    {
        ostr.writeString(this.name);
        ostr.writeValue(this.description);
        ostr.writeValue(this.distrib);
        StringStringDictHelper.write(ostr, this.variables);
        Ice.StringSeqHelper.write(ostr, this.removeVariables);
        PropertySetDescriptorDictHelper.write(ostr, this.propertySets);
        Ice.StringSeqHelper.write(ostr, this.removePropertySets);
        ReplicaGroupDescriptorSeqHelper.write(ostr, this.replicaGroups);
        Ice.StringSeqHelper.write(ostr, this.removeReplicaGroups);
        TemplateDescriptorDictHelper.write(ostr, this.serverTemplates);
        Ice.StringSeqHelper.write(ostr, this.removeServerTemplates);
        TemplateDescriptorDictHelper.write(ostr, this.serviceTemplates);
        Ice.StringSeqHelper.write(ostr, this.removeServiceTemplates);
        NodeUpdateDescriptorSeqHelper.write(ostr, this.nodes);
        Ice.StringSeqHelper.write(ostr, this.removeNodes);
    }

    private class Patcher implements Ice.ReadValueCallback
    {
        Patcher(int member)
        {
            _member = member;
        }

        public void
        valueReady(Ice.Object v)
        {
            switch(_member)
            {
            case 0:
                _typeId = "::IceGrid::BoxedString";
                if(v == null || v instanceof BoxedString)
                {
                    description = (BoxedString)v;
                }
                else
                {
                    IceInternal.Ex.throwUOE(type(), v);
                }
                break;
            case 1:
                _typeId = "::IceGrid::BoxedDistributionDescriptor";
                if(v == null || v instanceof BoxedDistributionDescriptor)
                {
                    distrib = (BoxedDistributionDescriptor)v;
                }
                else
                {
                    IceInternal.Ex.throwUOE(type(), v);
                }
                break;
            }
        }

        public String
        type()
        {
            return _typeId;
        }

        private int _member;
        private String _typeId;
    }

    public void
    ice_readMembers(Ice.InputStream istr)
    {
        this.name = istr.readString();
        istr.readValue(new Patcher(0));
        istr.readValue(new Patcher(1));
        this.variables = new java.util.TreeMap<String, String>();
        int sz0 = istr.readSize();
        for(int i0 = 0; i0 < sz0; i0++)
        {
            String key;
            key = istr.readString();
            String value;
            value = istr.readString();
            this.variables.put(key, value);
        }
        this.removeVariables = Ice.StringSeqHelper.read(istr);
        this.propertySets = PropertySetDescriptorDictHelper.read(istr);
        this.removePropertySets = Ice.StringSeqHelper.read(istr);
        this.replicaGroups = ReplicaGroupDescriptorSeqHelper.read(istr);
        this.removeReplicaGroups = Ice.StringSeqHelper.read(istr);
        this.serverTemplates = TemplateDescriptorDictHelper.read(istr);
        this.removeServerTemplates = Ice.StringSeqHelper.read(istr);
        this.serviceTemplates = TemplateDescriptorDictHelper.read(istr);
        this.removeServiceTemplates = Ice.StringSeqHelper.read(istr);
        this.nodes = NodeUpdateDescriptorSeqHelper.read(istr);
        this.removeNodes = Ice.StringSeqHelper.read(istr);
    }

    static public void
    ice_write(Ice.OutputStream ostr, ApplicationUpdateDescriptor v)
    {
        if(v == null)
        {
            _nullMarshalValue.ice_writeMembers(ostr);
        }
        else
        {
            v.ice_writeMembers(ostr);
        }
    }

    static public ApplicationUpdateDescriptor
    ice_read(Ice.InputStream istr)
    {
        ApplicationUpdateDescriptor v = new ApplicationUpdateDescriptor();
        v.ice_readMembers(istr);
        return v;
    }

    private static final ApplicationUpdateDescriptor _nullMarshalValue = new ApplicationUpdateDescriptor();

    public static final long serialVersionUID = 317496849L;
}
