/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.ValueSource;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;

public final class AppendProcessor
extends AbstractProcessor {
    public static final String TYPE = "append";
    private final TemplateScript.Factory field;
    private final ValueSource value;

    AppendProcessor(String tag, TemplateScript.Factory field, ValueSource value) {
        super(tag);
        this.field = field;
        this.value = value;
    }

    public TemplateScript.Factory getField() {
        return this.field;
    }

    public ValueSource getValue() {
        return this.value;
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        ingestDocument.appendFieldValue(this.field, this.value);
        return ingestDocument;
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public AppendProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)AppendProcessor.TYPE, (String)processorTag, config, (String)"field");
            Object value = ConfigurationUtils.readObject((String)AppendProcessor.TYPE, (String)processorTag, config, (String)"value");
            TemplateScript.Factory compiledTemplate = ConfigurationUtils.compileTemplate((String)AppendProcessor.TYPE, (String)processorTag, (String)"field", (String)field, (ScriptService)this.scriptService);
            return new AppendProcessor(processorTag, compiledTemplate, ValueSource.wrap((Object)value, (ScriptService)this.scriptService));
        }
    }
}

