/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tribe;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.MergableCustomMetaData;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.node.Node;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.TcpTransport;

public class TribeService
extends AbstractLifecycleComponent {
    public static final ClusterBlock TRIBE_METADATA_BLOCK = new ClusterBlock(10, "tribe node, metadata not allowed", false, false, false, RestStatus.BAD_REQUEST, EnumSet.of(ClusterBlockLevel.METADATA_READ, ClusterBlockLevel.METADATA_WRITE));
    public static final ClusterBlock TRIBE_WRITE_BLOCK = new ClusterBlock(11, "tribe node, write not allowed", false, false, false, RestStatus.BAD_REQUEST, EnumSet.of(ClusterBlockLevel.WRITE));
    public static final Setting<String> TRIBE_NAME_SETTING = Setting.simpleString((String)"tribe.name", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final ClusterService clusterService;
    private final String[] blockIndicesWrite;
    private final String[] blockIndicesRead;
    private final String[] blockIndicesMetadata;
    private static final String ON_CONFLICT_ANY = "any";
    private static final String ON_CONFLICT_DROP = "drop";
    private static final String ON_CONFLICT_PREFER = "prefer_";
    public static final Setting<String> ON_CONFLICT_SETTING = new Setting("tribe.on_conflict", "any", s -> {
        switch (s) {
            case "any": 
            case "drop": {
                return s;
            }
        }
        if (s.startsWith(ON_CONFLICT_PREFER) && s.length() > ON_CONFLICT_PREFER.length()) {
            return s;
        }
        throw new IllegalArgumentException("Invalid value for [tribe.on_conflict] must be either [any, drop or start with prefer_] but was: [" + s + "]");
    }, new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> BLOCKS_METADATA_SETTING = Setting.boolSetting((String)"tribe.blocks.metadata", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> BLOCKS_WRITE_SETTING = Setting.boolSetting((String)"tribe.blocks.write", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> BLOCKS_WRITE_INDICES_SETTING = Setting.listSetting((String)"tribe.blocks.write.indices", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> BLOCKS_READ_INDICES_SETTING = Setting.listSetting((String)"tribe.blocks.read.indices", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> BLOCKS_METADATA_INDICES_SETTING = Setting.listSetting((String)"tribe.blocks.metadata.indices", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Set<String> TRIBE_SETTING_KEYS = Sets.newHashSet((Object[])new String[]{TRIBE_NAME_SETTING.getKey(), ON_CONFLICT_SETTING.getKey(), BLOCKS_METADATA_INDICES_SETTING.getKey(), BLOCKS_METADATA_SETTING.getKey(), BLOCKS_READ_INDICES_SETTING.getKey(), BLOCKS_WRITE_INDICES_SETTING.getKey(), BLOCKS_WRITE_SETTING.getKey()});
    private static final List<Setting<?>> PASS_THROUGH_SETTINGS = Arrays.asList(NetworkService.GLOBAL_NETWORK_HOST_SETTING, NetworkService.GLOBAL_NETWORK_BINDHOST_SETTING, NetworkService.GLOBAL_NETWORK_PUBLISHHOST_SETTING, TcpTransport.HOST, TcpTransport.BIND_HOST, TcpTransport.PUBLISH_HOST);
    private final String onConflict;
    private final Set<String> droppedIndices = ConcurrentCollections.newConcurrentSet();
    private final List<Node> nodes = new CopyOnWriteArrayList<Node>();
    private final NamedWriteableRegistry namedWriteableRegistry;

    public TribeService(Settings settings, NodeEnvironment nodeEnvironment, ClusterService clusterService, NamedWriteableRegistry namedWriteableRegistry, Function<Settings, Node> clientNodeBuilder) {
        super(settings);
        this.clusterService = clusterService;
        this.namedWriteableRegistry = namedWriteableRegistry;
        HashMap nodesSettings = new HashMap(settings.getGroups("tribe", true));
        nodesSettings.remove("blocks");
        nodesSettings.remove("on_conflict");
        for (Map.Entry entry : nodesSettings.entrySet()) {
            Settings clientSettings = TribeService.buildClientSettings((String)entry.getKey(), nodeEnvironment.nodeId(), settings, (Settings)entry.getValue());
            try {
                this.nodes.add(clientNodeBuilder.apply(clientSettings));
            }
            catch (Exception e) {
                for (Node otherNode : this.nodes) {
                    try {
                        otherNode.close();
                    }
                    catch (Exception inner) {
                        inner.addSuppressed(e);
                        this.logger.warn(() -> new ParameterizedMessage("failed to close node {} on failed start", (Object)otherNode), (Throwable)inner);
                    }
                }
                throw ExceptionsHelper.convertToRuntime((Exception)e);
            }
        }
        this.blockIndicesMetadata = ((List)BLOCKS_METADATA_INDICES_SETTING.get(settings)).toArray(Strings.EMPTY_ARRAY);
        this.blockIndicesRead = ((List)BLOCKS_READ_INDICES_SETTING.get(settings)).toArray(Strings.EMPTY_ARRAY);
        this.blockIndicesWrite = ((List)BLOCKS_WRITE_INDICES_SETTING.get(settings)).toArray(Strings.EMPTY_ARRAY);
        if (!this.nodes.isEmpty()) {
            new DeprecationLogger(Loggers.getLogger(TribeService.class)).deprecated("tribe nodes are deprecated in favor of cross-cluster search and will be removed in Elasticsearch 7.0.0", new Object[0]);
        }
        this.onConflict = (String)ON_CONFLICT_SETTING.get(settings);
    }

    static Settings buildClientSettings(String tribeName, String parentNodeId, Settings globalSettings, Settings tribeSettings) {
        for (Object tribeKey : tribeSettings.keySet()) {
            if (!((String)tribeKey).startsWith("path.")) continue;
            throw new IllegalArgumentException("Setting [" + (String)tribeKey + "] not allowed in tribe client [" + tribeName + "]");
        }
        Settings.Builder sb = Settings.builder().put(tribeSettings);
        sb.put(Node.NODE_NAME_SETTING.getKey(), (String)Node.NODE_NAME_SETTING.get(globalSettings) + "/" + tribeName);
        sb.put(Environment.PATH_HOME_SETTING.getKey(), (String)Environment.PATH_HOME_SETTING.get(globalSettings));
        if (Environment.PATH_LOGS_SETTING.exists(globalSettings)) {
            sb.put(Environment.PATH_LOGS_SETTING.getKey(), (String)Environment.PATH_LOGS_SETTING.get(globalSettings));
        }
        for (Setting setting : PASS_THROUGH_SETTINGS) {
            if (setting.exists(tribeSettings) || !setting.exists(globalSettings)) continue;
            sb.put(setting.getKey(), globalSettings.get(setting.getKey()));
        }
        sb.put(TRIBE_NAME_SETTING.getKey(), tribeName);
        if (sb.get(NetworkModule.HTTP_ENABLED.getKey()) == null) {
            sb.put(NetworkModule.HTTP_ENABLED.getKey(), false);
        }
        sb.put(Node.NODE_DATA_SETTING.getKey(), false);
        sb.put(Node.NODE_MASTER_SETTING.getKey(), false);
        sb.put(Node.NODE_INGEST_SETTING.getKey(), false);
        BytesRef seedAsString = new BytesRef((CharSequence)(parentNodeId + "/" + tribeName));
        long l = MurmurHash3.hash128((byte[])seedAsString.bytes, (int)seedAsString.offset, (int)seedAsString.length, (long)0L, (MurmurHash3.Hash128)new MurmurHash3.Hash128()).h1;
        sb.put(NodeEnvironment.NODE_ID_SEED_SETTING.getKey(), l);
        sb.put(Node.NODE_LOCAL_STORAGE_SETTING.getKey(), false);
        return sb.build();
    }

    protected void doStart() {
    }

    public void startNodes() {
        for (Node node : this.nodes) {
            try {
                TribeService.getClusterService(node).addListener((ClusterStateListener)new TribeClusterStateListener(node));
                node.start();
            }
            catch (Exception e) {
                for (Node otherNode : this.nodes) {
                    try {
                        otherNode.close();
                    }
                    catch (Exception inner) {
                        inner.addSuppressed(e);
                        this.logger.warn(() -> new ParameterizedMessage("failed to close node {} on failed start", (Object)otherNode), (Throwable)inner);
                    }
                }
                throw ExceptionsHelper.convertToRuntime((Exception)e);
            }
        }
    }

    protected void doStop() {
        this.doClose();
    }

    protected void doClose() {
        for (Node node : this.nodes) {
            try {
                node.close();
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("failed to close node {}", (Object)node), (Throwable)e);
            }
        }
    }

    private static ClusterService getClusterService(Node node) {
        return (ClusterService)node.injector().getInstance(ClusterService.class);
    }

    static Map<String, MetaData.Custom> mergeChangedCustomMetaData(Set<String> changedCustomMetaDataTypeSet, Function<String, List<MergableCustomMetaData>> customMetaDataByTribeNode) {
        HashMap<String, MetaData.Custom> changedCustomMetaDataMap = new HashMap<String, MetaData.Custom>(changedCustomMetaDataTypeSet.size());
        for (String customMetaDataType : changedCustomMetaDataTypeSet) {
            customMetaDataByTribeNode.apply(customMetaDataType).stream().reduce((mergableCustomMD, mergableCustomMD2) -> (MergableCustomMetaData)mergableCustomMD.merge((MetaData.Custom)mergableCustomMD2)).ifPresent(mergedCustomMetaData -> changedCustomMetaDataMap.put(customMetaDataType, (MetaData.Custom)mergedCustomMetaData));
        }
        return changedCustomMetaDataMap;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private MetaData.Custom marshal(MetaData.Custom custom) {
        try (BytesStreamOutput bytesStreamOutput = new BytesStreamOutput();){
            MetaData.Custom custom2;
            block13: {
                bytesStreamOutput.writeNamedWriteable((NamedWriteable)custom);
                StreamInput input = bytesStreamOutput.bytes().streamInput();
                try {
                    MetaData.Custom marshaled;
                    NamedWriteableAwareStreamInput namedInput = new NamedWriteableAwareStreamInput(input, this.namedWriteableRegistry);
                    custom2 = marshaled = (MetaData.Custom)namedInput.readNamedWriteable(MetaData.Custom.class);
                    if (input == null) break block13;
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                input.close();
            }
            return custom2;
        }
        catch (IOException ex) {
            throw new IllegalStateException("cannot marshal object with type " + custom.getWriteableName() + " to tribe node");
        }
    }

    class TribeNodeClusterStateTaskExecutor
    implements ClusterStateTaskExecutor<ClusterChangedEvent> {
        private final String tribeName;

        TribeNodeClusterStateTaskExecutor(String tribeName) {
            this.tribeName = tribeName;
        }

        public String describeTasks(List<ClusterChangedEvent> tasks) {
            return tasks.stream().map(ClusterChangedEvent::source).reduce((s1, s2) -> s1 + ", " + s2).orElse("");
        }

        public boolean runOnlyOnMaster() {
            return false;
        }

        public ClusterStateTaskExecutor.ClusterTasksResult<ClusterChangedEvent> execute(ClusterState currentState, List<ClusterChangedEvent> tasks) throws Exception {
            ClusterStateTaskExecutor.ClusterTasksResult.Builder builder = ClusterStateTaskExecutor.ClusterTasksResult.builder();
            ClusterState.Builder newState = ClusterState.builder((ClusterState)currentState);
            boolean clusterStateChanged = this.updateNodes(currentState, tasks, newState);
            builder.successes(tasks);
            return builder.build((clusterStateChanged |= this.updateIndicesAndMetaData(currentState, tasks, newState)) ? newState.build() : currentState);
        }

        private boolean updateNodes(ClusterState currentState, List<ClusterChangedEvent> tasks, ClusterState.Builder newState) {
            boolean clusterStateChanged = false;
            ClusterChangedEvent latestTask = tasks.get(tasks.size() - 1);
            ClusterState tribeState = latestTask.state();
            DiscoveryNodes.Builder nodes = DiscoveryNodes.builder((DiscoveryNodes)currentState.nodes());
            for (DiscoveryNode discoNode : currentState.nodes()) {
                String markedTribeName = (String)discoNode.getAttributes().get(TRIBE_NAME_SETTING.getKey());
                if (markedTribeName == null || !markedTribeName.equals(this.tribeName) || tribeState.nodes().get(discoNode.getId()) != null) continue;
                clusterStateChanged = true;
                TribeService.this.logger.info("[{}] removing node [{}]", (Object)this.tribeName, (Object)discoNode);
                nodes.remove(discoNode.getId());
            }
            for (DiscoveryNode tribe : tribeState.nodes()) {
                if (currentState.nodes().nodeExists(tribe)) continue;
                HashMap<String, String> tribeAttr = new HashMap<String, String>(tribe.getAttributes());
                tribeAttr.put(TRIBE_NAME_SETTING.getKey(), this.tribeName);
                DiscoveryNode discoNode = new DiscoveryNode(tribe.getName(), tribe.getId(), tribe.getEphemeralId(), tribe.getHostName(), tribe.getHostAddress(), tribe.getAddress(), Collections.unmodifiableMap(tribeAttr), tribe.getRoles(), tribe.getVersion());
                clusterStateChanged = true;
                TribeService.this.logger.info("[{}] adding node [{}]", (Object)this.tribeName, (Object)discoNode);
                nodes.remove(tribe.getId());
                nodes.add(discoNode);
            }
            if (clusterStateChanged) {
                newState.nodes(nodes);
            }
            return clusterStateChanged;
        }

        private boolean updateIndicesAndMetaData(ClusterState currentState, List<ClusterChangedEvent> tasks, ClusterState.Builder newState) {
            ClusterChangedEvent latestTask = tasks.get(tasks.size() - 1);
            ClusterState tribeState = latestTask.state();
            boolean clusterStateChanged = false;
            ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
            MetaData.Builder metaData = MetaData.builder((MetaData)currentState.metaData());
            RoutingTable.Builder routingTable = RoutingTable.builder((RoutingTable)currentState.routingTable());
            for (IndexMetaData index : currentState.metaData()) {
                String markedTribeName = (String)TRIBE_NAME_SETTING.get(index.getSettings());
                if (markedTribeName == null || !markedTribeName.equals(this.tribeName)) continue;
                IndexMetaData tribeIndex = tribeState.metaData().index(index.getIndex());
                clusterStateChanged = true;
                if (tribeIndex == null || tribeIndex.getState() == IndexMetaData.State.CLOSE) {
                    TribeService.this.logger.info("[{}] removing index {}", (Object)this.tribeName, (Object)index.getIndex());
                    this.removeIndex(blocks, metaData, routingTable, index);
                    continue;
                }
                routingTable.add(tribeState.routingTable().index(index.getIndex()));
                Settings tribeSettings = Settings.builder().put(tribeIndex.getSettings()).put(TRIBE_NAME_SETTING.getKey(), this.tribeName).build();
                metaData.put(IndexMetaData.builder((IndexMetaData)tribeIndex).settings(tribeSettings));
            }
            for (IndexMetaData tribeIndex : tribeState.metaData()) {
                String preferredTribeName;
                IndexRoutingTable table = tribeState.routingTable().index(tribeIndex.getIndex());
                if (table == null) continue;
                String indexName = tribeIndex.getIndex().getName();
                IndexMetaData indexMetaData = currentState.metaData().index(indexName);
                if (indexMetaData == null) {
                    if (TribeService.this.droppedIndices.contains(indexName)) continue;
                    clusterStateChanged = true;
                    TribeService.this.logger.info("[{}] adding index {}", (Object)this.tribeName, (Object)tribeIndex.getIndex());
                    this.addNewIndex(tribeState, blocks, metaData, routingTable, tribeIndex);
                    continue;
                }
                String existingFromTribe = (String)TRIBE_NAME_SETTING.get(indexMetaData.getSettings());
                if (this.tribeName.equals(existingFromTribe) || TribeService.ON_CONFLICT_ANY.equals(TribeService.this.onConflict)) continue;
                if (TribeService.ON_CONFLICT_DROP.equals(TribeService.this.onConflict)) {
                    clusterStateChanged = true;
                    TribeService.this.logger.info("[{}] dropping index {} due to conflict with [{}]", (Object)this.tribeName, (Object)tribeIndex.getIndex(), (Object)existingFromTribe);
                    this.removeIndex(blocks, metaData, routingTable, tribeIndex);
                    TribeService.this.droppedIndices.add(indexName);
                    continue;
                }
                if (!TribeService.this.onConflict.startsWith(TribeService.ON_CONFLICT_PREFER) || !this.tribeName.equals(preferredTribeName = TribeService.this.onConflict.substring(TribeService.ON_CONFLICT_PREFER.length()))) continue;
                clusterStateChanged = true;
                TribeService.this.logger.info("[{}] adding index {}, preferred over [{}]", (Object)this.tribeName, (Object)tribeIndex.getIndex(), (Object)existingFromTribe);
                this.removeIndex(blocks, metaData, routingTable, tribeIndex);
                this.addNewIndex(tribeState, blocks, metaData, routingTable, tribeIndex);
            }
            if (clusterStateChanged |= this.updateCustoms(currentState, tasks, metaData)) {
                newState.blocks(blocks);
                newState.metaData(metaData);
                newState.routingTable(routingTable.build());
            }
            return clusterStateChanged;
        }

        private boolean updateCustoms(ClusterState currentState, List<ClusterChangedEvent> tasks, MetaData.Builder metaData) {
            boolean clusterStateChanged = false;
            Set<String> changedCustomMetaDataTypeSet = tasks.stream().map(ClusterChangedEvent::changedCustomMetaDataSet).flatMap(Collection::stream).collect(Collectors.toSet());
            List tribeClientNodes = TribeService.this.nodes;
            Map<String, MetaData.Custom> mergedCustomMetaDataMap = TribeService.mergeChangedCustomMetaData(changedCustomMetaDataTypeSet, customMetaDataType -> tribeClientNodes.stream().map(x$0 -> TribeService.getClusterService(x$0)).filter(cs -> cs.lifecycleState() == Lifecycle.State.STARTED).map(ClusterService::state).map(ClusterState::metaData).map(clusterMetaData -> clusterMetaData.custom(customMetaDataType)).filter(custom1 -> custom1 != null && custom1 instanceof MergableCustomMetaData).map(custom2 -> (MergableCustomMetaData)TribeService.this.marshal(custom2)).collect(Collectors.toList()));
            for (String changedCustomMetaDataType : changedCustomMetaDataTypeSet) {
                MetaData.Custom mergedCustomMetaData = mergedCustomMetaDataMap.get(changedCustomMetaDataType);
                if (mergedCustomMetaData == null) {
                    if (!(currentState.metaData().custom(changedCustomMetaDataType) instanceof MergableCustomMetaData)) continue;
                    clusterStateChanged = true;
                    TribeService.this.logger.info("[{}] removing custom meta data type [{}]", (Object)this.tribeName, (Object)changedCustomMetaDataType);
                    metaData.removeCustom(changedCustomMetaDataType);
                    continue;
                }
                clusterStateChanged = true;
                TribeService.this.logger.info("[{}] updating custom meta data type [{}] data [{}]", (Object)this.tribeName, (Object)changedCustomMetaDataType, (Object)mergedCustomMetaData);
                metaData.putCustom(changedCustomMetaDataType, mergedCustomMetaData);
            }
            return clusterStateChanged;
        }

        private void removeIndex(ClusterBlocks.Builder blocks, MetaData.Builder metaData, RoutingTable.Builder routingTable, IndexMetaData index) {
            metaData.remove(index.getIndex().getName());
            routingTable.remove(index.getIndex().getName());
            blocks.removeIndexBlocks(index.getIndex().getName());
        }

        private void addNewIndex(ClusterState tribeState, ClusterBlocks.Builder blocks, MetaData.Builder metaData, RoutingTable.Builder routingTable, IndexMetaData tribeIndex) {
            Settings tribeSettings = Settings.builder().put(tribeIndex.getSettings()).put(TRIBE_NAME_SETTING.getKey(), this.tribeName).build();
            metaData.put(IndexMetaData.builder((IndexMetaData)tribeIndex).settings(tribeSettings));
            routingTable.add(tribeState.routingTable().index(tribeIndex.getIndex()));
            if (Regex.simpleMatch((String[])TribeService.this.blockIndicesMetadata, (String)tribeIndex.getIndex().getName())) {
                blocks.addIndexBlock(tribeIndex.getIndex().getName(), IndexMetaData.INDEX_METADATA_BLOCK);
            }
            if (Regex.simpleMatch((String[])TribeService.this.blockIndicesRead, (String)tribeIndex.getIndex().getName())) {
                blocks.addIndexBlock(tribeIndex.getIndex().getName(), IndexMetaData.INDEX_READ_BLOCK);
            }
            if (Regex.simpleMatch((String[])TribeService.this.blockIndicesWrite, (String)tribeIndex.getIndex().getName())) {
                blocks.addIndexBlock(tribeIndex.getIndex().getName(), IndexMetaData.INDEX_WRITE_BLOCK);
            }
        }
    }

    class TribeClusterStateListener
    implements ClusterStateListener {
        private final String tribeName;
        private final TribeNodeClusterStateTaskExecutor executor;

        TribeClusterStateListener(Node tribeNode) {
            String tribeName;
            this.tribeName = tribeName = (String)TRIBE_NAME_SETTING.get(tribeNode.settings());
            this.executor = new TribeNodeClusterStateTaskExecutor(tribeName);
        }

        public void clusterChanged(ClusterChangedEvent event) {
            TribeService.this.logger.debug("[{}] received cluster event, [{}]", (Object)this.tribeName, (Object)event.source());
            TribeService.this.clusterService.submitStateUpdateTask("cluster event from " + this.tribeName, (Object)event, ClusterStateTaskConfig.build((Priority)Priority.NORMAL), (ClusterStateTaskExecutor)this.executor, (source, e) -> TribeService.this.logger.warn(() -> new ParameterizedMessage("failed to process [{}]", (Object)source), (Throwable)e));
        }
    }
}

