/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.toolchains;

import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.internal.DefaultCppPlatform;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.internal.DefaultSwiftPlatform;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.Architectures;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeLanguage;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

public class DefaultToolChainSelector
implements ToolChainSelector {
    private final ModelRegistry modelRegistry;
    private final ObjectFactory objectFactory;
    private DefaultNativePlatform host;

    @Inject
    public DefaultToolChainSelector(ModelRegistry modelRegistry, ObjectFactory objectFactory) {
        this.modelRegistry = modelRegistry;
        this.objectFactory = objectFactory;
        this.host = DefaultNativePlatform.host();
    }

    @Override
    public <T extends NativePlatform> ToolChainSelector.Result<T> select(Class<T> platformType) {
        NativePlatform targetPlatform;
        DefaultNativePlatform x86platformRequest;
        NativeToolChainInternal x86ToolChain;
        PlatformToolProvider x86ToolProvider;
        DefaultNativePlatform targetMachine = this.host;
        OperatingSystemFamily operatingSystemFamily = (OperatingSystemFamily)this.objectFactory.named(OperatingSystemFamily.class, targetMachine.getOperatingSystem().toFamilyName());
        NativeLanguage sourceLanguage = platformType == SwiftPlatform.class ? NativeLanguage.SWIFT : NativeLanguage.CPP;
        NativeToolChainRegistryInternal registry = (NativeToolChainRegistryInternal)this.modelRegistry.realize("toolChains", NativeToolChainRegistryInternal.class);
        NativeToolChainInternal toolChain = registry.getForPlatform(sourceLanguage, (NativePlatformInternal)targetMachine);
        PlatformToolProvider toolProvider = toolChain.select(sourceLanguage, (NativePlatformInternal)targetMachine);
        if (!toolProvider.isAvailable() && operatingSystemFamily.isWindows() && targetMachine.getArchitecture().isAmd64() && (x86ToolProvider = (x86ToolChain = registry.getForPlatform(sourceLanguage, (NativePlatformInternal)(x86platformRequest = targetMachine.withArchitecture(Architectures.of((Architectures.KnownArchitecture)Architectures.X86))))).select(sourceLanguage, (NativePlatformInternal)x86platformRequest)).isAvailable()) {
            targetMachine = x86platformRequest;
            toolChain = x86ToolChain;
            toolProvider = x86ToolProvider;
        }
        if (CppPlatform.class.isAssignableFrom(platformType)) {
            targetPlatform = (NativePlatform)platformType.cast(new DefaultCppPlatform("host", operatingSystemFamily, (NativePlatformInternal)targetMachine));
        } else if (SwiftPlatform.class.isAssignableFrom(platformType)) {
            targetPlatform = (NativePlatform)platformType.cast(new DefaultSwiftPlatform("host", operatingSystemFamily, (NativePlatformInternal)targetMachine));
        } else {
            throw new IllegalArgumentException("Unknown type of platform " + platformType);
        }
        return new DefaultResult(this, toolChain, toolProvider, targetPlatform);
    }

    static class DefaultResult<T extends NativePlatform>
    implements ToolChainSelector.Result<T> {
        private final NativeToolChainInternal toolChain;
        private final PlatformToolProvider platformToolProvider;
        private final T targetPlatform;
        final /* synthetic */ DefaultToolChainSelector this$0;

        DefaultResult(NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider, T targetPlatform) {
            this.this$0 = this$0;
            this.toolChain = toolChain;
            this.platformToolProvider = platformToolProvider;
            this.targetPlatform = targetPlatform;
        }

        @Override
        public NativeToolChainInternal getToolChain() {
            return this.toolChain;
        }

        @Override
        public T getTargetPlatform() {
            return this.targetPlatform;
        }

        @Override
        public PlatformToolProvider getPlatformToolProvider() {
            return this.platformToolProvider;
        }
    }
}

