/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class SymmetryOperation
extends M4 {
    String xyzOriginal;
    String xyz;
    private boolean doNormalize = true;
    boolean isFinalized;
    private int opId;
    private V3 centering;
    private static P3 atomTest;
    private String[] myLabels;
    int modDim;
    float[] linearRotTrans;
    Matrix rsvs;
    boolean isBio;
    private Matrix sigma;
    int index;
    String subsystemCode;
    int timeReversal;
    private static final String[] twelfths;
    private static final String[] fortyeigths;
    static final String[] labelsXYZ;
    static final String[] labelsXn;
    static final String[] labelsXnSub;
    private boolean unCentered;
    boolean isCenteringOp;
    private float magOp = Float.MAX_VALUE;
    private Hashtable<String, Object> info;

    static {
        twelfths = new String[]{"0", "1/12", "1/6", "1/4", "1/3", "5/12", "1/2", "7/12", "2/3", "3/4", "5/6", "11/12"};
        fortyeigths = new String[]{"0", "1/48", "1/24", "1/16", "1/12", "5/48", "1/8", "7/48", "1/6", "3/16", "5/24", "11/48", "1/4", "13/48", "7/24", "5/16", "1/3", "17/48", "3/8", "19/48", "5/12", "7/16", "11/24", "23/48", "1/2", "25/48", "13/24", "9/16", "7/12", "29/48", "15/24", "31/48", "2/3", "11/12", "17/16", "35/48", "3/4", "37/48", "19/24", "13/16", "5/6", "41/48", "7/8", "43/48", "11/12", "15/16", "23/24", "47/48"};
        labelsXYZ = new String[]{"x", "y", "z"};
        labelsXn = new String[]{"x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13"};
        labelsXnSub = new String[]{"x", "y", "z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j"};
    }

    void setSigma(String string, Matrix matrix) {
        this.subsystemCode = string;
        this.sigma = matrix;
    }

    SymmetryOperation(SymmetryOperation symmetryOperation, P3[] p3Array, int n, int n2, boolean bl) {
        this.doNormalize = bl;
        if (symmetryOperation == null) {
            this.opId = n2;
            return;
        }
        this.xyzOriginal = symmetryOperation.xyzOriginal;
        this.xyz = symmetryOperation.xyz;
        this.opId = symmetryOperation.opId;
        this.modDim = symmetryOperation.modDim;
        this.myLabels = symmetryOperation.myLabels;
        this.index = symmetryOperation.index;
        this.linearRotTrans = symmetryOperation.linearRotTrans;
        this.sigma = symmetryOperation.sigma;
        this.subsystemCode = symmetryOperation.subsystemCode;
        this.timeReversal = symmetryOperation.timeReversal;
        this.setMatrix(false);
        if (!symmetryOperation.isFinalized) {
            this.doFinalize();
        }
        if (bl && this.sigma == null) {
            SymmetryOperation.setOffset(this, p3Array, n, n2);
        }
    }

    private void setGamma(boolean bl) {
        int n;
        int n2 = 3 + this.modDim;
        this.rsvs = new Matrix(null, n2 + 1, n2 + 1);
        double[][] dArray = this.rsvs.getArray();
        double[] dArray2 = new double[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n = 0;
            while (n < n2) {
                dArray[n4][n] = this.linearRotTrans[n3++];
                ++n;
            }
            dArray2[n4] = (float)(bl ? -1 : 1) * this.linearRotTrans[n3++];
            ++n4;
        }
        dArray[n2][n2] = 1.0;
        if (bl) {
            this.rsvs = this.rsvs.inverse();
        }
        n4 = 0;
        while (n4 < n2) {
            dArray[n4][n2] = dArray2[n4];
            ++n4;
        }
        dArray = this.rsvs.getSubmatrix(0, 0, 3, 3).getArray();
        n4 = 0;
        while (n4 < 3) {
            n = 0;
            while (n < 4) {
                this.setElement(n4, n, (float)(n < 3 ? dArray[n4][n] : dArray2[n4]));
                ++n;
            }
            ++n4;
        }
        this.setElement(3, 3, 1.0f);
    }

    void doFinalize() {
        SymmetryOperation.div12(this);
        if (this.modDim > 0) {
            double[][] dArray = this.rsvs.getArray();
            int n = dArray.length - 1;
            while (--n >= 0) {
                double[] dArray2 = dArray[n];
                int n2 = 3 + this.modDim;
                dArray2[n2] = dArray2[n2] / 12.0;
            }
        }
        this.isFinalized = true;
    }

    private static M4 div12(M4 m4) {
        m4.m03 /= 12.0f;
        m4.m13 /= 12.0f;
        m4.m23 /= 12.0f;
        return m4;
    }

    String getXyz(boolean bl) {
        return bl && this.modDim == 0 || this.xyzOriginal == null ? this.xyz : this.xyzOriginal;
    }

    static void newPoint(M4 m4, P3 p3, P3 p32, int n, int n2, int n3) {
        m4.rotTrans2(p3, p32);
        p32.add3(n, n2, n3);
    }

    String dumpInfo() {
        return "\n" + this.xyz + "\ninternal matrix representation:\n" + this.toString();
    }

    static final String dumpSeitz(M4 m4, boolean bl) {
        SB sB = new SB();
        float[] fArray = new float[4];
        int n = 0;
        while (n < 3) {
            m4.getRow(n, fArray);
            sB.append("[\t");
            int n2 = 0;
            while (n2 < 3) {
                sB.appendI((int)fArray[n2]).append("\t");
                ++n2;
            }
            float f = fArray[3];
            if (f != (float)((int)f)) {
                f *= 12.0f;
            }
            sB.append(SymmetryOperation.twelfthsOf(bl ? ((int)f + 12) % 12 : (int)f)).append("\t]\n");
            ++n;
        }
        return sB.toString();
    }

    boolean setMatrixFromXYZ(String string, int n, boolean bl) {
        if (string == null) {
            return false;
        }
        this.xyzOriginal = string;
        string = string.toLowerCase();
        this.setModDim(n);
        boolean bl2 = string.startsWith("!");
        if (bl2) {
            string = string.substring(1);
        }
        if (string.indexOf("xyz matrix:") == 0) {
            this.xyz = string;
            Parser.parseStringInfestedFloatArray(string, null, this.linearRotTrans);
            return this.setFromMatrix(null, bl2);
        }
        if (string.indexOf("[[") == 0) {
            string = string.replace('[', ' ').replace(']', ' ').replace(',', ' ');
            Parser.parseStringInfestedFloatArray(string, null, this.linearRotTrans);
            int n2 = this.linearRotTrans.length;
            while (--n2 >= 0) {
                if (!Float.isNaN(this.linearRotTrans[n2])) continue;
                return false;
            }
            this.setMatrix(bl2);
            this.isFinalized = true;
            this.isBio = string.indexOf("bio") >= 0;
            this.xyz = this.isBio ? this.toString() : SymmetryOperation.getXYZFromMatrix(this, false, false, false);
            return true;
        }
        if (n == 0 && string.indexOf("x4") >= 0) {
            int n3 = 14;
            while (--n3 >= 4) {
                if (string.indexOf("x" + n3) < 0) continue;
                this.setModDim(n3 - 3);
                break;
            }
        }
        String string2 = null;
        if (string.endsWith("m")) {
            this.timeReversal = string.indexOf("-m") >= 0 ? -1 : 1;
            bl = true;
        } else if (string.indexOf("mz)") >= 0) {
            int n4 = string.indexOf("(");
            string2 = string.substring(n4 + 1, string.length() - 1);
            string = string.substring(0, n4);
            bl = false;
        }
        String string3 = SymmetryOperation.getMatrixFromString(this, string, this.linearRotTrans, bl);
        if (string3 == null) {
            return false;
        }
        if (string2 != null) {
            boolean bl3 = M4.newA16(this.linearRotTrans).determinant3() == 1.0f;
            this.timeReversal = string.indexOf("-x") < 0 == string2.indexOf("-mx") < 0 == bl3 ? 1 : -1;
        }
        this.setMatrix(bl2);
        String string4 = this.xyz = bl2 ? SymmetryOperation.getXYZFromMatrix(this, true, false, false) : string3;
        if (this.timeReversal != 0) {
            this.xyz = String.valueOf(this.xyz) + (this.timeReversal == 1 ? ",m" : ",-m");
        }
        if (Logger.debugging) {
            Logger.debug("" + this);
        }
        return true;
    }

    private void setModDim(int n) {
        int n2 = (n + 4) * (n + 4);
        this.modDim = n;
        if (n > 0) {
            this.myLabels = labelsXn;
        }
        this.linearRotTrans = new float[n2];
    }

    private void setMatrix(boolean bl) {
        if (this.linearRotTrans.length > 16) {
            this.setGamma(bl);
        } else {
            this.setA(this.linearRotTrans);
            if (bl) {
                P3 p3 = P3.new3(this.m03, this.m13, this.m23);
                this.invert();
                this.rotate(p3);
                p3.scale(-1.0f);
                this.setTranslation(p3);
            }
        }
    }

    boolean setFromMatrix(float[] fArray, boolean bl) {
        float f = 0.0f;
        int n = 0;
        this.myLabels = this.modDim == 0 ? labelsXYZ : labelsXn;
        int n2 = 0;
        int n3 = 3 + this.modDim;
        int n4 = 0;
        while (n2 < n3) {
            boolean bl2;
            if (Float.isNaN(this.linearRotTrans[n4])) {
                return false;
            }
            f = this.linearRotTrans[n4];
            if (Math.abs(f) < 1.0E-5f) {
                f = 0.0f;
            }
            boolean bl3 = bl2 = (n4 + 1) % (n3 + 1) == 0;
            if (bl2) {
                if (fArray != null) {
                    f /= 12.0f;
                    if (n < fArray.length) {
                        f += fArray[n++];
                    }
                }
                f = SymmetryOperation.normalizeTwelfths((float)(f < 0.0f ? -1 : 1) * Math.abs(f * 12.0f) / 12.0f, this.doNormalize);
                ++n2;
            }
            this.linearRotTrans[n4] = f;
            ++n4;
        }
        this.linearRotTrans[this.linearRotTrans.length - 1] = 1.0f;
        this.setMatrix(bl);
        this.isFinalized = fArray == null;
        this.xyz = SymmetryOperation.getXYZFromMatrix(this, true, false, false);
        return true;
    }

    public static M4 getMatrixFromXYZ(String string) {
        float[] fArray = new float[16];
        return (string = SymmetryOperation.getMatrixFromString(null, string, fArray, false)) == null ? null : SymmetryOperation.div12(M4.newA16(fArray));
    }

    /*
     * Unable to fully structure code
     */
    static String getMatrixFromString(SymmetryOperation var0, String var1_1, float[] var2_2, boolean var3_3) {
        var4_4 = false;
        var5_5 = false;
        var6_6 = false;
        var7_7 = var0 == null ? 0 : var0.modDim;
        var8_8 = 4 + var7_7;
        var9_9 = var0 != null && var0.doNormalize != false;
        var10_10 = var7_7 > 0 ? 3 : 0;
        var2_2[var2_2.length - 1] = 1.0f;
        var11_11 = var1_1.indexOf(59) + 1;
        if (var11_11 != 0) {
            var3_3 = true;
            if (var11_11 == var1_1.length()) {
                var1_1 = String.valueOf(var1_1) + "0,0,0";
            }
        }
        var12_12 = -1;
        v0 = var13_13 = var0 == null || var7_7 == 0 ? null : var0.myLabels;
        if (var13_13 == null) {
            var13_13 = SymmetryOperation.labelsXYZ;
        }
        var1_1 = String.valueOf(var1_1.toLowerCase()) + ",";
        var1_1 = var1_1.replace('(', ',');
        if (var7_7 > 0) {
            var1_1 = SymmetryOperation.replaceXn(var1_1, var7_7 + 3);
        }
        var14_14 = 0;
        var15_15 = 0;
        var16_16 = 0;
        var18_17 = 0.0f;
        var19_18 = 0;
        var20_19 = 1.0f;
        var21_20 = "";
        var22_21 = "";
        var23_22 = 0;
        while (var23_22 < var1_1.length()) {
            block22: {
                var17_23 = var1_1.charAt(var23_22);
                switch (var17_23) {
                    case ';': {
                        break;
                    }
                    case ' ': 
                    case '!': 
                    case '\'': 
                    case '{': 
                    case '}': {
                        break block22;
                    }
                    case '-': {
                        var6_6 = true;
                        break block22;
                    }
                    case '+': {
                        var6_6 = false;
                        break block22;
                    }
                    case '/': {
                        var19_18 = 0;
                        var4_4 = true;
                        break block22;
                    }
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        var15_15 = var16_16 * var8_8;
                        var24_24 = var17_23 >= 'x' ? var17_23 - 120 : var17_23 - 97 + var10_10;
                        var14_14 = var15_15 + var24_24;
                        v1 = var25_25 = var6_6 != false ? -1 : 1;
                        if (var3_3 && var18_17 != 0.0f) {
                            var2_2[var14_14] = var18_17;
                            var25_25 = (int)var18_17;
                            var18_17 = 0.0f;
                        } else {
                            var2_2[var14_14] = var25_25;
                        }
                        var21_20 = String.valueOf(var21_20) + SymmetryOperation.plusMinus(var21_20, var25_25, var13_13[var24_24]);
                        break;
                    }
                    case ',': {
                        if (var11_11 == 0) ** GOTO lbl72
                        if (var11_11 <= 0) ** GOTO lbl70
                        var12_12 = var23_22;
                        var23_22 = var11_11 - 1;
                        var11_11 = -var23_22;
                        var18_17 = 0.0f;
                        var19_18 = 0;
                        break block22;
lbl70:
                        // 1 sources

                        var11_11 = var23_22 + 1;
                        var23_22 = var12_12;
lbl72:
                        // 2 sources

                        var2_2[var15_15 + var8_8 - 1] = var18_17 = SymmetryOperation.normalizeTwelfths(var18_17, var9_9);
                        var21_20 = String.valueOf(var21_20) + SymmetryOperation.xyzFraction12(var18_17, false, true);
                        var22_21 = String.valueOf(var22_21) + (var22_21 == "" ? "" : ",") + var21_20;
                        if (var16_16 == var8_8 - 2) {
                            return var22_21;
                        }
                        var18_17 = 0.0f;
                        var21_20 = "";
                        if (var16_16++ <= 2 || var7_7 != 0) break;
                        Logger.warn("Symmetry Operation? " + var1_1);
                        return null;
                    }
                    case '.': {
                        var5_5 = true;
                        var20_19 = 1.0f;
                        break block22;
                    }
                    case '0': {
                        if (!var5_5 && (var4_4 || !var3_3)) break block22;
                    }
                    default: {
                        var26_26 = var17_23 - 48;
                        if (var26_26 < 0 || var26_26 > 9) ** GOTO lbl112
                        if (!var5_5) ** GOTO lbl97
                        var20_19 /= 10.0f;
                        if (var18_17 < 0.0f) {
                            var6_6 = true;
                        }
                        var18_17 += var20_19 * (float)var26_26 * (float)(var6_6 != false ? -1 : 1);
                        break block22;
lbl97:
                        // 1 sources

                        if (!var4_4) ** GOTO lbl109
                        if (var26_26 != 1) ** GOTO lbl101
                        var19_18 = 1;
                        break block22;
lbl101:
                        // 1 sources

                        if (var19_18 == 1) {
                            var26_26 += var19_18 * 10;
                        }
                        if (var18_17 == 0.0f) {
                            v2 = var14_14;
                            var2_2[v2] = var2_2[v2] / (float)var26_26;
                            break;
                        }
                        var18_17 /= (float)var26_26;
                        break;
lbl109:
                        // 1 sources

                        var18_17 = var18_17 * 10.0f + (float)((var6_6 != false ? -1 : 1) * var26_26);
                        var6_6 = false;
                        break;
lbl112:
                        // 1 sources

                        Logger.warn("symmetry character?" + var17_23);
                    }
                }
                var6_6 = false;
                var4_4 = false;
                var5_5 = false;
            }
            ++var23_22;
        }
        return null;
    }

    static String replaceXn(String string, int n) {
        int n2 = n;
        while (--n2 >= 0) {
            string = PT.rep(string, labelsXn[n2], labelsXnSub[n2]);
        }
        return string;
    }

    private static final String xyzFraction12(float f, boolean bl, boolean bl2) {
        float f2 = f;
        if (bl) {
            while (f2 < 0.0f) {
                f2 += 12.0f;
            }
        } else if (bl2) {
            while (f2 > 6.0f) {
                f2 -= 12.0f;
            }
            while (f2 < -6.0f) {
                f2 += 12.0f;
            }
        }
        String string = SymmetryOperation.twelfthsOf(f2);
        return string.charAt(0) == '0' ? "" : (f2 > 0.0f ? "+" + string : string);
    }

    private static final String xyzFraction48ths(float f, boolean bl, boolean bl2) {
        float f2 = f;
        if (bl) {
            while (f2 < 0.0f) {
                f2 += 48.0f;
            }
        } else if (bl2) {
            while (f2 > 24.0f) {
                f2 -= 48.0f;
            }
            while (f2 < -24.0f) {
                f2 += 48.0f;
            }
        }
        String string = SymmetryOperation.fortyEighthsOf(f2);
        return string.charAt(0) == '0' ? "" : (f2 > 0.0f ? "+" + string : string);
    }

    static final String twelfthsOf(float f) {
        String string = "";
        if (f < 0.0f) {
            f = -f;
            string = "-";
        }
        int n = 12;
        int n2 = Math.round(f);
        if (Math.abs((float)n2 - f) > 0.01f) {
            float f2 = f / 12.0f;
            int n3 = 20;
            n = 3;
            while (n < n3) {
                float f3 = f2 * (float)n;
                n2 = Math.round(f3);
                if (Math.abs((float)n2 - f3) < 0.01f) break;
                ++n;
            }
            if (n == n3) {
                return String.valueOf(string) + f2;
            }
        } else {
            if (n2 == 12) {
                return String.valueOf(string) + "1";
            }
            if (n2 < 12) {
                return String.valueOf(string) + twelfths[n2 % 12];
            }
            switch (n2 % 12) {
                case 0: {
                    return "" + n2 / 12;
                }
                case 2: 
                case 10: {
                    n = 6;
                    break;
                }
                case 3: 
                case 9: {
                    n = 4;
                    break;
                }
                case 4: 
                case 8: {
                    n = 3;
                    break;
                }
                case 6: {
                    n = 2;
                    break;
                }
            }
            n2 = n2 * n / 12;
        }
        return String.valueOf(string) + n2 + "/" + n;
    }

    static final String fortyEighthsOf(float f) {
        String string = "";
        if (f < 0.0f) {
            f = -f;
            string = "-";
        }
        int n = 12;
        int n2 = Math.round(f);
        if (Math.abs((float)n2 - f) > 0.01f) {
            float f2 = f / 48.0f;
            int n3 = 20;
            n = 5;
            while (n < n3) {
                float f3 = f2 * (float)n;
                n2 = Math.round(f3);
                if (Math.abs((float)n2 - f3) < 0.01f) break;
                ++n;
            }
            if (n == n3) {
                return String.valueOf(string) + f2;
            }
        } else {
            if (n2 == 48) {
                return String.valueOf(string) + "1";
            }
            if (n2 < 48) {
                return String.valueOf(string) + twelfths[n2 % 48];
            }
            switch (n2 % 48) {
                case 0: {
                    return "" + n2 / 48;
                }
                case 2: 
                case 10: {
                    n = 6;
                    break;
                }
                case 3: 
                case 9: {
                    n = 4;
                    break;
                }
                case 4: 
                case 8: {
                    n = 3;
                    break;
                }
                case 6: {
                    n = 2;
                    break;
                }
            }
            n2 = n2 * n / 12;
        }
        return String.valueOf(string) + n2 + "/" + n;
    }

    private static String plusMinus(String string, float f, String string2) {
        return f == 0.0f ? "" : String.valueOf(f < 0.0f ? "-" : (string.length() == 0 ? "" : "+")) + (f == 1.0f || f == -1.0f ? "" : "" + (int)Math.abs(f)) + string2;
    }

    private static float normalizeTwelfths(float f, boolean bl) {
        f *= 12.0f;
        if (bl) {
            while (f > 6.0f) {
                f -= 12.0f;
            }
            while (f <= -6.0f) {
                f += 12.0f;
            }
        }
        return f;
    }

    private static float normalize48ths(float f, boolean bl) {
        f *= 48.0f;
        if (bl) {
            while (f > 24.0f) {
                f -= 48.0f;
            }
            while (f <= -24.0f) {
                f += 48.0f;
            }
        }
        return f;
    }

    public static final String getXYZFromMatrix(M4 m4, boolean bl, boolean bl2, boolean bl3) {
        SymmetryOperation symmetryOperation;
        String string = "";
        SymmetryOperation symmetryOperation2 = symmetryOperation = m4 instanceof SymmetryOperation ? (SymmetryOperation)m4 : null;
        if (symmetryOperation != null && symmetryOperation.modDim > 0) {
            return SymmetryOperation.getXYZFromRsVs(symmetryOperation.rsvs.getRotation(), symmetryOperation.rsvs.getTranslation(), bl);
        }
        float[] fArray = new float[4];
        int n = 0;
        while (n < 3) {
            int n2 = n < 3 ? 0 : 3;
            m4.getRow(n, fArray);
            String string2 = "";
            int n3 = 0;
            while (n3 < 3) {
                if (fArray[n3] != 0.0f) {
                    string2 = String.valueOf(string2) + SymmetryOperation.plusMinus(string2, fArray[n3], labelsXYZ[n3 + n2]);
                }
                ++n3;
            }
            string2 = String.valueOf(string2) + SymmetryOperation.xyzFraction12(bl ? fArray[3] : fArray[3] * 12.0f, bl2, bl3);
            string = String.valueOf(string) + "," + string2;
            ++n;
        }
        return string.substring(1);
    }

    public static void setOffset(M4 m4, P3[] p3Array, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (atomTest == null) {
            atomTest = new P3();
        }
        int n3 = n;
        int n4 = n3 + n2;
        while (n3 < n4) {
            SymmetryOperation.newPoint(m4, p3Array[n3], atomTest, 0, 0, 0);
            f += SymmetryOperation.atomTest.x;
            f2 += SymmetryOperation.atomTest.y;
            f3 += SymmetryOperation.atomTest.z;
            ++n3;
        }
        f /= (float)n2;
        f2 /= (float)n2;
        f3 /= (float)n2;
        while ((double)f < -0.001 || (double)f >= 1.001) {
            m4.m03 = m4.m03 + (float)(f < 0.0f ? 1 : -1);
            f += (float)(f < 0.0f ? 1 : -1);
        }
        while ((double)f2 < -0.001 || (double)f2 >= 1.001) {
            m4.m13 = m4.m13 + (float)(f2 < 0.0f ? 1 : -1);
            f2 += (float)(f2 < 0.0f ? 1 : -1);
        }
        while ((double)f3 < -0.001 || (double)f3 >= 1.001) {
            m4.m23 = m4.m23 + (float)(f3 < 0.0f ? 1 : -1);
            f3 += (float)(f3 < 0.0f ? 1 : -1);
        }
    }

    V3[] rotateAxes(V3[] v3Array, UnitCell unitCell, P3 p3, M3 m3) {
        V3[] v3Array2 = new V3[3];
        this.getRotationScale(m3);
        int n = v3Array.length;
        while (--n >= 0) {
            p3.setT(v3Array[n]);
            unitCell.toFractional(p3, true);
            m3.rotate(p3);
            unitCell.toCartesian(p3, true);
            v3Array2[n] = V3.newV(p3);
        }
        return v3Array2;
    }

    static String fcoord(T3 t3) {
        return String.valueOf(SymmetryOperation.fc(t3.x)) + " " + SymmetryOperation.fc(t3.y) + " " + SymmetryOperation.fc(t3.z);
    }

    private static String fc(float f) {
        float f2 = Math.abs(f);
        String string = f < 0.0f ? "-" : "";
        int n = (int)SymmetryOperation.approxF(f2 * 24.0f);
        if ((float)n / 24.0f == (float)((int)((float)n / 24.0f))) {
            return String.valueOf(string) + n / 24;
        }
        if (n % 8 != 0) {
            return String.valueOf(string) + SymmetryOperation.twelfthsOf(n >> 1);
        }
        return n == 0 ? "0" : (n == 24 ? String.valueOf(string) + "1" : String.valueOf(string) + n / 8 + "/3");
    }

    static float approxF(float f) {
        return PT.approx(f, 100.0f);
    }

    static String getXYZFromRsVs(Matrix matrix, Matrix matrix2, boolean bl) {
        double[][] dArray = matrix.getArray();
        double[][] dArray2 = matrix2.getArray();
        int n = dArray.length;
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + ",";
            int n3 = 0;
            while (n3 < n) {
                double d = dArray[n2][n3];
                if (d != 0.0) {
                    string = String.valueOf(string) + (d < 0.0 ? "-" : (string.endsWith(",") ? "" : "+")) + (Math.abs(d) == 1.0 ? "" : "" + (int)Math.abs(d)) + "x" + (n3 + 1);
                }
                ++n3;
            }
            string = String.valueOf(string) + SymmetryOperation.xyzFraction12((int)(dArray2[n2][0] * (double)(bl ? 1 : 12)), false, true);
            ++n2;
        }
        return PT.rep(string.substring(1), ",+", ",");
    }

    @Override
    public String toString() {
        return this.rsvs == null ? super.toString() : String.valueOf(super.toString()) + " " + this.rsvs.toString();
    }

    float getMagneticOp() {
        return this.magOp == Float.MAX_VALUE ? (this.magOp = this.determinant3() * (float)this.timeReversal) : this.magOp;
    }

    void setTimeReversal(int n) {
        this.timeReversal = n;
        if (this.xyz.indexOf("m") >= 0) {
            this.xyz = this.xyz.substring(0, this.xyz.indexOf("m"));
        }
        if (n != 0) {
            this.xyz = String.valueOf(this.xyz) + (n == 1 ? ",m" : ",-m");
        }
    }

    V3 getCentering() {
        if (!this.isFinalized) {
            this.doFinalize();
        }
        if (this.centering == null && !this.unCentered) {
            if (this.modDim == 0 && this.m00 == 1.0f && this.m11 == 1.0f && this.m22 == 1.0f && this.m01 == 0.0f && this.m02 == 0.0f && this.m10 == 0.0f && this.m12 == 0.0f && this.m20 == 0.0f && this.m21 == 0.0f && (this.m03 != 0.0f || this.m13 != 0.0f || this.m23 != 0.0f)) {
                this.isCenteringOp = true;
                this.centering = V3.new3(this.m03, this.m13, this.m23);
            } else {
                this.unCentered = true;
                this.centering = null;
            }
        }
        return this.centering;
    }

    String fixMagneticXYZ(M4 m4, String string, boolean bl) {
        if (this.timeReversal == 0) {
            return string;
        }
        int n = string.indexOf("m");
        String string2 = string = (n -= (3 - this.timeReversal) / 2) < 0 ? string : string.substring(0, n);
        if (!bl) {
            return String.valueOf(string) + (this.timeReversal > 0 ? " +1" : " -1");
        }
        M4 m42 = M4.newM4(m4);
        m42.m23 = 0.0f;
        m42.m13 = 0.0f;
        m42.m03 = 0.0f;
        if (this.getMagneticOp() < 0.0f) {
            m42.scale(-1.0f);
        }
        string = String.valueOf(string) + "(" + PT.rep(PT.rep(PT.rep(SymmetryOperation.getXYZFromMatrix(m42, false, false, false), "x", "mx"), "y", "my"), "z", "mz") + ")";
        return string;
    }

    public Map<String, Object> getInfo() {
        if (this.info == null) {
            this.info = new Hashtable();
            this.info.put("xyz", this.xyz);
            if (this.centering != null) {
                this.info.put("centering", this.centering);
            }
            this.info.put("index", this.index);
            this.info.put("isCenteringOp", this.isCenteringOp);
            if (this.linearRotTrans != null) {
                this.info.put("linearRotTrans", this.linearRotTrans);
            }
            this.info.put("modulationDimension", this.modDim);
            this.info.put("matrix", M4.newM4(this));
            if (this.magOp != Float.MAX_VALUE) {
                this.info.put("magOp", Float.valueOf(this.magOp));
            }
            this.info.put("id", this.opId);
            this.info.put("timeReversal", this.timeReversal);
            if (this.xyzOriginal != null) {
                this.info.put("xyzOriginal", this.xyzOriginal);
            }
        }
        return this.info;
    }
}

