/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Nullable;

public class PluginException
extends RuntimeException {
    private final PluginId myPluginId;

    public PluginException(String message, Throwable cause, @Nullable PluginId pluginId) {
        super(message, cause);
        this.myPluginId = pluginId;
    }

    public PluginException(Throwable e, @Nullable PluginId pluginId) {
        super(e.getMessage(), e);
        this.myPluginId = pluginId;
    }

    public PluginException(String message, @Nullable PluginId pluginId) {
        super(message);
        this.myPluginId = pluginId;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        return this.myPluginId != null ? StringUtil.notNullize(message) + " [Plugin: " + this.myPluginId.toString() + "]" : message;
    }
}

