/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.image.formats;

import java.io.IOException;
import org.sunflow.PluginRegistry;
import org.sunflow.image.Bitmap;
import org.sunflow.image.BitmapWriter;
import org.sunflow.image.Color;
import org.sunflow.system.FileUtils;
import org.sunflow.system.UI;

public class GenericBitmap
extends Bitmap {
    private int w;
    private int h;
    private Color[] color;
    private float[] alpha;

    public GenericBitmap(int n, int n2) {
        this.w = n;
        this.h = n2;
        this.color = new Color[n * n2];
        this.alpha = new float[n * n2];
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public Color readColor(int n, int n2) {
        return this.color[n + n2 * this.w];
    }

    public float readAlpha(int n, int n2) {
        return this.alpha[n + n2 * this.w];
    }

    public void writePixel(int n, int n2, Color color, float f) {
        this.color[n + n2 * this.w] = color;
        this.alpha[n + n2 * this.w] = f;
    }

    public void save(String string) {
        String string2 = FileUtils.getExtension(string);
        BitmapWriter bitmapWriter = PluginRegistry.bitmapWriterPlugins.createObject(string2);
        if (bitmapWriter == null) {
            UI.printError(UI.Module.IMG, "Unable to save file \"%s\" - unknown file format: %s", string, string2);
            return;
        }
        try {
            bitmapWriter.openFile(string);
            bitmapWriter.writeHeader(this.w, this.h, Math.max(this.w, this.h));
            bitmapWriter.writeTile(0, 0, this.w, this.h, this.color, this.alpha);
            bitmapWriter.closeFile();
        }
        catch (IOException iOException) {
            UI.printError(UI.Module.IMG, "Unable to save file \"%s\" - %s", string, iOException.getLocalizedMessage());
        }
    }
}

