/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.AdaptableAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainFrame;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.preferences.ToolbarPreferences;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetReader;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.items.Key;
import org.openstreetmap.josm.gui.tagging.presets.items.Link;
import org.openstreetmap.josm.gui.tagging.presets.items.Optional;
import org.openstreetmap.josm.gui.tagging.presets.items.PresetLink;
import org.openstreetmap.josm.gui.tagging.presets.items.Roles;
import org.openstreetmap.josm.gui.tagging.presets.items.Space;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.template_engine.ParseError;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;
import org.openstreetmap.josm.tools.template_engine.TemplateParser;
import org.xml.sax.SAXException;

public class TaggingPreset
extends AbstractAction
implements MainLayerManager.ActiveLayerChangeListener,
AdaptableAction,
Predicate<IPrimitive> {
    public static final int DIALOG_ANSWER_APPLY = 1;
    public static final int DIALOG_ANSWER_NEW_RELATION = 2;
    public static final int DIALOG_ANSWER_CANCEL = 3;
    public static final String OPTIONAL_TOOLTIP_TEXT = "Optional tooltip text";
    public static final String PRESET_ICON_ERROR_MSG_PREFIX = "Could not get presets icon ";
    public TaggingPresetMenu group;
    public String name;
    public String iconName;
    public String name_context;
    public String locale_name;
    public boolean preset_name_label;
    public transient Set<TaggingPresetType> types;
    public final transient List<TaggingPresetItem> data = new LinkedList<TaggingPresetItem>();
    public transient Roles roles;
    public transient TemplateEntry nameTemplate;
    public transient SearchCompiler.Match nameTemplateFilter;
    private boolean originalSelectionEmpty;

    public TaggingPreset() {
        MainApplication.getLayerManager().addActiveLayerChangeListener(this);
        this.updateEnabledState();
    }

    public void setDisplayName() {
        this.putValue("Name", this.getName());
        this.putValue("toolbar", "tagging_" + this.getRawName());
        this.putValue(OPTIONAL_TOOLTIP_TEXT, this.group != null ? I18n.tr("Use preset ''{0}'' of group ''{1}''", this.getLocaleName(), this.group.getName()) : I18n.tr("Use preset ''{0}''", this.getLocaleName()));
    }

    public String getLocaleName() {
        if (this.locale_name == null) {
            this.locale_name = this.name_context != null ? I18n.trc(this.name_context, TaggingPresetItem.fixPresetString(this.name)) : I18n.tr(TaggingPresetItem.fixPresetString(this.name), new Object[0]);
        }
        return this.locale_name;
    }

    public String getName() {
        return this.group != null ? this.group.getName() + '/' + this.getLocaleName() : this.getLocaleName();
    }

    public String getRawName() {
        return this.group != null ? this.group.getRawName() + '/' + this.name : this.name;
    }

    public final ImageIcon getIcon() {
        return this.getIcon("SmallIcon");
    }

    public final ImageIcon getIcon(String key) {
        Object icon = this.getValue(key);
        if (icon instanceof ImageIcon) {
            return (ImageIcon)icon;
        }
        return null;
    }

    public void setIcon(String iconName) {
        this.iconName = iconName;
        if (iconName == null || !TaggingPresetReader.isLoadIcons()) {
            return;
        }
        File arch = TaggingPresetReader.getZipIcons();
        List<String> s = Config.getPref().getList("taggingpreset.icon.sources", null);
        ImageProvider imgProv = new ImageProvider(iconName);
        imgProv.setDirs(s);
        imgProv.setId("presets");
        imgProv.setArchive(arch);
        imgProv.setOptional(true);
        imgProv.getResourceAsync(result -> {
            if (result != null) {
                GuiHelper.runInEDT(() -> result.attachImageIcon(this));
            } else {
                Logging.warn(this.toString() + ": " + PRESET_ICON_ERROR_MSG_PREFIX + iconName);
            }
        });
    }

    public void setType(String types) throws SAXException {
        this.types = TaggingPresetItem.getType(types);
    }

    public void setName_template(String pattern) throws SAXException {
        try {
            this.nameTemplate = new TemplateParser(pattern).parse();
        }
        catch (ParseError e) {
            Logging.error("Error while parsing " + pattern + ": " + e.getMessage());
            throw new SAXException(e);
        }
    }

    public void setName_template_filter(String filter) throws SAXException {
        try {
            this.nameTemplateFilter = SearchCompiler.compile(filter);
        }
        catch (SearchParseError e) {
            Logging.error("Error while parsing" + filter + ": " + e.getMessage());
            throw new SAXException(e);
        }
    }

    private List<Tag> getDirectlyAppliedTags() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (TaggingPresetItem item : this.data) {
            if (!(item instanceof Key)) continue;
            tags.add(((Key)item).asTag());
        }
        return tags;
    }

    public PresetPanel createPanel(Collection<OsmPrimitive> selected) {
        List<Tag> directlyAppliedTags;
        PresetPanel p = new PresetPanel();
        LinkedList<Link> l = new LinkedList<Link>();
        LinkedList<PresetLink> presetLink = new LinkedList<PresetLink>();
        JPanel pp = new JPanel();
        if (this.types != null) {
            for (TaggingPresetType t : this.types) {
                JLabel la = new JLabel(ImageProvider.get(t.getIconName()));
                la.setToolTipText(I18n.tr("Elements of type {0} are supported.", I18n.tr(t.getName(), new Object[0])));
                pp.add(la);
            }
        }
        if (!(directlyAppliedTags = this.getDirectlyAppliedTags()).isEmpty()) {
            JLabel label = new JLabel(ImageProvider.get("pastetags"));
            label.setToolTipText("<html>" + I18n.tr("This preset also sets: {0}", Utils.joinAsHtmlUnorderedList(directlyAppliedTags)));
            pp.add(label);
        }
        int count = pp.getComponentCount();
        if (this.preset_name_label) {
            p.add((Component)new JLabel(this.getIcon("SwingLargeIconKey")), GBC.std(0, 0).span(1, count > 0 ? 2 : 1).insets(0, 0, 5, 0));
        }
        if (count > 0) {
            p.add((Component)pp, GBC.std(1, 0).span(0));
        }
        if (this.preset_name_label) {
            p.add((Component)new JLabel(this.getName()), GBC.std(1, count > 0 ? 1 : 0).insets(5, 0, 0, 0).span(0).fill(2));
        }
        boolean presetInitiallyMatches = !selected.isEmpty() && selected.stream().allMatch(this);
        JPanel items = new JPanel(new GridBagLayout());
        for (TaggingPresetItem taggingPresetItem : this.data) {
            if (taggingPresetItem instanceof Link) {
                l.add((Link)taggingPresetItem);
                p.hasElements = true;
                continue;
            }
            if (taggingPresetItem instanceof PresetLink) {
                presetLink.add((PresetLink)taggingPresetItem);
                continue;
            }
            if (!taggingPresetItem.addToPanel(items, selected, presetInitiallyMatches)) continue;
            p.hasElements = true;
        }
        p.add((Component)items, GBC.eol().fill());
        if (selected.isEmpty() && !this.supportsRelation()) {
            GuiHelper.setEnabledRec(items, false);
        }
        if (!presetLink.isEmpty()) {
            p.add((Component)new JLabel(I18n.tr("Edit also \u2026", new Object[0])), GBC.eol().insets(0, 8, 0, 0));
            for (PresetLink presetLink2 : presetLink) {
                presetLink2.addToPanel(p, selected, presetInitiallyMatches);
            }
        }
        for (Link link : l) {
            link.addToPanel(p, selected, presetInitiallyMatches);
        }
        JToggleButton tb = new JToggleButton(new ToolbarButtonAction());
        tb.setFocusable(false);
        p.add((Component)tb, GBC.std(1, 0).anchor(22));
        return p;
    }

    public boolean isShowable() {
        for (TaggingPresetItem i : this.data) {
            if (i instanceof Optional || i instanceof Space || i instanceof Key) continue;
            return true;
        }
        return false;
    }

    public String suggestRoleForOsmPrimitive(OsmPrimitive osm) {
        if (this.roles != null && osm != null) {
            for (Roles.Role i : this.roles.roles) {
                if (i.memberExpression == null || !i.memberExpression.match(osm) || i.types != null && !i.types.isEmpty() && !i.types.contains((Object)TaggingPresetType.forPrimitive(osm))) continue;
                return i.key;
            }
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataSet ds = OsmDataManager.getInstance().getEditDataSet();
        Collection<OsmPrimitive> participants = Collections.emptyList();
        if (ds != null) {
            participants = ds.getSelected();
        }
        Collection<OsmPrimitive> sel = this.createSelection(participants);
        int answer = this.showDialog(sel, this.supportsRelation());
        if (ds == null) {
            return;
        }
        if (!sel.isEmpty() && answer == 1) {
            Command cmd = TaggingPreset.createCommand(sel, this.getChangedTags());
            if (cmd != null) {
                UndoRedoHandler.getInstance().add(cmd);
            }
        } else if (answer == 2) {
            Relation r = new Relation();
            HashSet<RelationMember> members = new HashSet<RelationMember>();
            for (Tag t : this.getChangedTags()) {
                r.put(t.getKey(), t.getValue());
            }
            for (OsmPrimitive osm : ds.getSelected()) {
                String role = this.suggestRoleForOsmPrimitive(osm);
                RelationMember rm = new RelationMember(role == null ? "" : role, osm);
                r.addMember(rm);
                members.add(rm);
            }
            SwingUtilities.invokeLater(() -> RelationEditor.getEditor(MainApplication.getLayerManager().getEditLayer(), r, members).setVisible(true));
        }
        ds.setSelected(ds.getSelected());
    }

    public int showDialog(Collection<OsmPrimitive> sel, boolean showNewRelation) {
        boolean canCreateRelation;
        PresetPanel p = this.createPanel(sel);
        int answer = 1;
        boolean bl = canCreateRelation = this.types == null || this.types.contains((Object)TaggingPresetType.RELATION);
        if (this.originalSelectionEmpty && !canCreateRelation) {
            new Notification(I18n.tr("The preset <i>{0}</i> cannot be applied since nothing has been selected!", this.getLocaleName())).setIcon(2).show();
            return 3;
        }
        if (sel.isEmpty() && !canCreateRelation) {
            new Notification(I18n.tr("The preset <i>{0}</i> cannot be applied since the selection is unsuitable!", this.getLocaleName())).setIcon(2).show();
            return 3;
        }
        if (p.getComponentCount() != 0 && (sel.isEmpty() || p.hasElements)) {
            boolean disableApply;
            int size = sel.size();
            String title = I18n.trn("Change {0} object", "Change {0} objects", size, size);
            if (!showNewRelation && size == 0) {
                title = this.originalSelectionEmpty ? I18n.tr("Nothing selected!", new Object[0]) : I18n.tr("Selection unsuitable!", new Object[0]);
            }
            boolean bl2 = disableApply = size == 0;
            if (!disableApply) {
                DataSet ds = sel.iterator().next().getDataSet();
                disableApply = ds != null && ds.isLocked();
            }
            answer = new PresetDialog((Component)p, title, this.preset_name_label ? null : (ImageIcon)this.getValue("SmallIcon"), disableApply, showNewRelation).getValue();
        }
        if (!showNewRelation && answer == 2) {
            return 3;
        }
        return answer;
    }

    public Collection<OsmPrimitive> createSelection(Collection<OsmPrimitive> participants) {
        this.originalSelectionEmpty = participants.isEmpty();
        LinkedList<OsmPrimitive> sel = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osm : participants) {
            if (!this.typeMatches(EnumSet.of(TaggingPresetType.forPrimitive(osm)))) continue;
            sel.add(osm);
        }
        return sel;
    }

    public List<Tag> getChangedTags() {
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (TaggingPresetItem i : this.data) {
            i.addCommands(result);
        }
        return result;
    }

    public static Command createCommand(Collection<OsmPrimitive> sel, List<Tag> changedTags) {
        ArrayList<Command> cmds = new ArrayList<Command>();
        for (Tag tag : changedTags) {
            ChangePropertyCommand cmd = new ChangePropertyCommand(sel, tag.getKey(), tag.getValue());
            if (cmd.getObjectsNumber() <= 0) continue;
            cmds.add(cmd);
        }
        if (cmds.isEmpty()) {
            return null;
        }
        if (cmds.size() == 1) {
            return (Command)cmds.get(0);
        }
        return new SequenceCommand(I18n.tr("Change Tags", new Object[0]), cmds);
    }

    private boolean supportsRelation() {
        return this.types == null || this.types.contains((Object)TaggingPresetType.RELATION);
    }

    protected final void updateEnabledState() {
        this.setEnabled(OsmDataManager.getInstance().getEditDataSet() != null);
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        this.updateEnabledState();
    }

    public String toString() {
        return (this.types == null ? "" : this.types.toString()) + ' ' + this.name;
    }

    public boolean typeMatches(Collection<TaggingPresetType> t) {
        return t == null || this.types == null || this.types.containsAll(t);
    }

    @Override
    public boolean test(IPrimitive p) {
        return this.matches(EnumSet.of(TaggingPresetType.forPrimitive(p)), p.getKeys(), false);
    }

    public boolean matches(Collection<TaggingPresetType> t, Map<String, String> tags, boolean onlyShowable) {
        if (onlyShowable && !this.isShowable() || !this.typeMatches(t)) {
            return false;
        }
        return TaggingPresetItem.matches(this.data, tags);
    }

    public String getToolbarString() {
        ToolbarPreferences.ActionParser actionParser = new ToolbarPreferences.ActionParser(null);
        return actionParser.saveAction(new ToolbarPreferences.ActionDefinition(this));
    }

    public class ToolbarButtonAction
    extends AbstractAction {
        private final int toolbarIndex;

        public ToolbarButtonAction() {
            super("");
            new ImageProvider("dialogs", "pin").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Add or remove toolbar button", new Object[0]));
            LinkedList<String> t = new LinkedList<String>(ToolbarPreferences.getToolString());
            this.toolbarIndex = t.indexOf(TaggingPreset.this.getToolbarString());
            this.putValue("SwingSelectedKey", this.toolbarIndex >= 0);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String res = TaggingPreset.this.getToolbarString();
            MainApplication.getToolbar().addCustomButton(res, this.toolbarIndex, true);
        }
    }

    private static class PresetDialog
    extends ExtendedDialog {
        PresetDialog(Component content, String title, ImageIcon icon, boolean disableApply, boolean showNewRelation) {
            String[] stringArray;
            MainFrame mainFrame = MainApplication.getMainFrame();
            if (showNewRelation) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = I18n.tr("Apply Preset", new Object[0]);
                stringArray2[1] = I18n.tr("New relation", new Object[0]);
                stringArray = stringArray2;
                stringArray2[2] = I18n.tr("Cancel", new Object[0]);
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = I18n.tr("Apply Preset", new Object[0]);
                stringArray = stringArray3;
                stringArray3[1] = I18n.tr("Cancel", new Object[0]);
            }
            super((Component)mainFrame, title, stringArray, true);
            if (icon != null) {
                this.setIconImage(icon.getImage());
            }
            this.contentInsets = new Insets(10, 5, 0, 5);
            if (showNewRelation) {
                this.setButtonIcons("ok", "dialogs/addrelation", "cancel");
            } else {
                this.setButtonIcons("ok", "cancel");
            }
            this.setContent(content);
            this.setDefaultButton(1);
            this.setupDialog();
            ((JButton)this.buttons.get(0)).setEnabled(!disableApply);
            ((JButton)this.buttons.get(0)).setToolTipText(title);
            Dimension d = this.getSize();
            if (d.width < 350) {
                d.width = 350;
                this.setSize(d);
            }
            super.showDialog();
        }
    }

    private static class PresetPanel
    extends JPanel {
        private boolean hasElements;

        PresetPanel() {
            super(new GridBagLayout());
        }
    }
}

