/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.HashMap;
import java.util.Map;

public enum RubyEvent {
    LINE("line", 1),
    CLASS("class", 1),
    END("end", 1),
    CALL("call", 1),
    RETURN("return", 1),
    C_CALL("c-call", 1),
    C_RETURN("c-return", 1),
    B_CALL("b-call", 1),
    B_RETURN("b-return", 1),
    THREAD_BEGIN("thread-begin", 1),
    THREAD_END("thread-end", 1),
    RAISE("raise", 1),
    COVERAGE("coverage", 1),
    A_CALL("a-call", 1),
    A_RETURN("a-return", 1);

    private final String event_name;
    private final int line_number_offset;
    private static final Map<String, RubyEvent> fromName;

    private RubyEvent(String event_name, int line_number_offset) {
        this.event_name = event_name;
        this.line_number_offset = line_number_offset;
    }

    public int getLineNumberOffset() {
        return this.line_number_offset;
    }

    public String getName() {
        return this.event_name;
    }

    public static RubyEvent fromOrdinal(int value2) {
        return value2 < 0 || value2 >= RubyEvent.values().length ? null : RubyEvent.values()[value2];
    }

    public static RubyEvent fromName(String name2) {
        return fromName.get(name2);
    }

    static {
        fromName = new HashMap<String, RubyEvent>();
        for (RubyEvent event2 : RubyEvent.values()) {
            fromName.put(event2.getName(), event2);
        }
    }
}

