'''OpenGL extension APPLE.aux_depth_stencil

This module customises the behaviour of the 
OpenGL.raw.GL.APPLE.aux_depth_stencil to provide a more 
Python-friendly API

Overview (from the spec)
	
	Normally, each OpenGL drawable allocates at most one depth buffer and one
	stencil buffer, regardless of how many aux buffers there are.
	
	When the APPLE_aux_depth_stencil extension is used, and the depth buffer
	size is non-zero, the GL silently allocates a separate depth buffer for the
	color buffer and for each aux buffer.  Similarly, if the stencil buffer size
	is non-zero, a separate stencil buffer is allocated for the color buffer and
	each aux buffer.  This extension does not cause separate depth or stencil
	buffers to be allocated for the left and right buffers of a stereo drawable.
	A context with no aux buffers will be unaffected by this extension.  
	
	Switching the draw or read buffer from the color buffer to an aux buffer, or
	switching between two aux buffers, simultaneously switches the associated
	depth and stencil buffers, for drawing or reading.
	
	For example, if an OpenGL context has two aux buffers and non-zero depth
	buffer size, it will have a total of three depth buffers - one associated
	with the color buffer and one associated with each aux buffer.  If that
	context is used to render to AUX0, then to render to AUX1, the changes to
	the depth buffer made by the rendering to AUX1 will not affect the depth
	buffer associated with AUX0, and vice versa.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/APPLE/aux_depth_stencil.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.APPLE.aux_depth_stencil import *
from OpenGL.raw.GL.APPLE.aux_depth_stencil import _EXTENSION_NAME

def glInitAuxDepthStencilAPPLE():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION