/*
 * Decompiled with CFR 0.152.
 */
package de.k621.avr.gps.converter;

import bt747.j2se_view.GPSKMZFile;
import bt747.j2se_view.J2SEController;
import bt747.model.Model;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747FileName;
import bt747.sys.interfaces.BT747Path;
import de.k621.avr.gps.converter.FileTypeFilter;
import gps.connection.GPSrxtx;
import gps.log.LogFileInfo;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import net.sf.bt747.j2se.system.J2SEJavaTranslations;

public class NMEAConverter
extends JFrame {
    private static final Preferences PREFS;
    private JProgressBar barProgress;
    private JButton btnBrowseInput;
    private JButton btnElevationTable;
    private JButton btnGPX;
    private JButton btnKML;
    private JButton btnSpeed;
    private JCheckBox chkHdop;
    private JCheckBox chkSat;
    private JComboBox comHdop;
    private JComboBox comSats;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JLabel lblAuthor;
    private JLabel lblHomepage;
    private JLabel lblInfo2;
    private JLabel lblInput;
    private JLabel lblProgress;
    private JLabel lblSats;
    private JLabel lblTitle;
    private JTextField txtInput;
    private Model m = new Model();
    private J2SEController c = new J2SEController(this.m);

    public NMEAConverter() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        NMEAConverter nMEAConverter = this;
        this.txtInput = new JTextField();
        nMEAConverter.lblTitle = new JLabel();
        nMEAConverter.lblInput = new JLabel();
        nMEAConverter.btnBrowseInput = new JButton();
        nMEAConverter.btnKML = new JButton();
        nMEAConverter.btnElevationTable = new JButton();
        nMEAConverter.btnSpeed = new JButton();
        nMEAConverter.chkSat = new JCheckBox();
        nMEAConverter.lblSats = new JLabel();
        nMEAConverter.comSats = new JComboBox();
        nMEAConverter.chkHdop = new JCheckBox();
        nMEAConverter.comHdop = new JComboBox();
        nMEAConverter.lblInfo2 = new JLabel();
        nMEAConverter.jSeparator1 = new JSeparator();
        nMEAConverter.jSeparator2 = new JSeparator();
        nMEAConverter.lblHomepage = new JLabel();
        nMEAConverter.lblAuthor = new JLabel();
        nMEAConverter.barProgress = new JProgressBar();
        nMEAConverter.btnGPX = new JButton();
        nMEAConverter.jSeparator3 = new JSeparator();
        nMEAConverter.jSeparator4 = new JSeparator();
        nMEAConverter.lblProgress = new JLabel();
        nMEAConverter.setDefaultCloseOperation(3);
        nMEAConverter.setTitle("NMEA Toolbox");
        nMEAConverter.setCursor(new Cursor(0));
        nMEAConverter.setResizable(false);
        nMEAConverter.txtInput.setEditable(false);
        nMEAConverter.txtInput.setText("Bitte w\u00e4hlen Sie eine Datei aus...");
        nMEAConverter.lblTitle.setFont(new Font("Verdana", 0, 36));
        nMEAConverter.lblTitle.setHorizontalAlignment(0);
        nMEAConverter.lblTitle.setText("NMEA Toolbox V1.3");
        nMEAConverter.lblInput.setLabelFor(nMEAConverter.txtInput);
        nMEAConverter.lblInput.setText("Bitte Eingangs-Datei ausw\u00e4hlen :");
        nMEAConverter.btnBrowseInput.setText("Durchsuchen...");
        nMEAConverter.btnBrowseInput.addActionListener(new ActionListener(nMEAConverter){
            private /* synthetic */ NMEAConverter this$0;
            {
                this.this$0 = nMEAConverter;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                NMEAConverter.access$000$444cd05e(this.this$0);
            }
        });
        nMEAConverter.btnKML.setIcon(new ImageIcon(nMEAConverter.getClass().getResource("/de/k621/avr/gps/converter/icons/kml.png")));
        nMEAConverter.btnKML.setToolTipText("KML Datei erstellen (f\u00fcr Google Earth/Maps)");
        nMEAConverter.btnKML.setPreferredSize(new Dimension(90, 90));
        nMEAConverter.btnKML.addActionListener(new ActionListener(nMEAConverter){
            private /* synthetic */ NMEAConverter this$0;
            {
                this.this$0 = nMEAConverter;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.convert(2, "kml");
            }
        });
        nMEAConverter.btnElevationTable.setIcon(new ImageIcon(nMEAConverter.getClass().getResource("/de/k621/avr/gps/converter/icons/elev.png")));
        nMEAConverter.btnElevationTable.setToolTipText("H\u00f6hendiagramm erstellen");
        nMEAConverter.btnElevationTable.addActionListener(new ActionListener(nMEAConverter){
            private /* synthetic */ NMEAConverter this$0;
            {
                this.this$0 = nMEAConverter;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.convert(3, "csv");
            }
        });
        nMEAConverter.btnSpeed.setIcon(new ImageIcon(nMEAConverter.getClass().getResource("/de/k621/avr/gps/converter/icons/spd.png")));
        nMEAConverter.btnSpeed.setToolTipText("Geschwindigkeitsdiagramm erstellen");
        nMEAConverter.btnSpeed.addActionListener(new ActionListener(nMEAConverter){
            private /* synthetic */ NMEAConverter this$0;
            {
                this.this$0 = nMEAConverter;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.convert(4, "csv");
            }
        });
        nMEAConverter.chkSat.setText("Nur Punkte mit mindestens");
        nMEAConverter.lblSats.setLabelFor(nMEAConverter.chkSat);
        nMEAConverter.lblSats.setText("Satteliten nehmen");
        nMEAConverter.comSats.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"}));
        nMEAConverter.chkHdop.setText("Nur Punkte mit geringerem HDOP als");
        nMEAConverter.comHdop.setModel(new DefaultComboBoxModel<String>(new String[]{"1.0 (Bestes)", "3.5", "6", "8.5", "11 (Schlechtestes)"}));
        nMEAConverter.comHdop.setSelectedItem(nMEAConverter.comHdop.getModel().getElementAt(3));
        nMEAConverter.lblInfo2.setText("Filter :");
        nMEAConverter.lblHomepage.setFont(new Font("Tahoma", 1, 14));
        nMEAConverter.lblHomepage.setText("k621.de");
        nMEAConverter.lblAuthor.setFont(new Font("Tahoma", 1, 14));
        nMEAConverter.lblAuthor.setText("Martin Matysiak");
        nMEAConverter.btnGPX.setIcon(new ImageIcon(nMEAConverter.getClass().getResource("/de/k621/avr/gps/converter/icons/gpx.png")));
        nMEAConverter.btnGPX.setToolTipText("GPX Datei erstellen");
        nMEAConverter.btnGPX.setMaximumSize(new Dimension(100, 89));
        nMEAConverter.btnGPX.setMinimumSize(new Dimension(100, 89));
        nMEAConverter.btnGPX.setName("btnGPX");
        nMEAConverter.btnGPX.setPreferredSize(new Dimension(90, 90));
        nMEAConverter.btnGPX.addActionListener(new ActionListener(nMEAConverter){
            private /* synthetic */ NMEAConverter this$0;
            {
                this.this$0 = nMEAConverter;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.convert(1, "gpx");
            }
        });
        nMEAConverter.lblProgress.setHorizontalAlignment(0);
        nMEAConverter.lblProgress.setText("Programm initalisiert");
        GroupLayout groupLayout = new GroupLayout(nMEAConverter.getContentPane());
        nMEAConverter.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(nMEAConverter.chkSat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(nMEAConverter.comSats, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(nMEAConverter.lblSats)).addGroup(groupLayout.createSequentialGroup().addComponent(nMEAConverter.chkHdop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(nMEAConverter.comHdop, -2, 90, -2)).addComponent(nMEAConverter.lblInfo2).addComponent(nMEAConverter.lblTitle, -1, 434, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(nMEAConverter.lblAuthor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 270, Short.MAX_VALUE).addComponent(nMEAConverter.lblHomepage)).addComponent(nMEAConverter.jSeparator1, GroupLayout.Alignment.TRAILING, -1, 434, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(nMEAConverter.lblInput).addComponent(nMEAConverter.txtInput, -1, 321, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(nMEAConverter.btnBrowseInput)).addComponent(nMEAConverter.jSeparator2, -1, 434, Short.MAX_VALUE)).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(nMEAConverter.btnGPX, -2, -1, -2).addGap(18, 18, 18).addComponent(nMEAConverter.btnKML, -2, -1, -2).addGap(18, 18, 18).addComponent(nMEAConverter.btnElevationTable, -2, 90, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(nMEAConverter.btnSpeed, -2, 90, Short.MAX_VALUE).addGap(10, 10, 10)).addComponent(nMEAConverter.jSeparator4, GroupLayout.Alignment.TRAILING, -1, 434, Short.MAX_VALUE)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(nMEAConverter.jSeparator3, -1, 434, Short.MAX_VALUE).addGap(10, 10, 10)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(nMEAConverter.barProgress, GroupLayout.Alignment.LEADING, -1, 434, Short.MAX_VALUE).addComponent(nMEAConverter.lblProgress, GroupLayout.Alignment.LEADING, -1, 434, Short.MAX_VALUE)).addContainerGap()))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(nMEAConverter.lblTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(nMEAConverter.lblHomepage).addComponent(nMEAConverter.lblAuthor)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(nMEAConverter.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(nMEAConverter.lblInput).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(nMEAConverter.btnBrowseInput).addComponent(nMEAConverter.txtInput, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(nMEAConverter.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(nMEAConverter.lblInfo2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(nMEAConverter.chkSat).addComponent(nMEAConverter.comSats, -2, -1, -2).addComponent(nMEAConverter.lblSats)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(nMEAConverter.comHdop, -2, -1, -2).addComponent(nMEAConverter.chkHdop)).addGap(18, 18, 18).addComponent(nMEAConverter.jSeparator4, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(nMEAConverter.btnGPX, -2, -1, -2).addComponent(nMEAConverter.btnKML, -2, -1, -2).addComponent(nMEAConverter.btnElevationTable).addComponent(nMEAConverter.btnSpeed)).addGap(18, 18, 18).addComponent(nMEAConverter.jSeparator3, -2, 12, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(nMEAConverter.lblProgress).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(nMEAConverter.barProgress, -2, 36, -2).addContainerGap()));
        nMEAConverter.pack();
        this.setBounds(50, 50, this.getWidth(), this.getHeight());
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            public final void run() {
                new NMEAConverter().setVisible(true);
            }
        });
    }

    private int convertLog(int n) {
        System.out.println("Input file: " + this.m.getStringOpt(12));
        if (Model.logFiles.size() != 0) {
            for (int i = 0; i < Model.logFiles.size(); ++i) {
                LogFileInfo logFileInfo = (LogFileInfo)Model.logFiles.elementAt(i);
                System.out.println("Input file: " + logFileInfo.getBT747Path().getPath());
            }
        }
        System.out.println("Output directory: " + this.m.getStringOpt(9));
        System.out.println("Output basename: " + this.m.getStringOpt(10));
        if (Model.logFiles.size() != 0) {
            this.c.setStringOpt(12, "");
        }
        n = n == 11 ? this.c.doConvertLog(n, new GPSKMZFile(), ".kmz") : this.c.doConvertLog(n);
        return n;
    }

    private void convert(int n, String string) {
        try {
            if (!new File(this.txtInput.getText()).exists()) {
                throw new IOException("Bitte w\u00e4hlen Sie eine existierende Eingabedatei aus!");
            }
            JFileChooser jFileChooser = new JFileChooser(PREFS.get("output.dir", PREFS.get("input.dir", null)));
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileFilter(new FileTypeFilter(string));
            if (jFileChooser.showSaveDialog(this) != 0) {
                throw new IOException("Es wurde keine Ausgabedatei ausgew\u00e4hlt");
            }
            String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
            PREFS.put("output.dir", jFileChooser.getSelectedFile().getParent());
            if (!string2.endsWith("." + string)) {
                string2 = string2 + "." + string;
            }
            if (new File(string2).exists()) {
                throw new IOException("Bitte w\u00e4hlen Sie eine nicht existente Datei zur Ausgabe aus!");
            }
            int n2 = this.chkSat.isEnabled() ? this.comSats.getSelectedIndex() + 1 : 0;
            float f = this.chkHdop.isEnabled() ? 1.0f + (float)this.comHdop.getSelectedIndex() * 2.5f : Float.POSITIVE_INFINITY;
            this.m.init();
            this.c.setIntOpt(88, -66);
            this.c.setIntOpt(86, -66);
            this.c.setIntOpt(89, 0);
            this.c.setIntOpt(87, -1);
            this.c.setBooleanOpt(39, true);
            this.c.setFloatOpt(82, f);
            this.c.setIntOpt(76, n2);
            this.c.setStringOpt(12, this.txtInput.getText());
            n2 = -1;
            switch (n) {
                case 1: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 4;
                    break;
                }
                case 3: {
                    n2 = 1;
                    break;
                }
                case 4: {
                    n2 = 1;
                }
            }
            String string3 = string2;
            this.c.setFileNameBuilder(new BT747FileName(string3){
                private /* synthetic */ String val$oFileName;
                {
                    this.val$oFileName = string;
                }

                public final BT747Path getOutputFileName(BT747Path bT747Path, int n, String string, String string2) {
                    return new BT747Path(this.val$oFileName);
                }
            });
            if (this.convertLog(n2) != 0) {
                String string4 = this.c.getLastErrorInfo();
                int n3 = this.c.getLastError();
                System.err.println("\n####    PROBLEM  !!! ####");
                String string5 = "";
                switch (n3) {
                    case -1: {
                        string5 = "ERROR - Could not open ";
                        break;
                    }
                    case -2: {
                        string5 = "WARNING - No files were created - Check the input type.";
                        break;
                    }
                    case -3: {
                        string5 = "ERROR - Problem reading" + string4;
                    }
                }
                JOptionPane.showMessageDialog(null, string5, "Fehler", 0);
            }
            return;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, iOException.getLocalizedMessage(), "Fehler", 0);
            return;
        }
    }

    static /* synthetic */ void access$000$444cd05e(NMEAConverter nMEAConverter) {
        JFileChooser jFileChooser = new JFileChooser(PREFS.get("input.dir", null));
        if (jFileChooser.showOpenDialog(nMEAConverter) == 0) {
            nMEAConverter.txtInput.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            PREFS.put("input.dir", jFileChooser.getSelectedFile().getParent());
        }
    }

    static {
        JavaLibBridge.setJavaLibImplementation(J2SEJavaTranslations.getInstance());
        GPSrxtx.setDefaultGpsPortInstance(null);
        PREFS = Preferences.userNodeForPackage(NMEAConverter.class);
    }
}

