import ll = require("../lowLevelAST");
import hl = require("../highLevelAST");
import yaml = require("yaml-ast-parser");
import refResolvers = require("../jsyaml/includeRefResolvers");
export declare class LowLevelProxyNode implements ll.ILowLevelASTNode {
    protected _parent: ll.ILowLevelASTNode;
    protected _transformer: ValueTransformer;
    protected ramlVersion: string;
    private static CLASS_IDENTIFIER;
    static isInstance(instance: any): instance is LowLevelProxyNode;
    getClassIdentifier(): string[];
    constructor(_parent: ll.ILowLevelASTNode, _transformer: ValueTransformer, ramlVersion: string);
    protected _originalNode: ll.ILowLevelASTNode;
    private _highLevelNode;
    private _highLevelParseResult;
    protected _keyOverride: string;
    protected _valueOverride: string;
    protected _meta: {
        [key: string]: any;
    };
    hasInnerIncludeError(): boolean;
    keyKind(): yaml.Kind;
    primaryNode(): ll.ILowLevelASTNode;
    isAnnotatedScalar(): boolean;
    actual(): any;
    transformer(): ValueTransformer;
    setTransformer(tr: ValueTransformer): void;
    originalNode(): ll.ILowLevelASTNode;
    start(): number;
    end(): number;
    value(toString?: boolean): any;
    includeErrors(): string[];
    includePath(): string;
    includeReference(): refResolvers.IncludeReference;
    setKeyOverride(_key: string): void;
    setValueOverride(value: any): void;
    key(raw?: boolean): string;
    optional(): boolean;
    children(): ll.ILowLevelASTNode[];
    parent(): ll.ILowLevelASTNode;
    unit(): ll.ICompilationUnit;
    containingUnit(): ll.ICompilationUnit;
    includeBaseUnit(): ll.ICompilationUnit;
    anchorId(): string;
    errors(): Error[];
    anchoredFrom(): ll.ILowLevelASTNode;
    includedFrom(): ll.ILowLevelASTNode;
    visit(v: ll.ASTVisitor): void;
    addChild(n: ll.ILowLevelASTNode): void;
    execute(cmd: ll.CompositeCommand): void;
    dump(): string;
    dumpToObject(full: boolean): any;
    keyStart(): number;
    keyEnd(): number;
    valueStart(): number;
    valueEnd(): number;
    isValueLocal(): boolean;
    kind(): yaml.Kind;
    valueKind(): yaml.Kind;
    anchorValueKind(): yaml.Kind;
    resolvedValueKind(): yaml.Kind;
    show(msg: string): void;
    setHighLevelParseResult(highLevelParseResult: hl.IParseResult): void;
    highLevelParseResult(): hl.IParseResult;
    setHighLevelNode(highLevel: hl.IHighLevelNode): void;
    highLevelNode(): hl.IHighLevelNode;
    text(unitText: string): string;
    copy(): LowLevelCompositeNode;
    markup(json?: boolean): string;
    nodeDefinition(): hl.INodeDefinition;
    includesContents(): boolean;
    root(): ll.ILowLevelASTNode;
    find(name: string): ll.ILowLevelASTNode;
    isMap(): boolean;
    isMapping(): boolean;
    isSeq(): boolean;
    isScalar(): boolean;
    isValueSeq(): boolean;
    isValueMap(): boolean;
    isValueInclude(): boolean;
    isValueScalar(): boolean;
    definingUnitSequence(): ll.ICompilationUnit[];
    addMeta(key: string, value: any): void;
    getMeta(key: string): any;
}
export declare class LowLevelCompositeNode extends LowLevelProxyNode {
    private isPrimary;
    private static CLASS_IDENTIFIER_LowLevelCompositeNode;
    static isInstance(instance: any): instance is LowLevelCompositeNode;
    getClassIdentifier(): string[];
    constructor(node: ll.ILowLevelASTNode, parent: LowLevelCompositeNode, transformer: ValueTransformer, ramlVersion: string, isPrimary?: boolean);
    protected _adoptedNodes: LowLevelValueTransformingNode[];
    protected _children: LowLevelCompositeNode[];
    protected _preserveAnnotations: boolean;
    protected isInsideResource: boolean;
    protected nonMergableChildren: {
        [key: string]: boolean;
    };
    originalNode(): LowLevelValueTransformingNode;
    adoptedNodes(): ll.ILowLevelASTNode[];
    primaryNode(): LowLevelValueTransformingNode;
    parent(): LowLevelCompositeNode;
    adopt(node: ll.ILowLevelASTNode, transformer: ValueTransformer): void;
    value(toString?: boolean): any;
    patchAdoptedNodes(entries: {
        node: ll.ILowLevelASTNode;
        transformer: ValueTransformer;
    }[]): void;
    children(): LowLevelCompositeNode[];
    private buildKey(y);
    private collectChildrenWithKeys();
    private isResource();
    private skipKey(key, isPrimary);
    valueKind(): yaml.Kind;
    includePath(): string;
    includeBaseUnit(): ll.ICompilationUnit;
    includeReference(): refResolvers.IncludeReference;
    optional(): boolean;
    replaceChild(oldNode: ll.ILowLevelASTNode, newNode: ll.ILowLevelASTNode, isPrimary?: boolean, transformer?: ValueTransformer): LowLevelCompositeNode;
    removeChild(oldNode: ll.ILowLevelASTNode): LowLevelCompositeNode;
    setChildren(nodes: ll.ILowLevelASTNode[]): LowLevelCompositeNode;
    resetChildren(): void;
    preserveAnnotations(): void;
    filterChildren(): void;
    containingUnit(): ll.ICompilationUnit;
    takeOnlyOriginalChildrenWithKey(key: string): void;
}
export declare class LowLevelValueTransformingNode extends LowLevelProxyNode {
    private static CLASS_IDENTIFIER_LowLevelValueTransformingNode;
    static isInstance(instance: any): instance is LowLevelValueTransformingNode;
    getClassIdentifier(): string[];
    constructor(node: ll.ILowLevelASTNode, parent: ll.ILowLevelASTNode, transformer: ValueTransformer, ramlVersion: string);
    value(toString?: boolean): any;
    children(): LowLevelValueTransformingNode[];
    valueKind(): yaml.Kind;
    anchorValueKind(): yaml.Kind;
    resolvedValueKind(): yaml.Kind;
    includePath(): string;
    parent(): LowLevelValueTransformingNode;
    key(raw?: boolean): string;
}
export interface ValueTransformer {
    transform(value: any, toString?: boolean): {
        value: any;
        errors: hl.ValidationIssue[];
    };
    children(node: ll.ILowLevelASTNode): ll.ILowLevelASTNode[];
    valueKind(node: ll.ILowLevelASTNode): yaml.Kind;
    anchorValueKind(node: ll.ILowLevelASTNode): yaml.Kind;
    resolvedValueKind(node: ll.ILowLevelASTNode): yaml.Kind;
    includePath(node: ll.ILowLevelASTNode): string;
    paramNodesChain(node: ll.ILowLevelASTNode, inKey: boolean): ll.ILowLevelASTNode[];
    definingUnitSequence(str: string): ll.ICompilationUnit[];
}
export declare function isLowLevelProxyNode(node: any): node is LowLevelProxyNode;
