/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.ai.mission.Mission;

public class WishRealizationMission
extends Mission {
    private static final Logger logger = Logger.getLogger(WishRealizationMission.class.getName());
    private static final String tag = "AI wisher";
    private Wish wish;
    private static final String WISH_TAG = "wish";
    private static final String OLD_GOODS_WISH_TAG = "GoodsWish";

    public WishRealizationMission(AIMain aiMain, AIUnit aiUnit, Wish wish) {
        super(aiMain, aiUnit, wish.getDestination());
        this.wish = wish;
        wish.setTransportable(aiUnit);
    }

    public WishRealizationMission(AIMain aiMain, AIUnit aiUnit, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(xr);
    }

    public Wish getWish() {
        return this.wish;
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = WishRealizationMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : ((reason = WishRealizationMission.invalidTargetReason(loc, aiUnit.getUnit().getOwner())) != null ? reason : null);
    }

    @Override
    public void dispose() {
        if (this.wish != null) {
            this.wish.setTransportable(null);
            this.wish = null;
        }
        super.dispose();
    }

    @Override
    public int getBaseTransportPriority() {
        return 100;
    }

    @Override
    public Location getTarget() {
        return this.wish == null ? null : this.wish.getDestination();
    }

    @Override
    public void setTarget(Location target) {
    }

    @Override
    public Location findTarget() {
        return this.getTarget();
    }

    @Override
    public String invalidReason() {
        return this.wish == null ? "wish-null" : WishRealizationMission.invalidReason(this.getAIUnit(), this.getTarget());
    }

    @Override
    public Mission doMission(LogBuilder lb) {
        lb.add(tag);
        String reason = this.invalidReason();
        if (reason != null) {
            return this.lbFail(lb, false, reason);
        }
        Unit unit = this.getUnit();
        Location target = this.getTarget();
        Unit.MoveType mt = this.travelToTarget(target, CostDeciders.avoidSettlementsAndBlockingUnits(), lb);
        switch (mt) {
            case MOVE: {
                break;
            }
            case MOVE_HIGH_SEAS: 
            case MOVE_NO_MOVES: 
            case MOVE_NO_REPAIR: 
            case MOVE_ILLEGAL: {
                return this.lbWait(lb, new Object[0]);
            }
            case MOVE_NO_ACCESS_EMBARK: 
            case MOVE_NO_TILE: {
                return this;
            }
            default: {
                return this.lbMove(lb, mt);
            }
        }
        this.lbAt(lb);
        if (target instanceof Colony) {
            AIMain aiMain = this.getAIMain();
            Colony colony = (Colony)target;
            AIUnit aiUnit = this.getAIUnit();
            AIColony aiColony = aiMain.getAIColony(colony);
            EuropeanAIPlayer owner = this.getEuropeanAIPlayer();
            aiColony.completeWish(this.wish, unit.toShortString(), lb);
            if (unit.getType().isOffensive()) {
                if (owner.getDefendSettlementMission(aiUnit, colony) != null) {
                    this.lbDone(lb, true, "ready to defend, ", colony);
                } else {
                    this.lbFail(lb, true, "unable to defend");
                }
            } else {
                aiColony.requestRearrange();
                if (owner.getWorkInsideColonyMission(aiUnit, aiColony) != null) {
                    this.lbDone(lb, true, "ready to work ", colony);
                } else {
                    this.lbFail(lb, true, "unable to work");
                }
            }
        } else {
            this.lbFail(lb, true, "broken wish ", this.wish);
        }
        this.wish = null;
        return this.lbDrop(lb, new Object[0]);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(WISH_TAG, this.wish);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        AIMain aiMain = this.getAIMain();
        String wid = xr.getAttribute(WISH_TAG, null);
        this.wish = xr.getAttribute(aiMain, WISH_TAG, Wish.class, (Wish)null);
        if (this.wish == null) {
            if (wid.startsWith(GoodsWish.getXMLElementTagName()) || wid.startsWith(OLD_GOODS_WISH_TAG)) {
                this.wish = new GoodsWish(aiMain, wid);
            } else if (wid.startsWith(WorkerWish.getXMLElementTagName())) {
                this.wish = new WorkerWish(aiMain, wid);
            } else {
                throw new XMLStreamException("Unknown wish tag: " + wid);
            }
        }
    }

    @Override
    public String getXMLTagName() {
        return WishRealizationMission.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "wishRealizationMission";
    }
}

