/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.gradle.internal.file.FileMetadataSnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemMirror;
import org.gradle.internal.snapshot.WellKnownFileLocations;

public class DefaultFileSystemMirror
implements FileSystemMirror {
    private final Map<String, FileMetadataSnapshot> metadata = new ConcurrentHashMap<String, FileMetadataSnapshot>();
    private final Map<String, FileMetadataSnapshot> cacheMetadata = new ConcurrentHashMap<String, FileMetadataSnapshot>();
    private final Map<String, FileSystemLocationSnapshot> files = new ConcurrentHashMap<String, FileSystemLocationSnapshot>();
    private final Map<String, FileSystemLocationSnapshot> cacheFiles = new ConcurrentHashMap<String, FileSystemLocationSnapshot>();
    private final WellKnownFileLocations wellKnownFileLocations;

    public DefaultFileSystemMirror(WellKnownFileLocations wellKnownFileLocations) {
        this.wellKnownFileLocations = wellKnownFileLocations;
    }

    @Override
    @Nullable
    public FileSystemLocationSnapshot getSnapshot(String absolutePath) {
        if (this.wellKnownFileLocations.isImmutable(absolutePath)) {
            return this.cacheFiles.get(absolutePath);
        }
        return this.files.get(absolutePath);
    }

    @Override
    public void putSnapshot(FileSystemLocationSnapshot snapshot) {
        String absolutePath = snapshot.getAbsolutePath();
        if (this.wellKnownFileLocations.isImmutable(absolutePath)) {
            this.cacheFiles.put(absolutePath, snapshot);
        } else {
            this.files.put(absolutePath, snapshot);
        }
    }

    @Override
    public FileMetadataSnapshot getMetadata(String absolutePath) {
        if (this.wellKnownFileLocations.isImmutable(absolutePath)) {
            return this.cacheMetadata.get(absolutePath);
        }
        return this.metadata.get(absolutePath);
    }

    @Override
    public void putMetadata(String absolutePath, FileMetadataSnapshot metadata) {
        if (this.wellKnownFileLocations.isImmutable(absolutePath)) {
            this.cacheMetadata.put(absolutePath, metadata);
        } else {
            this.metadata.put(absolutePath, metadata);
        }
    }

    public void beforeTaskOutputChanged() {
        this.metadata.clear();
        this.files.clear();
    }

    public void beforeBuildFinished() {
        this.metadata.clear();
        this.cacheMetadata.clear();
        this.files.clear();
        this.cacheFiles.clear();
    }
}

