/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionLeafVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.cache.internal.ProducerGuard;
import org.gradle.internal.Factory;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.file.FileMetadataSnapshot;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemMirror;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotter;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.impl.DirectorySnapshotter;
import org.gradle.internal.snapshot.impl.FileSystemSnapshotBuilder;
import org.gradle.internal.snapshot.impl.FileSystemSnapshotFilter;

@NonNullApi
public class DefaultFileSystemSnapshotter
implements FileSystemSnapshotter {
    private static final PatternSet EMPTY_PATTERN_SET = new PatternSet();
    private final FileHasher hasher;
    private final StringInterner stringInterner;
    private final FileSystem fileSystem;
    private final FileSystemMirror fileSystemMirror;
    private final ProducerGuard<String> producingSnapshots = ProducerGuard.striped();
    private final DirectorySnapshotter directorySnapshotter;

    public DefaultFileSystemSnapshotter(FileHasher hasher, StringInterner stringInterner, FileSystem fileSystem, FileSystemMirror fileSystemMirror, String ... defaultExcludes) {
        this.hasher = hasher;
        this.stringInterner = stringInterner;
        this.fileSystem = fileSystem;
        this.fileSystemMirror = fileSystemMirror;
        this.directorySnapshotter = new DirectorySnapshotter(hasher, fileSystem, stringInterner, defaultExcludes);
    }

    @Override
    public HashCode getRegularFileContentHash(final File file) {
        final String absolutePath = file.getAbsolutePath();
        FileMetadataSnapshot metadata = this.fileSystemMirror.getMetadata(absolutePath);
        if (metadata != null) {
            if (metadata.getType() != FileType.RegularFile) {
                return null;
            }
            FileSystemLocationSnapshot snapshot = this.fileSystemMirror.getSnapshot(absolutePath);
            if (snapshot != null) {
                return snapshot.getHash();
            }
        }
        return (HashCode)this.producingSnapshots.guardByKey((Object)absolutePath, (Factory)new Factory<HashCode>(){

            @Nullable
            public HashCode create() {
                InternableString internableAbsolutePath = new InternableString(absolutePath);
                FileMetadataSnapshot metadata = DefaultFileSystemSnapshotter.this.statAndCache(internableAbsolutePath, file);
                if (metadata.getType() != FileType.RegularFile) {
                    return null;
                }
                FileSystemLocationSnapshot snapshot = DefaultFileSystemSnapshotter.this.snapshotAndCache(internableAbsolutePath, file, metadata, null);
                return snapshot.getHash();
            }
        });
    }

    @Override
    public FileSystemLocationSnapshot snapshot(final File file) {
        String absolutePath = file.getAbsolutePath();
        FileSystemLocationSnapshot result = this.fileSystemMirror.getSnapshot(absolutePath);
        if (result == null) {
            result = (FileSystemLocationSnapshot)this.producingSnapshots.guardByKey((Object)absolutePath, (Factory)new Factory<FileSystemLocationSnapshot>(){

                public FileSystemLocationSnapshot create() {
                    return DefaultFileSystemSnapshotter.this.snapshotAndCache(file, null);
                }
            });
        }
        return result;
    }

    @Override
    public List<FileSystemSnapshot> snapshot(FileCollectionInternal fileCollection) {
        FileCollectionLeafVisitorImpl visitor = new FileCollectionLeafVisitorImpl();
        fileCollection.visitLeafCollections((FileCollectionLeafVisitor)visitor);
        return visitor.getRoots();
    }

    private FileSystemLocationSnapshot snapshotAndCache(File file, @Nullable PatternSet patternSet) {
        InternableString absolutePath = new InternableString(file.getAbsolutePath());
        FileMetadataSnapshot metadata = this.statAndCache(absolutePath, file);
        return this.snapshotAndCache(absolutePath, file, metadata, patternSet);
    }

    private FileMetadataSnapshot statAndCache(InternableString absolutePath, File file) {
        FileMetadataSnapshot metadata = this.fileSystemMirror.getMetadata(absolutePath.asNonInterned());
        if (metadata == null) {
            metadata = this.fileSystem.stat(file);
            this.fileSystemMirror.putMetadata(absolutePath.asInterned(), metadata);
        }
        return metadata;
    }

    private FileSystemLocationSnapshot snapshotAndCache(InternableString absolutePath, File file, FileMetadataSnapshot metadata, @Nullable PatternSet patternSet) {
        FileSystemLocationSnapshot fileSystemLocationSnapshot = this.fileSystemMirror.getSnapshot(absolutePath.asNonInterned());
        if (fileSystemLocationSnapshot == null) {
            MutableBoolean hasBeenFiltered = new MutableBoolean(false);
            fileSystemLocationSnapshot = this.snapshot(absolutePath.asInterned(), patternSet, file, metadata, hasBeenFiltered);
            if (!hasBeenFiltered.get()) {
                this.fileSystemMirror.putSnapshot(fileSystemLocationSnapshot);
            }
        }
        return fileSystemLocationSnapshot;
    }

    private FileSystemLocationSnapshot snapshot(String absolutePath, @Nullable PatternSet patternSet, File file, FileMetadataSnapshot metadata, MutableBoolean hasBeenFiltered) {
        String name = this.stringInterner.intern(file.getName());
        switch (metadata.getType()) {
            case Missing: {
                return new MissingFileSnapshot(absolutePath, name);
            }
            case RegularFile: {
                return new RegularFileSnapshot(absolutePath, name, this.hasher.hash(file, metadata), metadata.getLastModified());
            }
            case Directory: {
                return this.directorySnapshotter.snapshot(absolutePath, patternSet, hasBeenFiltered);
            }
        }
        throw new IllegalArgumentException("Unrecognized file type: " + metadata.getType());
    }

    @VisibleForTesting
    FileSystemSnapshot snapshotDirectoryTree(final DirectoryFileTree dirTree) {
        final String path = dirTree.getDir().getAbsolutePath();
        final PatternSet patterns = dirTree.getPatterns();
        FileSystemLocationSnapshot snapshot = this.fileSystemMirror.getSnapshot(path);
        if (snapshot != null) {
            return this.filterSnapshot(snapshot, patterns);
        }
        return (FileSystemSnapshot)this.producingSnapshots.guardByKey((Object)path, (Factory)new Factory<FileSystemSnapshot>(){

            public FileSystemSnapshot create() {
                FileSystemLocationSnapshot snapshot = DefaultFileSystemSnapshotter.this.fileSystemMirror.getSnapshot(path);
                if (snapshot == null) {
                    snapshot = DefaultFileSystemSnapshotter.this.snapshotAndCache(dirTree.getDir(), patterns);
                    return DefaultFileSystemSnapshotter.this.filterSnapshot(snapshot, EMPTY_PATTERN_SET);
                }
                return DefaultFileSystemSnapshotter.this.filterSnapshot(snapshot, patterns);
            }
        });
    }

    private FileSystemSnapshot snapshotFileTree(FileTreeInternal tree) {
        final FileSystemSnapshotBuilder builder = new FileSystemSnapshotBuilder(this.stringInterner);
        tree.visitTreeOrBackingFile(new FileVisitor(){

            public void visitDir(FileVisitDetails dirDetails) {
                builder.addDir(dirDetails.getFile(), dirDetails.getRelativePath().getSegments());
            }

            public void visitFile(FileVisitDetails fileDetails) {
                builder.addFile(fileDetails.getFile(), fileDetails.getRelativePath().getSegments(), this.regularFileSnapshot(fileDetails));
            }

            private RegularFileSnapshot regularFileSnapshot(FileVisitDetails fileDetails) {
                return new RegularFileSnapshot(DefaultFileSystemSnapshotter.this.stringInterner.intern(fileDetails.getFile().getAbsolutePath()), fileDetails.getName(), DefaultFileSystemSnapshotter.this.hasher.hash((FileTreeElement)fileDetails), fileDetails.getLastModified());
            }
        });
        return builder.build();
    }

    private FileSystemSnapshot filterSnapshot(FileSystemLocationSnapshot snapshot, PatternSet patterns) {
        if (snapshot.getType() == FileType.Missing) {
            return FileSystemSnapshot.EMPTY;
        }
        if (patterns.isEmpty()) {
            return snapshot;
        }
        Spec spec = patterns.getAsSpec();
        return FileSystemSnapshotFilter.filterSnapshot((Spec<FileTreeElement>)spec, snapshot, this.fileSystem);
    }

    private class InternableString {
        private String string;
        private boolean interned;

        public InternableString(String nonInternedString) {
            this.string = nonInternedString;
        }

        public String asInterned() {
            if (!this.interned) {
                this.interned = true;
                this.string = DefaultFileSystemSnapshotter.this.stringInterner.intern(this.string);
            }
            return this.string;
        }

        public String asNonInterned() {
            return this.string;
        }
    }

    private class FileCollectionLeafVisitorImpl
    implements FileCollectionLeafVisitor {
        private final List<FileSystemSnapshot> roots = new ArrayList<FileSystemSnapshot>();

        private FileCollectionLeafVisitorImpl() {
        }

        public void visitCollection(FileCollectionInternal fileCollection) {
            for (File file : fileCollection) {
                this.roots.add(DefaultFileSystemSnapshotter.this.snapshot(file));
            }
        }

        public void visitGenericFileTree(FileTreeInternal fileTree) {
            this.roots.add(DefaultFileSystemSnapshotter.this.snapshotFileTree(fileTree));
        }

        public void visitDirectoryTree(DirectoryFileTree directoryTree) {
            this.roots.add(DefaultFileSystemSnapshotter.this.snapshotDirectoryTree(directoryTree));
        }

        public List<FileSystemSnapshot> getRoots() {
            return this.roots;
        }
    }
}

