/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.InputStream;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.specs.Spec;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.file.FileType;
import org.gradle.internal.nativeintegration.filesystem.Chmod;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.gradle.internal.snapshot.RelativePathSegmentsTracker;
import org.gradle.util.GFileUtils;

public class FileSystemSnapshotFilter {
    private FileSystemSnapshotFilter() {
    }

    public static FileSystemSnapshot filterSnapshot(final Spec<FileTreeElement> spec, FileSystemSnapshot unfiltered, final FileSystem fileSystem) {
        final MerkleDirectorySnapshotBuilder builder = MerkleDirectorySnapshotBuilder.noSortingRequired();
        final MutableBoolean hasBeenFiltered = new MutableBoolean(false);
        unfiltered.accept(new FileSystemSnapshotVisitor(){
            private final RelativePathSegmentsTracker relativePathTracker = new RelativePathSegmentsTracker();

            @Override
            public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
                boolean root = this.relativePathTracker.isRoot();
                this.relativePathTracker.enter(directorySnapshot);
                if (root || spec.isSatisfiedBy((Object)new LogicalFileTreeElement(directorySnapshot, this.relativePathTracker.getRelativePath(), fileSystem))) {
                    builder.preVisitDirectory(directorySnapshot);
                    return true;
                }
                hasBeenFiltered.set(true);
                this.relativePathTracker.leave();
                return false;
            }

            @Override
            public void visit(FileSystemLocationSnapshot fileSnapshot) {
                boolean root = this.relativePathTracker.isRoot();
                this.relativePathTracker.enter(fileSnapshot);
                if (root || spec.isSatisfiedBy((Object)new LogicalFileTreeElement(fileSnapshot, this.relativePathTracker.getRelativePath(), fileSystem))) {
                    builder.visit(fileSnapshot);
                } else {
                    hasBeenFiltered.set(true);
                }
                this.relativePathTracker.leave();
            }

            @Override
            public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
                this.relativePathTracker.leave();
                builder.postVisitDirectory();
            }
        });
        if (builder.getResult() == null) {
            return FileSystemSnapshot.EMPTY;
        }
        return hasBeenFiltered.get() ? builder.getResult() : unfiltered;
    }

    private static class LogicalFileTreeElement
    extends AbstractFileTreeElement {
        private final Iterable<String> relativePathIterable;
        private final FileSystem fileSystem;
        private final FileSystemLocationSnapshot snapshot;
        private RelativePath relativePath;
        private File file;

        public LogicalFileTreeElement(FileSystemLocationSnapshot snapshot, Iterable<String> relativePathIterable, FileSystem fileSystem) {
            super((Chmod)fileSystem);
            this.snapshot = snapshot;
            this.relativePathIterable = relativePathIterable;
            this.fileSystem = fileSystem;
        }

        public String getDisplayName() {
            return "file '" + this.getFile() + "'";
        }

        public File getFile() {
            if (this.file == null) {
                this.file = new File(this.snapshot.getAbsolutePath());
            }
            return this.file;
        }

        public boolean isDirectory() {
            return this.snapshot.getType() == FileType.Directory;
        }

        public long getLastModified() {
            return this.getFile().lastModified();
        }

        public long getSize() {
            return this.getFile().length();
        }

        public InputStream open() {
            return GFileUtils.openInputStream((File)this.getFile());
        }

        public RelativePath getRelativePath() {
            if (this.relativePath == null) {
                this.relativePath = new RelativePath(!this.isDirectory(), (String[])Iterables.toArray(this.relativePathIterable, String.class));
            }
            return this.relativePath;
        }

        public int getMode() {
            return this.fileSystem.getUnixMode(this.getFile());
        }
    }
}

