/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junitplatform;

import java.util.List;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestEventAdapter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.TestIdentifier;

class VintageTestNameAdapter {
    private static final String VINTAGE_DESCRIPTOR_CLASS_NAME = "VintageTestDescriptor";
    private static final String VINTAGE_ENGINE = "[engine:junit-vintage]";

    VintageTestNameAdapter() {
    }

    static boolean isVintageDynamicLeafTest(TestIdentifier test) {
        return test.getParentId().isPresent() && !VINTAGE_ENGINE.equals(test.getParentId().get()) && VintageTestNameAdapter.isClassAndTest(test);
    }

    private static boolean isClassAndTest(TestIdentifier test) {
        return test.getSource().isPresent() && test.getSource().get() instanceof ClassSource && test.isTest();
    }

    static boolean isVintageDynamicTestClass(TestIdentifier test) {
        return test.getParentId().isPresent() && VINTAGE_ENGINE.equals(test.getParentId().get()) && VintageTestNameAdapter.isClassAndTest(test);
    }

    static boolean isVintageDynamicLeafTest(TestDescriptor test, TestSource source) {
        return test.isTest() && source instanceof ClassSource && VINTAGE_DESCRIPTOR_CLASS_NAME.equals(test.getClass().getSimpleName());
    }

    static String vintageDynamicClassName(UniqueId uniqueId) {
        return JUnitTestEventAdapter.className((String)VintageTestNameAdapter.vintageTestName(uniqueId));
    }

    static String vintageDynamicMethodName(UniqueId uniqueId) {
        return JUnitTestEventAdapter.methodName((String)VintageTestNameAdapter.vintageTestName(uniqueId));
    }

    private static String vintageTestName(UniqueId uniqueId) {
        List segments = uniqueId.getSegments();
        return ((UniqueId.Segment)segments.get(segments.size() - 1)).getValue();
    }
}

