/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.outcome.internal.archive;

import java.util.SortedSet;
import org.gradle.api.plugins.buildcomparison.compare.internal.BuildOutcomeComparisonResultSupport;
import org.gradle.api.plugins.buildcomparison.compare.internal.ComparisonResultType;
import org.gradle.api.plugins.buildcomparison.outcome.internal.BuildOutcomeAssociation;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.GeneratedArchiveBuildOutcome;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.entry.ArchiveEntryComparison;
import org.gradle.api.specs.Spec;
import org.gradle.util.CollectionUtils;

public class GeneratedArchiveBuildOutcomeComparisonResult
extends BuildOutcomeComparisonResultSupport<GeneratedArchiveBuildOutcome> {
    private final SortedSet<ArchiveEntryComparison> entryComparisons;

    public GeneratedArchiveBuildOutcomeComparisonResult(BuildOutcomeAssociation<GeneratedArchiveBuildOutcome> compared, SortedSet<ArchiveEntryComparison> entryComparisons) {
        super(compared);
        this.entryComparisons = entryComparisons;
    }

    public SortedSet<ArchiveEntryComparison> getEntryComparisons() {
        return this.entryComparisons;
    }

    public ComparisonResultType getComparisonResultType() {
        boolean targetFileExists;
        boolean sourceFileExists = ((GeneratedArchiveBuildOutcome)this.getCompared().getSource()).getArchiveFile() != null;
        boolean bl = targetFileExists = ((GeneratedArchiveBuildOutcome)this.getCompared().getTarget()).getArchiveFile() != null;
        if (sourceFileExists && targetFileExists) {
            if (CollectionUtils.every(this.getEntryComparisons(), (Spec)new Spec<ArchiveEntryComparison>(){

                public boolean isSatisfiedBy(ArchiveEntryComparison element) {
                    return element.getComparisonResultType() == ComparisonResultType.EQUAL;
                }
            })) {
                return ComparisonResultType.EQUAL;
            }
            return ComparisonResultType.UNEQUAL;
        }
        if (!sourceFileExists && !targetFileExists) {
            return ComparisonResultType.NON_EXISTENT;
        }
        if (!targetFileExists) {
            return ComparisonResultType.SOURCE_ONLY;
        }
        return ComparisonResultType.TARGET_ONLY;
    }

    @Override
    public boolean isOutcomesAreIdentical() {
        return this.getComparisonResultType().equals((Object)ComparisonResultType.EQUAL) || this.getComparisonResultType().equals((Object)ComparisonResultType.NON_EXISTENT);
    }
}

