/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.internal.file.collections.DefaultFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.tasks.LifecycleAwareTaskProperty;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.internal.file.PathToFileResolver;

public class CachingTaskInputFileCollection
extends DefaultConfigurableFileCollection
implements LifecycleAwareTaskProperty {
    private final String taskPath;
    private final FileResolver fileResolver;
    private boolean canCache;
    private ImmutableSet<File> cachedValue;

    public CachingTaskInputFileCollection(String taskPath, FileResolver fileResolver, TaskResolver taskResolver) {
        super((PathToFileResolver)fileResolver, taskResolver);
        this.taskPath = taskPath;
        this.fileResolver = fileResolver;
    }

    public void visitContents(FileCollectionResolveContext context) {
        if (this.canCache) {
            if (this.cachedValue == null) {
                DefaultFileCollectionResolveContext nested = new DefaultFileCollectionResolveContext(this.fileResolver);
                super.visitContents((FileCollectionResolveContext)nested);
                ImmutableSet.Builder files = ImmutableSet.builder();
                for (FileCollectionInternal fileCollection : nested.resolveAsFileCollections()) {
                    files.addAll((Iterable)fileCollection);
                }
                this.cachedValue = files.build();
            }
            context.add(this.cachedValue);
        } else {
            super.visitContents(context);
        }
    }

    @Override
    public void prepareValue() {
        this.canCache = true;
    }

    @Override
    public void cleanupValue() {
        this.canCache = false;
        this.cachedValue = null;
    }
}

