/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks.origin;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Set;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.OriginTaskExecutionMetadata;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginReader;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginWriter;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.remote.internal.inet.InetAddressFactory;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.internal.time.Clock;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskOutputOriginFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskOutputOriginFactory.class);
    private static final String BUILD_INVOCATION_ID_KEY = "buildInvocationId";
    public static final String TYPE_KEY = "type";
    public static final String PATH_KEY = "path";
    public static final String GRADLE_VERSION_KEY = "gradleVersion";
    public static final String CREATION_TIME_KEY = "creationTime";
    public static final String EXECUTION_TIME_KEY = "executionTime";
    public static final String ROOT_PATH_KEY = "rootPath";
    public static final String OPERATING_SYSTEM_KEY = "operatingSystem";
    public static final String HOST_NAME_KEY = "hostName";
    public static final String USER_NAME_KEY = "userName";
    private static final Set<String> METADATA_KEYS = ImmutableSet.of((Object)"buildInvocationId", (Object)"type", (Object)"path", (Object)"gradleVersion", (Object)"creationTime", (Object)"executionTime", (Object[])new String[]{"rootPath", "operatingSystem", "hostName", "userName"});
    private final InetAddressFactory inetAddressFactory;
    private final String userName;
    private final String operatingSystem;
    private final Clock clock;
    private final GradleVersion gradleVersion;
    private final BuildInvocationScopeId buildInvocationScopeId;
    private final File rootDir;

    public TaskOutputOriginFactory(Clock clock, InetAddressFactory inetAddressFactory, File rootDir, String userName, String operatingSystem, GradleVersion gradleVersion, BuildInvocationScopeId buildInvocationScopeId) {
        this.inetAddressFactory = inetAddressFactory;
        this.rootDir = rootDir;
        this.userName = userName;
        this.operatingSystem = operatingSystem;
        this.clock = clock;
        this.gradleVersion = gradleVersion;
        this.buildInvocationScopeId = buildInvocationScopeId;
    }

    public TaskOutputOriginWriter createWriter(final TaskInternal task, final long elapsedTime) {
        return new TaskOutputOriginWriter(){

            @Override
            public void execute(OutputStream outputStream) {
                Properties properties = new Properties();
                properties.setProperty(TaskOutputOriginFactory.BUILD_INVOCATION_ID_KEY, TaskOutputOriginFactory.this.buildInvocationScopeId.getId().asString());
                properties.setProperty(TaskOutputOriginFactory.TYPE_KEY, task.getClass().getCanonicalName());
                properties.setProperty(TaskOutputOriginFactory.PATH_KEY, task.getPath());
                properties.setProperty(TaskOutputOriginFactory.GRADLE_VERSION_KEY, TaskOutputOriginFactory.this.gradleVersion.getVersion());
                properties.setProperty(TaskOutputOriginFactory.CREATION_TIME_KEY, Long.toString(TaskOutputOriginFactory.this.clock.getCurrentTime()));
                properties.setProperty(TaskOutputOriginFactory.EXECUTION_TIME_KEY, Long.toString(elapsedTime));
                properties.setProperty(TaskOutputOriginFactory.ROOT_PATH_KEY, TaskOutputOriginFactory.this.rootDir.getAbsolutePath());
                properties.setProperty(TaskOutputOriginFactory.OPERATING_SYSTEM_KEY, TaskOutputOriginFactory.this.operatingSystem);
                properties.setProperty(TaskOutputOriginFactory.HOST_NAME_KEY, TaskOutputOriginFactory.this.inetAddressFactory.getHostname());
                properties.setProperty(TaskOutputOriginFactory.USER_NAME_KEY, TaskOutputOriginFactory.this.userName);
                try {
                    properties.store(outputStream, "Generated origin information");
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
                assert (METADATA_KEYS.containsAll(properties.stringPropertyNames())) : "Update expected metadata property list";
            }
        };
    }

    public TaskOutputOriginReader createReader(final TaskInternal task) {
        return new TaskOutputOriginReader(){

            @Override
            public OriginTaskExecutionMetadata execute(InputStream inputStream) {
                Properties properties = new Properties();
                try {
                    properties.load(inputStream);
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
                if (!properties.stringPropertyNames().containsAll(METADATA_KEYS)) {
                    throw new IllegalStateException("Cached result format error, corrupted origin metadata.");
                }
                LOGGER.info("Origin for {}: {}", (Object)task, (Object)properties);
                UniqueId originBuildInvocationId = UniqueId.from((String)properties.getProperty(TaskOutputOriginFactory.BUILD_INVOCATION_ID_KEY));
                long originalExecutionTime = Long.parseLong(properties.getProperty(TaskOutputOriginFactory.EXECUTION_TIME_KEY));
                return new OriginTaskExecutionMetadata(originBuildInvocationId, originalExecutionTime);
            }
        };
    }
}

