/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.reflect.ReflectionCache;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.TypedNotationConverter;
import org.gradle.internal.typeconversion.UnsupportedNotationException;
import org.gradle.util.ConfigureUtil;

public abstract class MapNotationConverter<T>
extends TypedNotationConverter<Map, T> {
    public MapNotationConverter() {
        super(Map.class);
    }

    @Override
    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("Maps");
    }

    @Override
    public T parseType(Map values) throws UnsupportedNotationException {
        Object result;
        HashMap<String, Object> mutableValues = new HashMap<String, Object>(values);
        TreeSet<String> missing = null;
        ConvertMethod convertMethod = null;
        Method method = null;
        while (method == null) {
            convertMethod = ConvertMethod.of(this.getClass());
            method = (Method)convertMethod.getMethod();
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] params = new Object[parameterTypes.length];
        String[] keyNames = convertMethod.keyNames;
        boolean[] optionals = convertMethod.optional;
        for (int i = 0; i < params.length; ++i) {
            String keyName = keyNames[i];
            boolean optional = optionals[i];
            Class<?> type = parameterTypes[i];
            String value = type == String.class ? this.get(mutableValues, keyName) : type.cast(mutableValues.get(keyName));
            if (!optional && value == null) {
                if (missing == null) {
                    missing = new TreeSet<String>();
                }
                missing.add(keyName);
            }
            mutableValues.remove(keyName);
            params[i] = value;
        }
        if (missing != null) {
            throw new InvalidUserDataException(String.format("Required keys %s are missing from map %s.", missing, values));
        }
        try {
            result = method.invoke((Object)this, params);
        }
        catch (IllegalAccessException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.unwrapAndRethrow((InvocationTargetException)e);
        }
        ConfigureUtil.configureByMap(mutableValues, (Object)result);
        return (T)result;
    }

    protected String get(Map<String, Object> args, String key) {
        String str;
        Object value = args.get(key);
        String string = str = value != null ? value.toString() : null;
        if (str != null && str.length() == 0) {
            return null;
        }
        return str;
    }

    private static class ConvertMethod
    extends ReflectionCache.CachedInvokable<Method> {
        private static final ConvertMethodCache CONVERT_METHODS = new ConvertMethodCache();
        public static final Class[] EMPTY = new Class[0];
        private final String[] keyNames;
        private final boolean[] optional;

        private ConvertMethod(Method method, String[] keyNames, boolean[] optional) {
            super((Object)method);
            this.keyNames = keyNames;
            this.optional = optional;
        }

        public static synchronized ConvertMethod of(Class clazz) {
            return (ConvertMethod)CONVERT_METHODS.get(clazz, EMPTY);
        }
    }

    private static class ConvertMethodCache
    extends ReflectionCache<ConvertMethod> {
        private ConvertMethodCache() {
        }

        protected ConvertMethod create(Class<?> key, Class<?>[] params) {
            Method convertMethod = ConvertMethodCache.findConvertMethod(key);
            Annotation[][] parameterAnnotations = convertMethod.getParameterAnnotations();
            String[] keyNames = new String[parameterAnnotations.length];
            boolean[] optional = new boolean[parameterAnnotations.length];
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                Annotation[] annotations = parameterAnnotations[i];
                keyNames[i] = ConvertMethodCache.keyName(annotations);
                optional[i] = ConvertMethodCache.optional(annotations);
            }
            return new ConvertMethod(convertMethod, keyNames, optional);
        }

        private static Method findConvertMethod(Class clazz) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals("parseMap")) continue;
                method.setAccessible(true);
                return method;
            }
            throw new UnsupportedOperationException(String.format("No parseMap() method found on class %s.", clazz.getSimpleName()));
        }

        private static boolean optional(Annotation[] annotations) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof Optional)) continue;
                return true;
            }
            return false;
        }

        private static String keyName(Annotation[] annotations) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof MapKey)) continue;
                return ((MapKey)annotation).value();
            }
            throw new UnsupportedOperationException("No @Key annotation on parameter of parseMap() method");
        }
    }
}

