/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing;

import com.google.common.util.concurrent.Callables;
import groovy.lang.Closure;
import java.io.File;
import java.util.Date;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Buildable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.plugins.signing.SignatureSpec;
import org.gradle.plugins.signing.signatory.Signatory;
import org.gradle.plugins.signing.type.SignatureType;
import org.gradle.util.GUtil;

public class Signature
extends AbstractPublishArtifact {
    private SignatureSpec signatureSpec;
    private Buildable source;
    private String name;
    private String extension;
    private String type;
    private String classifier;
    private Date date;
    private Callable<File> toSignGenerator;
    private Callable<String> classifierGenerator;
    private Callable<String> nameGenerator;

    public Signature(final PublishArtifact toSign, SignatureSpec signatureSpec, Object ... tasks) {
        this((Buildable)toSign, new Callable<File>(){

            @Override
            public File call() {
                return toSign.getFile();
            }
        }, new Callable<String>(){

            @Override
            public String call() {
                return toSign.getClassifier();
            }
        }, new Callable<String>(){

            @Override
            public String call() {
                return toSign.getName();
            }
        }, signatureSpec, tasks);
    }

    Signature(Buildable source, Callable<File> toSign, Callable<String> classifier, Callable<String> name, SignatureSpec signatureSpec, Object ... tasks) {
        super(tasks);
        this.init(toSign, classifier, name, signatureSpec);
        this.source = source;
    }

    public Signature(File toSign, SignatureSpec signatureSpec, Object ... tasks) {
        super(tasks);
        this.init(Callables.returning((Object)toSign), null, null, signatureSpec);
    }

    public Signature(File toSign, String classifier, SignatureSpec signatureSpec, Object ... tasks) {
        super(tasks);
        this.init(Callables.returning((Object)toSign), Callables.returning((Object)classifier), null, signatureSpec);
    }

    public Signature(Closure<File> toSign, Closure<String> classifier, SignatureSpec signatureSpec, Object ... tasks) {
        super(tasks);
        this.toSignGenerator = toSign;
        this.classifierGenerator = classifier;
        this.signatureSpec = signatureSpec;
    }

    public Signature(Callable<File> toSign, Callable<String> classifier, SignatureSpec signatureSpec, Object ... tasks) {
        super(tasks);
        this.toSignGenerator = toSign;
        this.classifierGenerator = classifier;
        this.signatureSpec = signatureSpec;
    }

    private void init(Callable<File> toSign, Callable<String> classifier, Callable<String> name, SignatureSpec signatureSpec) {
        this.toSignGenerator = toSign;
        this.classifierGenerator = classifier;
        this.nameGenerator = name;
        this.signatureSpec = signatureSpec;
    }

    public File getToSign() {
        File toSign = (File)GUtil.uncheckedCall(this.toSignGenerator);
        return toSign != null ? toSign : null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name != null ? this.name : this.defaultName();
    }

    @Nullable
    private String defaultName() {
        return this.nameGenerator != null ? (String)GUtil.uncheckedCall(this.nameGenerator) : this.fileName();
    }

    @Nullable
    private String fileName() {
        File file = this.getFile();
        return file != null ? file.getName() : null;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getExtension() {
        return this.extension != null ? this.extension : this.signatureTypeExtension();
    }

    @Nullable
    private String signatureTypeExtension() {
        SignatureType signatureType = this.getSignatureType();
        return signatureType != null ? signatureType.getExtension() : null;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type != null ? this.type : this.defaultType();
    }

    @Nullable
    private String defaultType() {
        File toSign = this.getToSign();
        SignatureType signatureType = this.getSignatureType();
        return toSign != null && signatureType != null ? signatureType.combinedExtension(toSign) : null;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getClassifier() {
        return this.classifier != null ? this.classifier : (String)GUtil.uncheckedCall(this.classifierGenerator);
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date != null ? this.date : this.defaultDate();
    }

    @Nullable
    private Date defaultDate() {
        File file = this.getFile();
        if (file == null) {
            return null;
        }
        long modified = file.lastModified();
        if (modified == 0L) {
            return null;
        }
        return new Date(modified);
    }

    public File getFile() {
        File toSign = this.getToSign();
        SignatureType signatureType = this.getSignatureType();
        return toSign != null && signatureType != null ? signatureType.fileFor(toSign) : null;
    }

    public Signatory getSignatory() {
        return this.signatureSpec.getSignatory();
    }

    public SignatureType getSignatureType() {
        return this.signatureSpec.getSignatureType();
    }

    public void setSignatureSpec(SignatureSpec signatureSpec) {
        this.signatureSpec = signatureSpec;
    }

    public SignatureSpec getSignatureSpec() {
        return this.signatureSpec;
    }

    Buildable getSource() {
        return this.source;
    }

    public void generate() {
        File toSign = this.getToSign();
        if (toSign == null) {
            if (this.signatureSpec.isRequired()) {
                throw new InvalidUserDataException("Unable to generate signature as the file to sign has not been specified");
            }
            return;
        }
        Signatory signatory = this.getSignatory();
        if (signatory == null) {
            if (this.signatureSpec.isRequired()) {
                throw new InvalidUserDataException("Unable to generate signature for '" + String.valueOf(toSign) + "' as no signatory is available to sign");
            }
            return;
        }
        SignatureType signatureType = this.getSignatureType();
        if (signatureType == null) {
            if (this.signatureSpec.isRequired()) {
                throw new InvalidUserDataException("Unable to generate signature for '" + String.valueOf(toSign) + "' as no signature type has been configured");
            }
            return;
        }
        signatureType.sign(signatory, toSign);
    }
}

