/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Plugin;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.RepositoryPolicy;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.repository.WorkspaceRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CacheUtils {
    CacheUtils() {
    }

    public static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }

    public static int repositoriesHashCode(List<RemoteRepository> repositories) {
        int result = 17;
        for (RemoteRepository repository : repositories) {
            result = 31 * result + CacheUtils.repositoryHashCode(repository);
        }
        return result;
    }

    private static int repositoryHashCode(RemoteRepository repository) {
        int result = 17;
        result = 31 * result + CacheUtils.hash(repository.getUrl());
        return result;
    }

    private static boolean repositoryEquals(RemoteRepository r1, RemoteRepository r2) {
        if (r1 == r2) {
            return true;
        }
        return CacheUtils.eq(r1.getId(), r2.getId()) && CacheUtils.eq(r1.getUrl(), r2.getUrl()) && CacheUtils.policyEquals(r1.getPolicy(false), r2.getPolicy(false)) && CacheUtils.policyEquals(r1.getPolicy(true), r2.getPolicy(true));
    }

    private static boolean policyEquals(RepositoryPolicy p1, RepositoryPolicy p2) {
        if (p1 == p2) {
            return true;
        }
        return p1.isEnabled() == p2.isEnabled() && CacheUtils.eq(p1.getChecksumPolicy(), p2.getChecksumPolicy());
    }

    public static boolean repositoriesEquals(List<RemoteRepository> r1, List<RemoteRepository> r2) {
        if (r1.size() != r2.size()) {
            return false;
        }
        Iterator<RemoteRepository> it1 = r1.iterator();
        Iterator<RemoteRepository> it2 = r2.iterator();
        while (it1.hasNext()) {
            if (CacheUtils.repositoryEquals(it1.next(), it2.next())) continue;
            return false;
        }
        return true;
    }

    public static int pluginHashCode(Plugin plugin) {
        int hash = 17;
        hash = hash * 31 + CacheUtils.hash(plugin.getGroupId());
        hash = hash * 31 + CacheUtils.hash(plugin.getArtifactId());
        hash = hash * 31 + CacheUtils.hash(plugin.getVersion());
        hash = hash * 31 + (plugin.isExtensions() ? 1 : 0);
        for (Dependency dependency : plugin.getDependencies()) {
            hash = hash * 31 + CacheUtils.hash(dependency.getGroupId());
            hash = hash * 31 + CacheUtils.hash(dependency.getArtifactId());
            hash = hash * 31 + CacheUtils.hash(dependency.getVersion());
            hash = hash * 31 + CacheUtils.hash(dependency.getType());
            hash = hash * 31 + CacheUtils.hash(dependency.getClassifier());
            hash = hash * 31 + CacheUtils.hash(dependency.getScope());
            for (Exclusion exclusion : dependency.getExclusions()) {
                hash = hash * 31 + CacheUtils.hash(exclusion.getGroupId());
                hash = hash * 31 + CacheUtils.hash(exclusion.getArtifactId());
            }
        }
        return hash;
    }

    public static boolean pluginEquals(Plugin a, Plugin b) {
        return CacheUtils.eq(a.getArtifactId(), b.getArtifactId()) && CacheUtils.eq(a.getGroupId(), b.getGroupId()) && CacheUtils.eq(a.getVersion(), b.getVersion()) && a.isExtensions() == b.isExtensions() && CacheUtils.dependenciesEquals(a.getDependencies(), b.getDependencies());
    }

    private static boolean dependenciesEquals(List<Dependency> a, List<Dependency> b) {
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<Dependency> aI = a.iterator();
        Iterator<Dependency> bI = b.iterator();
        while (aI.hasNext()) {
            boolean r;
            Dependency aD = aI.next();
            Dependency bD = bI.next();
            boolean bl = r = CacheUtils.eq(aD.getGroupId(), bD.getGroupId()) && CacheUtils.eq(aD.getArtifactId(), bD.getArtifactId()) && CacheUtils.eq(aD.getVersion(), bD.getVersion()) && CacheUtils.eq(aD.getType(), bD.getType()) && CacheUtils.eq(aD.getClassifier(), bD.getClassifier()) && CacheUtils.eq(aD.getScope(), bD.getScope());
            if (r &= CacheUtils.exclusionsEquals(aD.getExclusions(), bD.getExclusions())) continue;
            return false;
        }
        return true;
    }

    private static boolean exclusionsEquals(List<Exclusion> a, List<Exclusion> b) {
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<Exclusion> aI = a.iterator();
        Iterator<Exclusion> bI = b.iterator();
        while (aI.hasNext()) {
            Exclusion aD = aI.next();
            Exclusion bD = bI.next();
            boolean r = CacheUtils.eq(aD.getGroupId(), bD.getGroupId()) && CacheUtils.eq(aD.getArtifactId(), bD.getArtifactId());
            if (r) continue;
            return false;
        }
        return true;
    }

    public static WorkspaceRepository getWorkspace(RepositorySystemSession session) {
        WorkspaceReader reader = session.getWorkspaceReader();
        return reader != null ? reader.getRepository() : null;
    }
}

