/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.InternalAction;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.composite.internal.BuildStateListener;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.internal.build.AbstractBuildState;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.NestedBuildState;
import org.gradle.internal.build.StandAloneNestedBuild;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.invocation.GradleBuildController;
import org.gradle.util.Path;

class DefaultNestedBuild
extends AbstractBuildState
implements StandAloneNestedBuild,
Stoppable {
    private final Path identityPath;
    private final BuildState owner;
    private final BuildStateListener buildStateListener;
    private final BuildIdentifier buildIdentifier;
    private final BuildDefinition buildDefinition;
    private final GradleLauncher gradleLauncher;
    private SettingsInternal settings;

    DefaultNestedBuild(BuildIdentifier buildIdentifier, Path identityPath, BuildDefinition buildDefinition, BuildState owner, BuildStateListener buildStateListener) {
        this.buildIdentifier = buildIdentifier;
        this.identityPath = identityPath;
        this.buildDefinition = buildDefinition;
        this.owner = owner;
        this.buildStateListener = buildStateListener;
        this.gradleLauncher = owner.getNestedBuildFactory().nestedInstance(buildDefinition, (NestedBuildState)this);
    }

    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    public Path getIdentityPath() {
        return this.identityPath;
    }

    public boolean isImplicitBuild() {
        return true;
    }

    public void stop() {
        this.gradleLauncher.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(Transformer<T, ? super BuildController> buildAction) {
        GradleBuildController buildController = new GradleBuildController(this.gradleLauncher);
        try {
            this.gradleLauncher.getGradle().setIdentityPath(this.getCurrentPrefixForProjectsInChildBuilds());
            final GradleInternal gradle = buildController.getGradle();
            gradle.rootProject((Action)new InternalAction<Project>(){

                public void execute(Project rootProject) {
                    DefaultNestedBuild.this.settings = gradle.getSettings();
                    DefaultNestedBuild.this.buildStateListener.projectsKnown((BuildState)DefaultNestedBuild.this);
                }
            });
            Object object = buildAction.transform((Object)buildController);
            return (T)object;
        }
        finally {
            buildController.stop();
        }
    }

    public SettingsInternal getLoadedSettings() {
        if (this.settings == null) {
            throw new IllegalStateException("Settings not loaded yet.");
        }
        return this.settings;
    }

    public NestedBuildFactory getNestedBuildFactory() {
        return (NestedBuildFactory)this.gradleLauncher.getGradle().getServices().get(NestedBuildFactory.class);
    }

    public Path getCurrentPrefixForProjectsInChildBuilds() {
        return this.owner.getCurrentPrefixForProjectsInChildBuilds().child(this.buildDefinition.getName());
    }

    public Path getIdentityPathForProject(Path projectPath) {
        return ((ProjectInternal)this.getLoadedSettings().getGradle().getRootProject().getProjectRegistry().getProject(projectPath.getPath())).getIdentityPath();
    }
}

