/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.DebugOptions;
import org.gradle.api.tasks.compile.ForkOptions;

public class MinimalJavaCompileOptions
implements Serializable {
    private List<File> sourcepath;
    private List<String> compilerArgs;
    private String encoding;
    private String bootClasspath;
    private String extensionDirs;
    private ForkOptions forkOptions;
    private DebugOptions debugOptions;
    private boolean debug;
    private boolean deprecation;
    private boolean failOnError;
    private boolean listFiles;
    private boolean verbose;
    private boolean warnings;
    private File annotationProcessorGeneratedSourcesDirectory;
    private final File headerOutputDirectory;

    public MinimalJavaCompileOptions(CompileOptions compileOptions) {
        FileCollection sourcepath = compileOptions.getSourcepath();
        this.sourcepath = sourcepath == null ? null : ImmutableList.copyOf((Collection)sourcepath.getFiles());
        this.compilerArgs = Lists.newArrayList(compileOptions.getAllCompilerArgs());
        this.encoding = compileOptions.getEncoding();
        this.bootClasspath = MinimalJavaCompileOptions.getAsPath(compileOptions.getBootstrapClasspath());
        this.extensionDirs = compileOptions.getExtensionDirs();
        this.forkOptions = compileOptions.getForkOptions();
        this.debugOptions = compileOptions.getDebugOptions();
        this.debug = compileOptions.isDebug();
        this.deprecation = compileOptions.isDeprecation();
        this.failOnError = compileOptions.isFailOnError();
        this.listFiles = compileOptions.isListFiles();
        this.verbose = compileOptions.isVerbose();
        this.warnings = compileOptions.isWarnings();
        this.annotationProcessorGeneratedSourcesDirectory = compileOptions.getAnnotationProcessorGeneratedSourcesDirectory();
        DirectoryProperty headerOutputDirectory = compileOptions.getHeaderOutputDirectory();
        this.headerOutputDirectory = headerOutputDirectory.isPresent() ? ((Directory)headerOutputDirectory.get()).getAsFile() : null;
    }

    @Nullable
    private static String getAsPath(@Nullable FileCollection files) {
        return files == null ? null : files.getAsPath();
    }

    public List<File> getSourcepath() {
        return this.sourcepath;
    }

    public void setSourcepath(List<File> sourcepath) {
        this.sourcepath = sourcepath;
    }

    public List<String> getCompilerArgs() {
        return this.compilerArgs;
    }

    public void setCompilerArgs(List<String> compilerArgs) {
        this.compilerArgs = compilerArgs;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getBootClasspath() {
        return this.bootClasspath;
    }

    public void setBootClasspath(String bootClasspath) {
        this.bootClasspath = bootClasspath;
    }

    public String getExtensionDirs() {
        return this.extensionDirs;
    }

    public void setExtensionDirs(String extensionDirs) {
        this.extensionDirs = extensionDirs;
    }

    public ForkOptions getForkOptions() {
        return this.forkOptions;
    }

    public void setForkOptions(ForkOptions forkOptions) {
        this.forkOptions = forkOptions;
    }

    public DebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    public void setDebugOptions(DebugOptions debugOptions) {
        this.debugOptions = debugOptions;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDeprecation() {
        return this.deprecation;
    }

    public void setDeprecation(boolean deprecation) {
        this.deprecation = deprecation;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean isListFiles() {
        return this.listFiles;
    }

    public void setListFiles(boolean listFiles) {
        this.listFiles = listFiles;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isWarnings() {
        return this.warnings;
    }

    public void setWarnings(boolean warnings) {
        this.warnings = warnings;
    }

    public File getAnnotationProcessorGeneratedSourcesDirectory() {
        return this.annotationProcessorGeneratedSourcesDirectory;
    }

    public void setAnnotationProcessorGeneratedSourcesDirectory(File annotationProcessorGeneratedSourcesDirectory) {
        this.annotationProcessorGeneratedSourcesDirectory = annotationProcessorGeneratedSourcesDirectory;
    }

    public File getHeaderOutputDirectory() {
        return this.headerOutputDirectory;
    }
}

