/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiIfStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiKeyword;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiIfStatementImpl
extends CompositePsiElement
implements PsiIfStatement,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiIfStatementImpl");

    public PsiIfStatementImpl() {
        super(IF_STATEMENT);
    }

    @Override
    public PsiExpression getCondition() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(32);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        ASTNode elseKeyword;
        if (child == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(0);
        }
        if (child == this.getElseBranch() && (elseKeyword = this.findChildByRole(31)) != null) {
            super.deleteChildInternal(elseKeyword);
        }
        super.deleteChildInternal(child);
    }

    @Override
    public PsiStatement getThenBranch() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(33);
    }

    @Override
    public PsiStatement getElseBranch() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(34);
    }

    @Override
    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(24);
    }

    @Override
    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(25);
    }

    @Override
    public PsiKeyword getElseElement() {
        return (PsiKeyword)this.findChildByRoleAsPsiElement(31);
    }

    @Override
    public void setElseBranch(@NotNull PsiStatement statement2) throws IncorrectOperationException {
        PsiKeyword elseElement;
        PsiStatement elseBranch;
        if (statement2 == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(1);
        }
        if ((elseBranch = this.getElseBranch()) != null) {
            elseBranch.delete();
        }
        if ((elseElement = this.getElseElement()) != null) {
            elseElement.delete();
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
        PsiIfStatement ifStatement = (PsiIfStatement)elementFactory.createStatementFromText("if (true) {} else {}", this);
        ifStatement.getElseBranch().replace(statement2);
        this.addRange(ifStatement.getElseElement(), ifStatement.getLastChild());
    }

    @Override
    public void setThenBranch(@NotNull PsiStatement statement2) throws IncorrectOperationException {
        PsiStatement thenBranch;
        if (statement2 == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(2);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
        ASTNode keyword = this.findChildByRole(30);
        LOG.assertTrue(keyword != null);
        PsiIfStatement ifStatementPattern = (PsiIfStatement)elementFactory.createStatementFromText("if (){}", this);
        if (this.getLParenth() == null) {
            this.addAfter(ifStatementPattern.getLParenth(), keyword.getPsi());
        }
        if (this.getRParenth() == null) {
            PsiElement anchor2 = this.getCondition() == null ? this.getLParenth() : this.getCondition();
            this.addAfter(ifStatementPattern.getRParenth(), anchor2);
        }
        if ((thenBranch = this.getThenBranch()) == null) {
            this.addAfter(statement2, this.getRParenth());
        } else {
            thenBranch.replace(statement2);
        }
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 30: {
                return this.findChildByType(IF_KEYWORD);
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 32: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 33: {
                return PsiImplUtil.findStatementChild(this);
            }
            case 31: {
                return this.findChildByType(ELSE_KEYWORD);
            }
            case 34: 
        }
        ASTNode elseKeyword = this.findChildByRole(31);
        if (elseKeyword == null) {
            return null;
        }
        for (ASTNode child = elseKeyword.getTreeNext(); child != null; child = child.getTreeNext()) {
            if (!(child.getPsi() instanceof PsiStatement)) continue;
            return child;
        }
        return null;
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == IF_KEYWORD) {
            return 30;
        }
        if (i == ELSE_KEYWORD) {
            return 31;
        }
        if (i == LPARENTH) {
            return 24;
        }
        if (i == RPARENTH) {
            return 25;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 32;
        }
        if (child.getPsi() instanceof PsiStatement) {
            if (this.findChildByRoleAsPsiElement(33) == child) {
                return 33;
            }
            return 34;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(4);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitIfStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiIfStatement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiIfStatementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteChildInternal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setElseBranch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setThenBranch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildRole";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

