/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractModuleExclusion;

abstract class AbstractCompositeExclusion
extends AbstractModuleExclusion {
    private int hashCode = -1;

    AbstractCompositeExclusion() {
    }

    abstract Collection<AbstractModuleExclusion> getFilters();

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(this.getClass().getSimpleName());
        for (AbstractModuleExclusion spec : this.getFilters()) {
            builder.append(' ');
            builder.append(spec);
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    protected boolean doExcludesSameModulesAs(AbstractModuleExclusion other) {
        AbstractCompositeExclusion spec = (AbstractCompositeExclusion)other;
        Collection<AbstractModuleExclusion> thisFilters = this.getFilters();
        Collection<AbstractModuleExclusion> otherFilters = spec.getFilters();
        HashSet miss1 = Sets.newHashSetWithExpectedSize((int)thisFilters.size());
        HashSet miss2 = Sets.newHashSetWithExpectedSize((int)otherFilters.size());
        for (AbstractModuleExclusion exclusion : thisFilters) {
            if (otherFilters.contains(exclusion)) continue;
            miss1.add(exclusion);
        }
        for (AbstractModuleExclusion otherFilter : otherFilters) {
            if (thisFilters.contains(otherFilter)) continue;
            miss2.add(otherFilter);
        }
        return miss1.isEmpty() && miss2.isEmpty() || this.implies(miss1, miss2) && this.implies(miss2, miss1);
    }

    @Override
    protected boolean doEquals(Object obj) {
        AbstractCompositeExclusion other = (AbstractCompositeExclusion)obj;
        return this.hashCode() == other.hashCode() && this.getFilters().equals(other.getFilters());
    }

    @Override
    protected int doHashCode() {
        if (this.hashCode != -1) {
            return this.hashCode;
        }
        this.hashCode = this.getFilters().hashCode();
        return this.hashCode;
    }

    protected boolean implies(Set<AbstractModuleExclusion> miss1, Set<AbstractModuleExclusion> miss2) {
        if (miss1.isEmpty() || miss2.isEmpty()) {
            return false;
        }
        for (AbstractModuleExclusion thisSpec : miss1) {
            boolean found = false;
            for (AbstractModuleExclusion otherSpec : miss2) {
                if (!thisSpec.excludesSameModulesAs(otherSpec)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

