/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CapabilitiesConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictResolutionResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.PotentialConflict;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.PotentialConflictFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.CapabilityInternal;

public class DefaultCapabilitiesConflictHandler
implements CapabilitiesConflictHandler {
    private final List<CapabilitiesConflictHandler.Resolver> resolvers = Lists.newArrayListWithExpectedSize((int)2);
    private final Map<String, Set<ComponentState>> capabilityWithoutVersionToComponents = Maps.newHashMap();
    private final Deque<CapabilityConflict> conflicts = new ArrayDeque<CapabilityConflict>();

    @Override
    public PotentialConflict registerCandidate(CapabilitiesConflictHandler.Candidate candidate) {
        CapabilityInternal capability = (CapabilityInternal)candidate.getCapability();
        String group = capability.getGroup();
        String name = capability.getName();
        Set<ComponentState> components = this.findComponentsFor(capability);
        components.addAll(candidate.getImplicitCapabilityProviders());
        if (components.add(candidate.getComponent()) && components.size() > 1) {
            final ArrayList candidatesForConflict = Lists.newArrayListWithCapacity((int)components.size());
            for (ComponentState component : components) {
                if (!component.isCandidateForConflictResolution()) continue;
                candidatesForConflict.add(component);
            }
            if (candidatesForConflict.size() > 1) {
                PotentialConflict conflict = new PotentialConflict(){

                    @Override
                    public void withParticipatingModules(Action<ModuleIdentifier> action) {
                        for (ComponentState component : candidatesForConflict) {
                            action.execute((Object)component.getId().getModule());
                        }
                    }

                    @Override
                    public boolean conflictExists() {
                        return true;
                    }
                };
                this.conflicts.add(new CapabilityConflict(group, name, candidatesForConflict));
                return conflict;
            }
        }
        return PotentialConflictFactory.noConflict();
    }

    private Set<ComponentState> findComponentsFor(CapabilityInternal capability) {
        String capabilityId = capability.getCapabilityId();
        LinkedHashSet componentStates = this.capabilityWithoutVersionToComponents.get(capabilityId);
        if (componentStates == null) {
            componentStates = Sets.newLinkedHashSet();
            this.capabilityWithoutVersionToComponents.put(capabilityId, componentStates);
        }
        return componentStates;
    }

    @Override
    public boolean hasConflicts() {
        return !this.conflicts.isEmpty();
    }

    @Override
    public void resolveNextConflict(Action<ConflictResolutionResult> resolutionAction) {
        CapabilityConflict conflict = this.conflicts.poll();
        Details details = new Details(conflict);
        for (CapabilitiesConflictHandler.Resolver resolver : this.resolvers) {
            resolver.resolve(details);
            if (!details.hasResult()) continue;
            resolutionAction.execute((Object)details);
            CapabilityInternal capability = (CapabilityInternal)conflict.descriptors.iterator().next();
            details.getSelected().addCause(VersionSelectionReasons.CONFLICT_RESOLUTION.withReason((Describable)Describables.of((Object)"latest version of capability", (Object)capability.getCapabilityId())));
            return;
        }
        throw new RuntimeException("Cannot choose between " + DefaultCapabilitiesConflictHandler.prettifyCandidates(conflict) + " because they provide the same capability: " + DefaultCapabilitiesConflictHandler.prettifyCapabilities(conflict));
    }

    @Override
    public void registerResolver(CapabilitiesConflictHandler.Resolver conflictResolver) {
        this.resolvers.add(conflictResolver);
    }

    public static CapabilitiesConflictHandler.Candidate candidate(ComponentState component, Capability capability, Collection<ComponentState> implicitCapabilityProviders) {
        return new Candidate(component, capability, implicitCapabilityProviders);
    }

    private static String prettifyCapabilities(CapabilityConflict conflict) {
        TreeSet capabilities = Sets.newTreeSet();
        for (Capability c : conflict.descriptors) {
            capabilities.add(c.getGroup() + ":" + c.getName() + ":" + c.getVersion());
        }
        return Joiner.on((String)", ").join((Iterable)capabilities);
    }

    private static String prettifyCandidates(CapabilityConflict conflict) {
        TreeSet candidates = Sets.newTreeSet();
        for (ComponentState component : conflict.components) {
            candidates.add(component.getId().toString());
        }
        return Joiner.on((String)" and ").join((Iterable)candidates);
    }

    private static class CapabilityConflict {
        private final Collection<ComponentState> components;
        private final Set<Capability> descriptors;

        private CapabilityConflict(String group, String name, Collection<ComponentState> components) {
            this.components = components;
            ImmutableSet.Builder builder = new ImmutableSet.Builder();
            for (ComponentState component : components) {
                Capability capability = component.findCapability(group, name);
                if (capability == null) continue;
                builder.add((Object)capability);
            }
            this.descriptors = builder.build();
        }
    }

    private static class Details
    implements CapabilitiesConflictHandler.ResolutionDetails {
        private final CapabilityConflict conflict;
        private final Set<ComponentState> evicted = Sets.newHashSet();
        private ComponentState selected;

        private Details(CapabilityConflict conflict) {
            this.conflict = conflict;
        }

        @Override
        public Collection<? extends Capability> getCapabilityVersions() {
            return this.conflict.descriptors;
        }

        @Override
        public Collection<? extends CapabilitiesConflictHandler.CandidateDetails> getCandidates(Capability capability) {
            ImmutableList.Builder candidates = new ImmutableList.Builder();
            String group = capability.getGroup();
            String name = capability.getName();
            String version = capability.getVersion();
            for (final ComponentState component : this.conflict.components) {
                Capability componentCapability;
                if (this.evicted.contains(component) || (componentCapability = component.findCapability(group, name)) == null || !componentCapability.getVersion().equals(version)) continue;
                candidates.add((Object)new CapabilitiesConflictHandler.CandidateDetails(){

                    @Override
                    public ComponentIdentifier getId() {
                        return component.getComponentId();
                    }

                    @Override
                    public void evict() {
                        evicted.add(component);
                    }

                    @Override
                    public void select() {
                        selected = component;
                    }
                });
            }
            return candidates.build();
        }

        @Override
        public void withParticipatingModules(Action<? super ModuleIdentifier> action) {
            HashSet seen = Sets.newHashSet();
            for (ComponentState component : this.conflict.components) {
                ModuleIdentifier module = component.getId().getModule();
                if (!seen.add(module)) continue;
                action.execute((Object)module);
            }
        }

        @Override
        public boolean hasResult() {
            return this.selected != null;
        }

        public ComponentState getSelected() {
            return this.selected;
        }
    }

    private static class Candidate
    implements CapabilitiesConflictHandler.Candidate {
        private final ComponentState component;
        private final Capability capability;
        private final Collection<ComponentState> implicitCapabilityProviders;

        public Candidate(ComponentState component, Capability capability, Collection<ComponentState> implicitCapabilityProviders) {
            this.component = component;
            this.capability = capability;
            this.implicitCapabilityProviders = implicitCapabilityProviders;
        }

        @Override
        public ComponentState getComponent() {
            return this.component;
        }

        @Override
        public Capability getCapability() {
            return this.capability;
        }

        @Override
        public Collection<ComponentState> getImplicitCapabilityProviders() {
            return this.implicitCapabilityProviders;
        }
    }
}

