/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.artifacts.transform.DefaultArtifactTransformDependency;
import org.gradle.api.internal.artifacts.transform.TransformNode;
import org.gradle.api.internal.artifacts.transform.TransformNodeFactory;
import org.gradle.execution.plan.DependencyResolver;
import org.gradle.execution.plan.Node;

public class TransformNodeDependencyResolver
implements DependencyResolver {
    private final TransformNodeFactory transformNodeFactory;

    public TransformNodeDependencyResolver(TransformNodeFactory transformNodeFactory) {
        this.transformNodeFactory = transformNodeFactory;
    }

    public boolean resolve(Task task, Object node, Action<? super Node> resolveAction) {
        if (node instanceof DefaultArtifactTransformDependency) {
            DefaultArtifactTransformDependency transformation = (DefaultArtifactTransformDependency)node;
            Collection<TransformNode> transforms = this.transformNodeFactory.getOrCreate(transformation.getArtifacts(), transformation.getTransform());
            for (TransformNode transformNode : transforms) {
                resolveAction.execute((Object)transformNode);
            }
            return true;
        }
        return false;
    }

    public boolean attachActionTo(Task task, Action<? super Task> action) {
        return false;
    }
}

