/*
 * Decompiled with CFR 0.152.
 */
package jspecview.java;

import java.awt.Component;
import java.io.File;
import javajs.api.GenericFileInterface;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jspecview.api.JSVFileHelper;
import jspecview.common.ExportType;
import jspecview.common.JSViewer;
import jspecview.java.AwtDialogFileFilter;
import jspecview.java.AwtFile;

public class AwtFileHelper
implements JSVFileHelper {
    public String dirLastOpened;
    public boolean useDirLastOpened;
    public boolean useDirLastExported;
    public String dirLastExported;
    private JFileChooser fc;
    private JSViewer vwr;

    @Override
    public AwtFileHelper set(JSViewer viewer) {
        this.vwr = viewer;
        return this;
    }

    @Override
    public void setFileChooser(ExportType imode) {
        if (this.fc == null) {
            this.fc = new JFileChooser();
        }
        AwtDialogFileFilter filter = new AwtDialogFileFilter();
        this.fc.resetChoosableFileFilters();
        switch (imode) {
            case UNK: {
                filter = new AwtDialogFileFilter();
                filter.addExtension("xml");
                filter.addExtension("aml");
                filter.addExtension("cml");
                filter.setDescription("CML/XML Files");
                this.fc.setFileFilter(filter);
                filter = new AwtDialogFileFilter();
                filter.addExtension("jdx");
                filter.addExtension("dx");
                filter.setDescription("JCAMP-DX Files");
                this.fc.setFileFilter(filter);
                break;
            }
            case XY: 
            case FIX: 
            case PAC: 
            case SQZ: 
            case DIF: 
            case DIFDUP: 
            case SOURCE: {
                filter.addExtension("jdx");
                filter.addExtension("dx");
                filter.setDescription("JCAMP-DX Files");
                break;
            }
            default: {
                filter.addExtension(imode.toString().toLowerCase());
                filter.setDescription((Object)((Object)imode) + " Files");
            }
        }
        this.fc.setFileFilter(filter);
    }

    @Override
    public GenericFileInterface showFileOpenDialog(Object panelOrFrame, Object[] userData) {
        this.setFileChooser(ExportType.UNK);
        return this.getFile("", panelOrFrame, false);
    }

    @Override
    public GenericFileInterface getFile(String name, Object panelOrFrame, boolean isSave) {
        int returnVal;
        Component c = (Component)panelOrFrame;
        this.fc.setSelectedFile(new File(name));
        if (isSave) {
            if (this.useDirLastExported) {
                this.fc.setCurrentDirectory(new File(this.dirLastExported));
            }
        } else if (this.useDirLastOpened) {
            this.fc.setCurrentDirectory(new File(this.dirLastOpened));
        }
        int n = returnVal = isSave ? this.fc.showSaveDialog(c) : this.fc.showOpenDialog(c);
        if (returnVal != 0) {
            return null;
        }
        AwtFile file = new AwtFile(this.fc.getSelectedFile().getAbsolutePath());
        if (isSave) {
            int option;
            this.dirLastExported = file.getParent();
            this.vwr.setProperty("directoryLastExportedFile", this.dirLastExported);
            if (file.exists() && (option = JOptionPane.showConfirmDialog(c, "Overwrite " + file.getName() + "?", "Confirm Overwrite Existing File", 0, 3)) == 1) {
                return null;
            }
        } else {
            this.dirLastOpened = file.getParent();
            this.vwr.setProperty("directoryLastOpenedFile", this.dirLastOpened);
        }
        return file;
    }

    @Override
    public String setDirLastExported(String name) {
        this.dirLastExported = name;
        return this.dirLastExported;
    }

    @Override
    public String getUrlFromDialog(String info, String msg) {
        return (String)JOptionPane.showInputDialog(null, info, "Open URL", -1, null, null, msg);
    }
}

