/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.m2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.m2.DefaultPomDependencyMgt;
import org.apache.ivy.plugins.parser.m2.PomDependencyMgt;
import org.apache.ivy.plugins.parser.m2.PomModuleDescriptorBuilder;
import org.apache.ivy.plugins.parser.m2.PomReader;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;
import org.xml.sax.SAXException;

public final class PomModuleDescriptorParser
implements ModuleDescriptorParser {
    private static final PomModuleDescriptorParser INSTANCE = new PomModuleDescriptorParser();

    public static PomModuleDescriptorParser getInstance() {
        return INSTANCE;
    }

    private PomModuleDescriptorParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toIvyFile(InputStream is, Resource res, File destFile, ModuleDescriptor md) throws ParseException, IOException {
        try {
            XmlModuleDescriptorWriter.write(md, destFile);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public boolean accept(Resource res) {
        return res.getName().endsWith(".pom") || res.getName().endsWith("pom.xml") || res.getName().endsWith("project.xml");
    }

    public String toString() {
        return "pom parser";
    }

    @Override
    public Artifact getMetadataArtifact(ModuleRevisionId mrid, Resource res) {
        return DefaultArtifact.newPomArtifact(mrid, new Date(res.getLastModified()));
    }

    @Override
    public ModuleDescriptor parseDescriptor(ParserSettings ivySettings, URL descriptorURL, boolean validate) throws ParseException, IOException {
        URLResource resource = new URLResource(descriptorURL);
        return this.parseDescriptor(ivySettings, descriptorURL, resource, validate);
    }

    @Override
    public ModuleDescriptor parseDescriptor(ParserSettings ivySettings, URL descriptorURL, Resource res, boolean validate) throws ParseException, IOException {
        PomModuleDescriptorBuilder mdBuilder;
        block26: {
            mdBuilder = new PomModuleDescriptorBuilder(this, res, ivySettings);
            try {
                PomReader domReader = new PomReader(descriptorURL, res);
                domReader.setProperty("parent.version", domReader.getParentVersion());
                domReader.setProperty("parent.groupId", domReader.getParentGroupId());
                domReader.setProperty("project.parent.version", domReader.getParentVersion());
                domReader.setProperty("project.parent.groupId", domReader.getParentGroupId());
                Map pomProperties = domReader.getPomProperties();
                for (Map.Entry prop : pomProperties.entrySet()) {
                    domReader.setProperty((String)prop.getKey(), (String)prop.getValue());
                    mdBuilder.addProperty((String)prop.getKey(), (String)prop.getValue());
                }
                ModuleDescriptor parentDescr = null;
                if (domReader.hasParent()) {
                    ModuleRevisionId parentModRevID = ModuleRevisionId.newInstance(domReader.getParentGroupId(), domReader.getParentArtifactId(), domReader.getParentVersion());
                    ResolvedModuleRevision parentModule = this.parseOtherPom(ivySettings, parentModRevID);
                    if (parentModule == null) {
                        throw new IOException("Impossible to load parent for " + res.getName() + "." + " Parent=" + parentModRevID);
                    }
                    parentDescr = parentModule.getDescriptor();
                    if (parentDescr != null) {
                        Map parentPomProps = PomModuleDescriptorBuilder.extractPomProperties(parentDescr.getExtraInfos());
                        for (Map.Entry prop : parentPomProps.entrySet()) {
                            domReader.setProperty((String)prop.getKey(), (String)prop.getValue());
                        }
                    }
                }
                String groupId = domReader.getGroupId();
                String artifactId = domReader.getArtifactId();
                String version = domReader.getVersion();
                mdBuilder.setModuleRevId(groupId, artifactId, version);
                mdBuilder.setHomePage(domReader.getHomePage());
                mdBuilder.setDescription(domReader.getDescription());
                mdBuilder.setLicenses(domReader.getLicenses());
                ModuleRevisionId relocation = domReader.getRelocation();
                if (relocation != null) {
                    if (groupId != null && artifactId != null && artifactId.equals(relocation.getName()) && groupId.equals(relocation.getOrganisation())) {
                        Message.error("Relocation to an other version number not supported in ivy : " + mdBuilder.getModuleDescriptor().getModuleRevisionId() + " relocated to " + relocation + ". Please update your dependency to directly use the right version.");
                        Message.warn("Resolution will only pick dependencies of the relocated element.  Artefact and other metadata will be ignored.");
                        ResolvedModuleRevision relocatedModule = this.parseOtherPom(ivySettings, relocation);
                        if (relocatedModule == null) {
                            throw new ParseException("impossible to load module " + relocation + " to which " + mdBuilder.getModuleDescriptor().getModuleRevisionId() + " has been relocated", 0);
                        }
                        DependencyDescriptor[] dds = relocatedModule.getDescriptor().getDependencies();
                        for (int i = 0; i < dds.length; ++i) {
                            mdBuilder.addDependency(dds[i]);
                        }
                    } else {
                        Message.info(mdBuilder.getModuleDescriptor().getModuleRevisionId() + " is relocated to " + relocation + ". Please update your dependencies.");
                        Message.verbose("Relocated module will be considered as a dependency");
                        DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(mdBuilder.getModuleDescriptor(), relocation, true, false, true);
                        Configuration[] m2Confs = PomModuleDescriptorBuilder.MAVEN2_CONFIGURATIONS;
                        for (int i = 0; i < m2Confs.length; ++i) {
                            if (!Configuration.Visibility.PUBLIC.equals(m2Confs[i].getVisibility())) continue;
                            dd.addDependencyConfiguration(m2Confs[i].getName(), m2Confs[i].getName());
                        }
                        mdBuilder.addDependency(dd);
                    }
                    break block26;
                }
                domReader.setProperty("project.groupId", groupId);
                domReader.setProperty("pom.groupId", groupId);
                domReader.setProperty("groupId", groupId);
                domReader.setProperty("project.artifactId", artifactId);
                domReader.setProperty("pom.artifactId", artifactId);
                domReader.setProperty("artifactId", artifactId);
                domReader.setProperty("project.version", version);
                domReader.setProperty("pom.version", version);
                domReader.setProperty("version", version);
                if (parentDescr != null) {
                    mdBuilder.addExtraInfos(parentDescr.getExtraInfos());
                    List depMgt = PomModuleDescriptorBuilder.getDependencyManagements(parentDescr);
                    for (PomDependencyMgt dep : depMgt) {
                        if (dep instanceof PomReader.PomDependencyMgtElement) {
                            PomReader pomReader = domReader;
                            pomReader.getClass();
                            dep = new PomReader.PomDependencyMgtElement(pomReader, (PomReader.PomDependencyMgtElement)dep);
                        }
                        mdBuilder.addDependencyMgt(dep);
                    }
                    List plugins = PomModuleDescriptorBuilder.getPlugins(parentDescr);
                    Iterator it = plugins.iterator();
                    while (it.hasNext()) {
                        mdBuilder.addPlugin((PomDependencyMgt)it.next());
                    }
                }
                for (PomDependencyMgt dep : domReader.getDependencyMgt()) {
                    if ("import".equals(dep.getScope())) {
                        ModuleRevisionId importModRevID = ModuleRevisionId.newInstance(dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
                        ResolvedModuleRevision importModule = this.parseOtherPom(ivySettings, importModRevID);
                        if (importModule != null) {
                            ModuleDescriptor importDescr = importModule.getDescriptor();
                            List depMgt = PomModuleDescriptorBuilder.getDependencyManagements(importDescr);
                            for (PomDependencyMgt importedDepMgt : depMgt) {
                                mdBuilder.addDependencyMgt(new DefaultPomDependencyMgt(importedDepMgt.getGroupId(), importedDepMgt.getArtifactId(), importedDepMgt.getVersion(), importedDepMgt.getScope(), importedDepMgt.getExcludedModules()));
                            }
                            continue;
                        }
                        throw new IOException("Impossible to import module for " + res.getName() + "." + " Import=" + importModRevID);
                    }
                    mdBuilder.addDependencyMgt(dep);
                }
                for (PomDependencyMgt dep : domReader.getDependencies()) {
                    mdBuilder.addDependency(res, (PomReader.PomDependencyData)dep);
                }
                if (parentDescr != null) {
                    for (int i = 0; i < parentDescr.getDependencies().length; ++i) {
                        DependencyDescriptor descriptor = parentDescr.getDependencies()[i];
                        if (descriptor instanceof PomModuleDescriptorBuilder.PomDependencyDescriptor) {
                            PomReader.PomDependencyData parentDep = ((PomModuleDescriptorBuilder.PomDependencyDescriptor)descriptor).getPomDependencyData();
                            PomReader pomReader = domReader;
                            pomReader.getClass();
                            PomReader.PomDependencyData dep = new PomReader.PomDependencyData(pomReader, parentDep);
                            mdBuilder.addDependency(res, dep);
                            continue;
                        }
                        mdBuilder.addDependency(descriptor);
                    }
                }
                for (PomReader.PomPluginElement plugin : domReader.getPlugins()) {
                    mdBuilder.addPlugin(plugin);
                }
                mdBuilder.addMainArtifact(artifactId, domReader.getPackaging());
                this.addSourcesAndJavadocArtifactsIfPresent(mdBuilder, ivySettings);
            }
            catch (SAXException e) {
                throw this.newParserException(e);
            }
        }
        return mdBuilder.getModuleDescriptor();
    }

    private void addSourcesAndJavadocArtifactsIfPresent(PomModuleDescriptorBuilder mdBuilder, ParserSettings ivySettings) {
        if (mdBuilder.getMainArtifact() == null) {
            return;
        }
        ModuleDescriptor md = mdBuilder.getModuleDescriptor();
        ModuleRevisionId mrid = md.getModuleRevisionId();
        DependencyResolver resolver = ivySettings.getResolver(mrid);
        if (resolver == null) {
            Message.debug("no resolver found for " + mrid + ": no source or javadoc artifact lookup");
        } else {
            ArtifactOrigin mainArtifact = resolver.locate(mdBuilder.getMainArtifact());
            if (!ArtifactOrigin.isUnknown(mainArtifact)) {
                String mainArtifactLocation = mainArtifact.getLocation();
                ArtifactOrigin sourceArtifact = resolver.locate(mdBuilder.getSourceArtifact());
                if (!ArtifactOrigin.isUnknown(sourceArtifact) && !sourceArtifact.getLocation().equals(mainArtifactLocation)) {
                    Message.debug("source artifact found for " + mrid);
                    mdBuilder.addSourceArtifact();
                } else {
                    ArtifactOrigin srcArtifact = resolver.locate(mdBuilder.getSrcArtifact());
                    if (!ArtifactOrigin.isUnknown(srcArtifact) && !srcArtifact.getLocation().equals(mainArtifactLocation)) {
                        Message.debug("source artifact found for " + mrid);
                        mdBuilder.addSrcArtifact();
                    } else {
                        Message.debug("no source artifact found for " + mrid);
                    }
                }
                ArtifactOrigin javadocArtifact = resolver.locate(mdBuilder.getJavadocArtifact());
                if (!ArtifactOrigin.isUnknown(javadocArtifact) && !javadocArtifact.getLocation().equals(mainArtifactLocation)) {
                    Message.debug("javadoc artifact found for " + mrid);
                    mdBuilder.addJavadocArtifact();
                } else {
                    Message.debug("no javadoc artifact found for " + mrid);
                }
            }
        }
    }

    private ResolvedModuleRevision parseOtherPom(ParserSettings ivySettings, ModuleRevisionId parentModRevID) throws ParseException {
        DependencyResolver resolver;
        DependencyDescriptor dd = new DefaultDependencyDescriptor(parentModRevID, true);
        ResolveData data = IvyContext.getContext().getResolveData();
        if (data == null) {
            ResolveEngine engine = IvyContext.getContext().getIvy().getResolveEngine();
            ResolveOptions options = new ResolveOptions();
            options.setDownload(false);
            data = new ResolveData(engine, options);
        }
        if ((resolver = ivySettings.getResolver(parentModRevID)) == null) {
            return null;
        }
        dd = NameSpaceHelper.toSystem(dd, ivySettings.getContextNamespace());
        ResolvedModuleRevision otherModule = resolver.getDependency(dd, data);
        return otherModule;
    }

    private ParseException newParserException(Exception e) {
        Message.error(e.getMessage());
        ParseException pe = new ParseException(e.getMessage(), 0);
        pe.initCause(e);
        return pe;
    }
}

