/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Experimental;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.spelling.morfologik.suggestions_ordering.SuggestionsOrdererConfig;
import org.languagetool.server.IllegalConfigurationException;

public class HTTPServerConfig {
    private File fasttextModel;
    private File fasttextBinary;
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 8081;
    static final String LANGUAGE_MODEL_OPTION = "--languageModel";
    static final String WORD2VEC_MODEL_OPTION = "--word2vecModel";
    protected boolean verbose = false;
    protected boolean publicAccess = false;
    protected int port = 8081;
    protected String allowOriginUrl = null;
    protected int maxTextLength = Integer.MAX_VALUE;
    protected int maxTextHardLength = Integer.MAX_VALUE;
    protected int maxTextLengthWithApiKey = Integer.MAX_VALUE;
    protected String secretTokenKey = null;
    protected long maxCheckTimeMillis = -1L;
    protected long maxCheckTimeWithApiKeyMillis = -1L;
    protected int maxCheckThreads = 10;
    protected Mode mode;
    protected File languageModelDir = null;
    protected File word2vecModelDir = null;
    protected int requestLimit;
    protected int requestLimitInBytes;
    protected int timeoutRequestLimit;
    protected int requestLimitPeriodInSeconds;
    protected boolean trustXForwardForHeader;
    protected int maxWorkQueueSize;
    protected File rulesConfigFile = null;
    protected int cacheSize = 0;
    protected boolean warmUp = false;
    protected float maxErrorsPerWordRate = 0.0f;
    protected int maxSpellingSuggestions = 0;
    protected List<String> blockedReferrers = new ArrayList<String>();
    protected String hiddenMatchesServer;
    protected int hiddenMatchesServerTimeout;
    protected List<Language> hiddenMatchesLanguages = new ArrayList<Language>();
    protected String dbDriver = null;
    protected String dbUrl = null;
    protected String dbUsername = null;
    protected String dbPassword = null;

    public HTTPServerConfig() {
        this(8081, false);
    }

    public HTTPServerConfig(int serverPort) {
        this(serverPort, false);
    }

    public HTTPServerConfig(int serverPort, boolean verbose) {
        this.port = serverPort;
        this.verbose = verbose;
    }

    HTTPServerConfig(String[] args) {
        block22: for (int i = 0; i < args.length; ++i) {
            if (args[i].matches("--[a-zA-Z]+=.+")) {
                System.err.println("WARNING: use `--option value`, not `--option=value`, parameters will be ignored otherwise: " + args[i]);
            }
            switch (args[i]) {
                case "--config": {
                    this.parseConfigFile(new File(args[++i]), !ArrayUtils.contains(args, LANGUAGE_MODEL_OPTION), !ArrayUtils.contains(args, WORD2VEC_MODEL_OPTION));
                    continue block22;
                }
                case "-p": 
                case "--port": {
                    this.port = Integer.parseInt(args[++i]);
                    continue block22;
                }
                case "-v": 
                case "--verbose": {
                    this.verbose = true;
                    continue block22;
                }
                case "--public": {
                    this.publicAccess = true;
                    continue block22;
                }
                case "--allow-origin": {
                    try {
                        this.allowOriginUrl = args[++i];
                        if (!this.allowOriginUrl.startsWith("--")) continue block22;
                        throw new IllegalArgumentException("Missing argument for '--allow-origin' (e.g. an URL or '*')");
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new IllegalArgumentException("Missing argument for '--allow-origin' (e.g. an URL or '*')");
                    }
                }
                case "--languageModel": {
                    this.setLanguageModelDirectory(args[++i]);
                    continue block22;
                }
                case "--word2vecModel": {
                    this.setWord2VecModelDirectory(args[++i]);
                    continue block22;
                }
                default: {
                    if (args[i].contains("=")) {
                        System.out.println("WARNING: unknown option: " + args[i] + " - please note that parameters are given as '--arg param', i.e. without '=' between argument and parameter");
                        continue block22;
                    }
                    System.out.println("WARNING: unknown option: " + args[i]);
                }
            }
        }
    }

    private void parseConfigFile(File file, boolean loadLangModel, boolean loadWord2VecModel) {
        try {
            Properties props = new Properties();
            try (FileInputStream fis = new FileInputStream(file);){
                String word2vecModel;
                props.load(fis);
                this.maxTextLength = Integer.parseInt(this.getOptionalProperty(props, "maxTextLength", Integer.toString(Integer.MAX_VALUE)));
                this.maxTextLengthWithApiKey = Integer.parseInt(this.getOptionalProperty(props, "maxTextLengthWithApiKey", Integer.toString(Integer.MAX_VALUE)));
                this.maxTextHardLength = Integer.parseInt(this.getOptionalProperty(props, "maxTextHardLength", Integer.toString(Integer.MAX_VALUE)));
                this.secretTokenKey = this.getOptionalProperty(props, "secretTokenKey", null);
                this.maxCheckTimeMillis = Long.parseLong(this.getOptionalProperty(props, "maxCheckTimeMillis", "-1"));
                this.maxCheckTimeWithApiKeyMillis = Long.parseLong(this.getOptionalProperty(props, "maxCheckTimeWithApiKeyMillis", "-1"));
                this.requestLimit = Integer.parseInt(this.getOptionalProperty(props, "requestLimit", "0"));
                this.requestLimitInBytes = Integer.parseInt(this.getOptionalProperty(props, "requestLimitInBytes", "0"));
                this.timeoutRequestLimit = Integer.parseInt(this.getOptionalProperty(props, "timeoutRequestLimit", "0"));
                this.requestLimitPeriodInSeconds = Integer.parseInt(this.getOptionalProperty(props, "requestLimitPeriodInSeconds", "0"));
                this.trustXForwardForHeader = Boolean.valueOf(this.getOptionalProperty(props, "trustXForwardForHeader", "false"));
                this.maxWorkQueueSize = Integer.parseInt(this.getOptionalProperty(props, "maxWorkQueueSize", "0"));
                if (this.maxWorkQueueSize < 0) {
                    throw new IllegalArgumentException("maxWorkQueueSize must be >= 0: " + this.maxWorkQueueSize);
                }
                String langModel = this.getOptionalProperty(props, "languageModel", null);
                if (langModel != null && loadLangModel) {
                    this.setLanguageModelDirectory(langModel);
                }
                if ((word2vecModel = this.getOptionalProperty(props, "word2vecModel", null)) != null && loadWord2VecModel) {
                    this.setWord2VecModelDirectory(word2vecModel);
                }
                String fasttextModel = this.getOptionalProperty(props, "fasttextModel", null);
                String fasttextBinary = this.getOptionalProperty(props, "fasttextBinary", null);
                if (fasttextBinary != null && fasttextModel != null) {
                    this.setFasttextPaths(fasttextModel, fasttextBinary);
                }
                this.maxCheckThreads = Integer.parseInt(this.getOptionalProperty(props, "maxCheckThreads", "10"));
                if (this.maxCheckThreads < 1) {
                    throw new IllegalArgumentException("Invalid value for maxCheckThreads, must be >= 1: " + this.maxCheckThreads);
                }
                boolean atdMode = this.getOptionalProperty(props, "mode", "LanguageTool").equalsIgnoreCase("AfterTheDeadline");
                if (atdMode) {
                    throw new IllegalArgumentException("The AfterTheDeadline mode is not supported anymore in LanguageTool 3.8 or later");
                }
                String rulesConfigFilePath = this.getOptionalProperty(props, "rulesFile", null);
                if (rulesConfigFilePath != null) {
                    this.rulesConfigFile = new File(rulesConfigFilePath);
                    if (!this.rulesConfigFile.exists() || !this.rulesConfigFile.isFile()) {
                        throw new RuntimeException("Rules Configuration file can not be found: " + this.rulesConfigFile);
                    }
                }
                this.cacheSize = Integer.parseInt(this.getOptionalProperty(props, "cacheSize", "0"));
                if (this.cacheSize < 0) {
                    throw new IllegalArgumentException("Invalid value for cacheSize: " + this.cacheSize + ", use 0 to deactivate cache");
                }
                String warmUpStr = this.getOptionalProperty(props, "warmUp", "false");
                if (warmUpStr.equals("true")) {
                    this.warmUp = true;
                } else if (warmUpStr.equals("false")) {
                    this.warmUp = false;
                } else {
                    throw new IllegalArgumentException("Invalid value for warmUp: '" + warmUpStr + "', use 'true' or 'false'");
                }
                this.maxErrorsPerWordRate = Float.parseFloat(this.getOptionalProperty(props, "maxErrorsPerWordRate", "0"));
                this.maxSpellingSuggestions = Integer.parseInt(this.getOptionalProperty(props, "maxSpellingSuggestions", "0"));
                this.blockedReferrers = Arrays.asList(this.getOptionalProperty(props, "blockedReferrers", "").split(",\\s*"));
                this.hiddenMatchesServer = this.getOptionalProperty(props, "hiddenMatchesServer", null);
                this.hiddenMatchesServerTimeout = Integer.parseInt(this.getOptionalProperty(props, "hiddenMatchesServerTimeout", "1000"));
                String langCodes = this.getOptionalProperty(props, "hiddenMatchesLanguages", "");
                for (String code : langCodes.split(",\\s*")) {
                    if (code.isEmpty()) continue;
                    this.hiddenMatchesLanguages.add(Languages.getLanguageForShortCode(code));
                }
                this.dbDriver = this.getOptionalProperty(props, "dbDriver", null);
                this.dbUrl = this.getOptionalProperty(props, "dbUrl", null);
                this.dbUsername = this.getOptionalProperty(props, "dbUsername", null);
                this.dbPassword = this.getOptionalProperty(props, "dbPassword", null);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load properties from '" + file + "'", e);
        }
    }

    private void setLanguageModelDirectory(String langModelDir) {
        SuggestionsOrdererConfig.setNgramsPath(langModelDir);
        this.languageModelDir = new File(langModelDir);
        if (!this.languageModelDir.exists() || !this.languageModelDir.isDirectory()) {
            throw new RuntimeException("LanguageModel directory not found or is not a directory: " + this.languageModelDir);
        }
    }

    private void setWord2VecModelDirectory(String w2vModelDir) {
        this.word2vecModelDir = new File(w2vModelDir);
        if (!this.word2vecModelDir.exists() || !this.word2vecModelDir.isDirectory()) {
            throw new RuntimeException("Word2Vec directory not found or is not a directory: " + this.word2vecModelDir);
        }
    }

    private void setFasttextPaths(String fasttextModelPath, String fasttextBinaryPath) {
        this.fasttextModel = new File(fasttextModelPath);
        this.fasttextBinary = new File(fasttextBinaryPath);
        if (!this.fasttextModel.exists() || this.fasttextModel.isDirectory()) {
            throw new RuntimeException("Fasttext model path not valid (file doesn't exist or is a directory): " + fasttextModelPath);
        }
        if (!this.fasttextBinary.exists() || this.fasttextBinary.isDirectory() || !this.fasttextBinary.canExecute()) {
            throw new RuntimeException("Fasttext binary path not valid (file doesn't exist, is a directory or not executable): " + fasttextBinaryPath);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isPublicAccess() {
        return this.publicAccess;
    }

    public int getPort() {
        return this.port;
    }

    @Nullable
    public String getAllowOriginUrl() {
        return this.allowOriginUrl;
    }

    public void setAllowOriginUrl(String allowOriginUrl) {
        this.allowOriginUrl = allowOriginUrl;
    }

    public void setMaxTextLength(int len) {
        this.maxTextLength = len;
    }

    public void setMaxTextHardLength(int len) {
        this.maxTextHardLength = len;
    }

    int getMaxTextLength() {
        return this.maxTextLength;
    }

    @Experimental
    int getMaxTextLengthWithApiKey() {
        return this.maxTextLengthWithApiKey;
    }

    int getMaxTextHardLength() {
        return this.maxTextHardLength;
    }

    @Nullable
    String getSecretTokenKey() {
        return this.secretTokenKey;
    }

    void setSecretTokenKey(String secretTokenKey) {
        this.secretTokenKey = secretTokenKey;
    }

    int getRequestLimit() {
        return this.requestLimit;
    }

    int getTimeoutRequestLimit() {
        return this.timeoutRequestLimit;
    }

    int getRequestLimitInBytes() {
        return this.requestLimitInBytes;
    }

    int getRequestLimitPeriodInSeconds() {
        return this.requestLimitPeriodInSeconds;
    }

    void setMaxCheckTimeMillis(int maxCheckTimeMillis) {
        this.maxCheckTimeMillis = maxCheckTimeMillis;
    }

    long getMaxCheckTimeMillis() {
        return this.maxCheckTimeMillis;
    }

    @Experimental
    long getMaxCheckTimeWithApiKeyMillis() {
        return this.maxCheckTimeWithApiKeyMillis;
    }

    @Nullable
    File getLanguageModelDir() {
        return this.languageModelDir;
    }

    @Nullable
    File getWord2VecModelDir() {
        return this.word2vecModelDir;
    }

    @Nullable
    public File getFasttextModel() {
        return this.fasttextModel;
    }

    @Nullable
    public File getFasttextBinary() {
        return this.fasttextBinary;
    }

    Mode getMode() {
        return this.mode;
    }

    void setMaxCheckThreads(int maxCheckThreads) {
        this.maxCheckThreads = maxCheckThreads;
    }

    int getMaxCheckThreads() {
        return this.maxCheckThreads;
    }

    void setTrustXForwardForHeader(boolean trustXForwardForHeader) {
        this.trustXForwardForHeader = trustXForwardForHeader;
    }

    boolean getTrustXForwardForHeader() {
        return this.trustXForwardForHeader;
    }

    int getMaxWorkQueueSize() {
        return this.maxWorkQueueSize;
    }

    int getCacheSize() {
        return this.cacheSize;
    }

    void setCacheSize(int sentenceCacheSize) {
        this.cacheSize = sentenceCacheSize;
    }

    boolean getWarmUp() {
        return this.warmUp;
    }

    float getMaxErrorsPerWordRate() {
        return this.maxErrorsPerWordRate;
    }

    int getMaxSpellingSuggestions() {
        return this.maxSpellingSuggestions;
    }

    @NotNull
    List<String> getBlockedReferrers() {
        return this.blockedReferrers;
    }

    void setBlockedReferrers(List<String> blockedReferrers) {
        this.blockedReferrers = Objects.requireNonNull(blockedReferrers);
    }

    @Nullable
    @Experimental
    String getHiddenMatchesServer() {
        return this.hiddenMatchesServer;
    }

    @Experimental
    int getHiddenMatchesServerTimeout() {
        return this.hiddenMatchesServerTimeout;
    }

    @Experimental
    List<Language> getHiddenMatchesLanguages() {
        return this.hiddenMatchesLanguages;
    }

    @Nullable
    File getRulesConfigFile() {
        return this.rulesConfigFile;
    }

    @Nullable
    @Experimental
    String getDatabaseDriver() {
        return this.dbDriver;
    }

    @Experimental
    void setDatabaseDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }

    @Nullable
    @Experimental
    String getDatabaseUrl() {
        return this.dbUrl;
    }

    @Experimental
    void setDatabaseUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    @Nullable
    @Experimental
    String getDatabaseUsername() {
        return this.dbUsername;
    }

    @Experimental
    void setDatabaseUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    @Nullable
    @Experimental
    String getDatabasePassword() {
        return this.dbPassword;
    }

    @Experimental
    void setDatabasePassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    protected String getProperty(Properties props, String propertyName, File config) {
        String propertyValue = (String)props.get(propertyName);
        if (propertyValue == null || propertyValue.trim().isEmpty()) {
            throw new IllegalConfigurationException("Property '" + propertyName + "' must be set in " + config);
        }
        return propertyValue;
    }

    protected String getOptionalProperty(Properties props, String propertyName, String defaultValue) {
        String propertyValue = (String)props.get(propertyName);
        if (propertyValue == null) {
            return defaultValue;
        }
        return propertyValue;
    }

    static enum Mode {
        LanguageTool;

    }
}

