/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Random;
import javax.media.j3d.BHInternalNode;
import javax.media.j3d.BHNode;
import javax.media.j3d.BHTree;

class BHInsertStructure {
    static boolean debug = false;
    static boolean debug2 = false;
    Random randomNumber = new Random(0L);
    ArrayList[] bhListArr = null;
    ArrayList[] oldBhListArr = null;
    BHNode[] bhListArrRef = null;
    BHNode[] oldBhListArrRef = null;
    int bhListArrCnt = 0;
    int bhListArrMaxCnt = 0;
    int blockSize = 0;

    BHInsertStructure(int n) {
        if (n > 50) {
            n = 50;
        }
        this.blockSize = 50;
        this.bhListArr = new ArrayList[n];
        this.bhListArrRef = new BHNode[n];
        this.bhListArrCnt = 0;
        this.bhListArrMaxCnt = n;
    }

    void clear() {
        for (int i = 0; i < this.bhListArrCnt; ++i) {
            this.bhListArr[i].clear();
            this.bhListArrRef[i] = null;
        }
        this.bhListArrCnt = 0;
    }

    void lookupAndInsert(BHNode bHNode, BHNode bHNode2) {
        boolean bl = false;
        for (int i = 0; i < this.bhListArrCnt; ++i) {
            if (this.bhListArrRef[i] != bHNode) continue;
            this.bhListArr[i].add(bHNode2);
            bl = true;
            break;
        }
        if (!bl) {
            if (this.bhListArrCnt >= this.bhListArrMaxCnt) {
                if (debug) {
                    System.err.println("(1) Expanding bhListArr array ...");
                }
                this.bhListArrMaxCnt += this.blockSize;
                this.oldBhListArr = this.bhListArr;
                this.oldBhListArrRef = this.bhListArrRef;
                this.bhListArr = new ArrayList[this.bhListArrMaxCnt];
                this.bhListArrRef = new BHNode[this.bhListArrMaxCnt];
                System.arraycopy(this.oldBhListArr, 0, this.bhListArr, 0, this.oldBhListArr.length);
                System.arraycopy(this.oldBhListArrRef, 0, this.bhListArrRef, 0, this.oldBhListArrRef.length);
            }
            this.bhListArrRef[this.bhListArrCnt] = bHNode;
            this.bhListArr[this.bhListArrCnt] = new ArrayList();
            this.bhListArr[this.bhListArrCnt].add(bHNode2);
            ++this.bhListArrCnt;
        }
    }

    void updateBoundingTree(BHTree bHTree) {
        for (int i = 0; i < this.bhListArrCnt; ++i) {
            int n = 0;
            BHNode bHNode = ((BHInternalNode)this.bhListArrRef[i]).getLeftChild();
            BHNode bHNode2 = ((BHInternalNode)this.bhListArrRef[i]).getRightChild();
            if (bHNode != null) {
                ++n;
            }
            if (bHNode2 != null) {
                ++n;
            }
            int n2 = this.bhListArr[i].size();
            BHNode[] bHNodeArray = new BHNode[n + n2];
            this.bhListArr[i].toArray(bHNodeArray);
            n = 0;
            if (bHNode != null) {
                bHNodeArray[n2] = bHNode;
                bHNodeArray[n2 + ++n] = bHNode2;
            }
            if (debug2 && (bHNode == null || bHNode2 == null)) {
                System.err.println("child1 or child2 is null ...");
                System.err.println("This is bad, it shouldn't happen");
            }
            ((BHInternalNode)this.bhListArrRef[i]).setRightChild(null);
            ((BHInternalNode)this.bhListArrRef[i]).setLeftChild(null);
            bHTree.cluster((BHInternalNode)this.bhListArrRef[i], bHNodeArray);
        }
    }
}

